/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.logging;

import com.intellij.diagnostic.logging.LogConsoleManager;
import com.intellij.execution.configurations.AdditionalTabComponentManager;
import com.intellij.execution.configurations.LogFileOptions;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import java.io.File;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogFilesManager {
    private final LogConsoleManager myManager;

    public LogFilesManager(@NotNull LogConsoleManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/diagnostic/logging/LogFilesManager", "<init>"));
        }
        this.myManager = manager;
    }

    public void addLogConsoles(@NotNull RunConfigurationBase runConfiguration, @Nullable ProcessHandler startedProcess) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/diagnostic/logging/LogFilesManager", "addLogConsoles"));
        }
        for (LogFileOptions logFileOptions : runConfiguration.getAllLogFiles()) {
            if (!logFileOptions.isEnabled()) continue;
            this.addConfigurationConsoles(logFileOptions, (Condition<String>)Conditions.alwaysTrue(), logFileOptions.getPaths(), runConfiguration);
        }
        runConfiguration.createAdditionalTabComponents((AdditionalTabComponentManager)this.myManager, startedProcess);
    }

    private void addConfigurationConsoles(@NotNull LogFileOptions logFile, @NotNull Condition<String> shouldInclude, @NotNull Set<String> paths, @NotNull RunConfigurationBase runConfiguration) {
        if (logFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logFile", "com/intellij/diagnostic/logging/LogFilesManager", "addConfigurationConsoles"));
        }
        if (shouldInclude == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shouldInclude", "com/intellij/diagnostic/logging/LogFilesManager", "addConfigurationConsoles"));
        }
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "com/intellij/diagnostic/logging/LogFilesManager", "addConfigurationConsoles"));
        }
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/diagnostic/logging/LogFilesManager", "addConfigurationConsoles"));
        }
        if (paths.isEmpty()) {
            return;
        }
        TreeMap<String, String> titleToPath = new TreeMap<String, String>();
        if (paths.size() == 1) {
            String path = paths.iterator().next();
            if (shouldInclude.value((Object)path)) {
                titleToPath.put(logFile.getName(), path);
            }
        } else {
            for (String path : paths) {
                if (!shouldInclude.value((Object)path)) continue;
                String title = new File(path).getName();
                if (titleToPath.containsKey(title)) {
                    title = path;
                }
                titleToPath.put(title, path);
            }
        }
        for (String title : titleToPath.keySet()) {
            String path = (String)titleToPath.get(title);
            assert (path != null);
            this.myManager.addLogConsole(title, path, logFile.getCharset(), logFile.isSkipContent() ? new File(path).length() : 0L, runConfiguration);
        }
    }
}

