/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.jar;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configuration.ConfigurationFactoryEx;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeBase;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.jar.JarApplicationConfiguration;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class JarApplicationConfigurationType
extends ConfigurationTypeBase
implements ConfigurationType {
    @NotNull
    public static JarApplicationConfigurationType getInstance() {
        JarApplicationConfigurationType jarApplicationConfigurationType = (JarApplicationConfigurationType)ConfigurationTypeUtil.findConfigurationType(JarApplicationConfigurationType.class);
        if (jarApplicationConfigurationType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/jar/JarApplicationConfigurationType", "getInstance"));
        }
        return jarApplicationConfigurationType;
    }

    public JarApplicationConfigurationType() {
        super("JarApplication", ExecutionBundle.message((String)"jar.application.configuration.name", (Object[])new Object[0]), ExecutionBundle.message((String)"jar.application.configuration.description", (Object[])new Object[0]), AllIcons.FileTypes.Archive);
        this.addFactory(new ConfigurationFactoryEx(this){

            @Override
            public void onNewConfigurationCreated(@NotNull RunConfiguration configuration) {
                if (configuration == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/execution/jar/JarApplicationConfigurationType$1", "onNewConfigurationCreated"));
                }
                JarApplicationConfiguration jarApplicationConfiguration = (JarApplicationConfiguration)configuration;
                if (StringUtil.isEmpty((String)jarApplicationConfiguration.getWorkingDirectory())) {
                    String baseDir = FileUtil.toSystemIndependentName((String)StringUtil.notNullize((String)configuration.getProject().getBasePath()));
                    jarApplicationConfiguration.setWorkingDirectory(baseDir);
                }
            }

            public RunConfiguration createTemplateConfiguration(Project project) {
                return new JarApplicationConfiguration(project, this, "");
            }
        });
    }
}

