/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.SaveFileAsTemplateHandler;
import com.intellij.ide.fileTemplates.impl.AllFileTemplatesConfigurable;
import com.intellij.ide.fileTemplates.ui.ConfigureTemplatesDialog;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;

public class SaveFileAsTemplateAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        String fileText = (String)ObjectUtils.assertNotNull((Object)e.getData(PlatformDataKeys.FILE_TEXT));
        VirtualFile file = (VirtualFile)ObjectUtils.assertNotNull((Object)e.getData(CommonDataKeys.VIRTUAL_FILE));
        String extension = (String)ObjectUtils.assertNotNull((Object)file.getExtension());
        String nameWithoutExtension = file.getNameWithoutExtension();
        AllFileTemplatesConfigurable fileTemplateOptions = new AllFileTemplatesConfigurable();
        ConfigureTemplatesDialog dialog = new ConfigureTemplatesDialog(project, fileTemplateOptions);
        fileTemplateOptions.selectTemplatesTab();
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        for (SaveFileAsTemplateHandler handler : (SaveFileAsTemplateHandler[])Extensions.getExtensions(SaveFileAsTemplateHandler.EP_NAME)) {
            String textFromHandler = handler.getTemplateText(psiFile, fileText, nameWithoutExtension);
            if (textFromHandler == null) continue;
            fileText = textFromHandler;
            break;
        }
        fileTemplateOptions.createNewTemplate(nameWithoutExtension, extension, fileText);
        dialog.show();
    }

    public void update(AnActionEvent e) {
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        String fileText = (String)e.getData(PlatformDataKeys.FILE_TEXT);
        e.getPresentation().setEnabled(fileText != null && file != null && file.getExtension() != null);
    }
}

