/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.customization;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.customization.ActionUrl;
import com.intellij.ide.ui.customization.CustomizableActionGroupProvider;
import com.intellij.ide.ui.customization.CustomizationUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ExportableComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.impl.ui.ActionsTreeUtil;
import com.intellij.openapi.keymap.impl.ui.Group;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.NamedJDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.util.ImageLoader;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CustomActionsSchema
implements ExportableComponent,
NamedJDOMExternalizable {
    @NonNls
    private static final String ACTIONS_SCHEMA = "custom_actions_schema";
    @NonNls
    private static final String ACTIVE = "active";
    @NonNls
    private static final String ELEMENT_ACTION = "action";
    @NonNls
    private static final String ATTRIBUTE_ID = "id";
    @NonNls
    private static final String ATTRIBUTE_ICON = "icon";
    private final Map<String, String> myIconCustomizations = new HashMap<String, String>();
    private ArrayList<ActionUrl> myActions = new ArrayList();
    private final HashMap<String, ActionGroup> myIdToActionGroup = new HashMap();
    private final List<Pair> myIdToNameList = new ArrayList<Pair>();
    @NonNls
    private static final String GROUP = "group";
    private static final Logger LOG = Logger.getInstance((String)("#" + CustomActionsSchema.class.getName()));

    public CustomActionsSchema() {
        this.myIdToNameList.add(new Pair("MainMenu", ActionsTreeUtil.MAIN_MENU_TITLE));
        this.myIdToNameList.add(new Pair("MainToolBar", ActionsTreeUtil.MAIN_TOOLBAR));
        this.myIdToNameList.add(new Pair("EditorPopupMenu", ActionsTreeUtil.EDITOR_POPUP));
        this.myIdToNameList.add(new Pair("EditorGutterPopupMenu", "Editor Gutter Popup Menu"));
        this.myIdToNameList.add(new Pair("EditorTabPopupMenu", ActionsTreeUtil.EDITOR_TAB_POPUP));
        this.myIdToNameList.add(new Pair("ProjectViewPopupMenu", ActionsTreeUtil.PROJECT_VIEW_POPUP));
        this.myIdToNameList.add(new Pair("ScopeViewPopupMenu", "Scope View Popup Menu"));
        this.myIdToNameList.add(new Pair("FavoritesViewPopupMenu", ActionsTreeUtil.FAVORITES_POPUP));
        this.myIdToNameList.add(new Pair("CommanderPopupMenu", ActionsTreeUtil.COMMANDER_POPUP));
        this.myIdToNameList.add(new Pair("J2EEViewPopupMenu", ActionsTreeUtil.J2EE_POPUP));
        this.myIdToNameList.add(new Pair("NavbarPopupMenu", "Navigation Bar"));
        this.myIdToNameList.add(new Pair("NavBarToolBar", "Navigation Bar Toolbar"));
        CustomizableActionGroupProvider.CustomizableActionGroupRegistrar registrar = new CustomizableActionGroupProvider.CustomizableActionGroupRegistrar(){

            @Override
            public void addCustomizableActionGroup(@NotNull String groupId, @NotNull String groupTitle) {
                if (groupId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "com/intellij/ide/ui/customization/CustomActionsSchema$1", "addCustomizableActionGroup"));
                }
                if (groupTitle == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupTitle", "com/intellij/ide/ui/customization/CustomActionsSchema$1", "addCustomizableActionGroup"));
                }
                CustomActionsSchema.this.myIdToNameList.add(new Pair(groupId, groupTitle));
            }
        };
        for (CustomizableActionGroupProvider provider : (CustomizableActionGroupProvider[])CustomizableActionGroupProvider.EP_NAME.getExtensions()) {
            provider.registerGroups(registrar);
        }
    }

    public static CustomActionsSchema getInstance() {
        return (CustomActionsSchema)ServiceManager.getService(CustomActionsSchema.class);
    }

    public void addAction(ActionUrl url) {
        this.myActions.add(url);
        this.resortActions();
    }

    public ArrayList<ActionUrl> getActions() {
        return this.myActions;
    }

    public void setActions(ArrayList<ActionUrl> actions) {
        this.myActions = actions;
        this.resortActions();
    }

    public void copyFrom(CustomActionsSchema result) {
        this.myIdToActionGroup.clear();
        this.myActions.clear();
        this.myIconCustomizations.clear();
        for (ActionUrl actionUrl : result.myActions) {
            ActionUrl url = new ActionUrl(new ArrayList<String>(actionUrl.getGroupPath()), actionUrl.getComponent(), actionUrl.getActionType(), actionUrl.getAbsolutePosition());
            url.setInitialPosition(actionUrl.getInitialPosition());
            this.myActions.add(url);
        }
        this.resortActions();
        this.myIconCustomizations.putAll(result.myIconCustomizations);
    }

    private void resortActions() {
        Collections.sort(this.myActions, ActionUrlComparator.INSTANCE);
    }

    public boolean isModified(CustomActionsSchema schema) {
        ArrayList<ActionUrl> storedActions = schema.getActions();
        if (ApplicationManager.getApplication().isUnitTestMode() && !storedActions.isEmpty()) {
            System.err.println("stored: " + storedActions.toString());
            System.err.println("actual: " + this.getActions().toString());
        }
        if (storedActions.size() != this.getActions().size()) {
            return true;
        }
        for (int i = 0; i < this.getActions().size(); ++i) {
            if (this.getActions().get(i).equals(storedActions.get(i))) continue;
            return true;
        }
        if (schema.myIconCustomizations.size() != this.myIconCustomizations.size()) {
            return true;
        }
        for (String actionId : this.myIconCustomizations.keySet()) {
            if (Comparing.strEqual((String)schema.getIconPath(actionId), (String)this.getIconPath(actionId))) continue;
            return true;
        }
        return false;
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        Element schElement = element;
        String activeName = element.getAttributeValue(ACTIVE);
        if (activeName != null) {
            block0: for (Element toolbarElement : element.getChildren(ACTIONS_SCHEMA)) {
                for (Element o : toolbarElement.getChildren("option")) {
                    if (!Comparing.strEqual((String)o.getAttributeValue("name"), (String)"myName") || !Comparing.strEqual((String)o.getAttributeValue("value"), (String)activeName)) continue;
                    schElement = toolbarElement;
                    continue block0;
                }
            }
        }
        for (Element groupElement : schElement.getChildren(GROUP)) {
            ActionUrl url = new ActionUrl();
            url.readExternal(groupElement);
            this.myActions.add(url);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            System.err.println("read custom actions: " + this.myActions.toString());
        }
        this.readIcons(element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        this.writeActions(element);
        this.writeIcons(element);
    }

    private void writeActions(Element element) throws WriteExternalException {
        for (ActionUrl group : this.myActions) {
            Element groupElement = new Element(GROUP);
            group.writeExternal(groupElement);
            element.addContent(groupElement);
        }
    }

    public AnAction getCorrectedAction(String id) {
        if (!this.myIdToNameList.contains(new Pair(id, ""))) {
            return ActionManager.getInstance().getAction(id);
        }
        if (this.myIdToActionGroup.get(id) == null) {
            for (Pair pair : this.myIdToNameList) {
                ActionGroup actionGroup;
                if (!pair.first.equals(id) || (actionGroup = (ActionGroup)ActionManager.getInstance().getAction(id)) == null) continue;
                this.myIdToActionGroup.put(id, CustomizationUtil.correctActionGroup(actionGroup, this, pair.second, pair.second));
            }
        }
        return (AnAction)this.myIdToActionGroup.get(id);
    }

    public void resetMainActionGroups() {
        for (Pair pair : this.myIdToNameList) {
            ActionGroup actionGroup = (ActionGroup)ActionManager.getInstance().getAction(pair.first);
            if (actionGroup == null) continue;
            this.myIdToActionGroup.put(pair.first, CustomizationUtil.correctActionGroup(actionGroup, this, pair.second, pair.second));
        }
    }

    public void fillActionGroups(DefaultMutableTreeNode root) {
        ActionManager actionManager = ActionManager.getInstance();
        for (Pair pair : this.myIdToNameList) {
            ActionGroup actionGroup = (ActionGroup)actionManager.getAction(pair.first);
            if (actionGroup == null) continue;
            root.add(ActionsTreeUtil.createNode(ActionsTreeUtil.createGroup(actionGroup, pair.second, null, null, true, null, false)));
        }
    }

    public boolean isCorrectActionGroup(ActionGroup group, String defaultGroupName) {
        if (this.myActions.isEmpty()) {
            return false;
        }
        String text = group.getTemplatePresentation().getText();
        if (!StringUtil.isEmpty((String)text)) {
            for (ActionUrl url : this.myActions) {
                String id;
                if (url.getGroupPath().contains(text) || url.getGroupPath().contains(defaultGroupName)) {
                    return true;
                }
                if (!(url.getComponent() instanceof Group)) continue;
                Group urlGroup = (Group)url.getComponent();
                String string = id = urlGroup.getName() != null ? urlGroup.getName() : urlGroup.getId();
                if (id != null && !id.equals(text) && !id.equals(defaultGroupName)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public List<ActionUrl> getChildActions(ActionUrl url) {
        ArrayList<ActionUrl> result = new ArrayList<ActionUrl>();
        ArrayList<String> groupPath = url.getGroupPath();
        for (ActionUrl actionUrl : this.myActions) {
            int index;
            if (groupPath.size() > actionUrl.getGroupPath().size()) continue;
            for (index = 0; index < groupPath.size() && Comparing.equal((String)groupPath.get(index), (String)actionUrl.getGroupPath().get(index)); ++index) {
            }
            if (index != groupPath.size()) continue;
            result.add(actionUrl);
        }
        return result;
    }

    public void removeIconCustomization(String actionId) {
        this.myIconCustomizations.remove(actionId);
    }

    public void addIconCustomization(String actionId, String iconPath) {
        this.myIconCustomizations.put(actionId, iconPath != null ? FileUtil.toSystemIndependentName((String)iconPath) : null);
    }

    public String getIconPath(String actionId) {
        String path = this.myIconCustomizations.get(actionId);
        return path == null ? "" : path;
    }

    private void readIcons(Element parent) {
        Iterator i$ = parent.getChildren(ELEMENT_ACTION).iterator();
        while (i$.hasNext()) {
            Element actionO;
            Element action = actionO = (Element)i$.next();
            String actionId = action.getAttributeValue(ATTRIBUTE_ID);
            String iconPath = action.getAttributeValue(ATTRIBUTE_ICON);
            if (actionId == null) continue;
            this.myIconCustomizations.put(actionId, iconPath);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CustomActionsSchema.this.initActionIcons();
            }
        });
    }

    private void writeIcons(Element parent) {
        for (String actionId : this.myIconCustomizations.keySet()) {
            Element action = new Element(ELEMENT_ACTION);
            action.setAttribute(ATTRIBUTE_ID, actionId);
            String icon = this.myIconCustomizations.get(actionId);
            if (icon != null) {
                action.setAttribute(ATTRIBUTE_ICON, icon);
            }
            parent.addContent(action);
        }
    }

    private void initActionIcons() {
        ActionManager actionManager = ActionManager.getInstance();
        for (String actionId : this.myIconCustomizations.keySet()) {
            Icon icon;
            AnAction anAction = actionManager.getAction(actionId);
            if (anAction == null) continue;
            String iconPath = this.myIconCustomizations.get(actionId);
            if (iconPath != null && new File(FileUtil.toSystemDependentName((String)iconPath)).exists()) {
                Image image = null;
                try {
                    image = ImageLoader.loadFromStream((InputStream)VfsUtil.convertToURL((String)VfsUtil.pathToUrl((String)iconPath)).openStream());
                }
                catch (IOException e) {
                    LOG.debug((Throwable)e);
                }
                icon = image != null ? IconLoader.getIcon((Image)image) : null;
            } else {
                icon = AllIcons.Toolbar.Unknown;
            }
            if (anAction.getTemplatePresentation() == null) continue;
            anAction.getTemplatePresentation().setIcon(icon);
            anAction.getTemplatePresentation().setDisabledIcon(IconLoader.getDisabledIcon((Icon)icon));
            anAction.setDefaultIcon(false);
        }
        IdeFrameImpl frame = WindowManagerEx.getInstanceEx().getFrame(null);
        if (frame != null) {
            frame.updateView();
        }
    }

    @NotNull
    public File[] getExportFiles() {
        File[] fileArray = new File[]{PathManager.getOptionsFile((NamedJDOMExternalizable)this)};
        if (fileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/ui/customization/CustomActionsSchema", "getExportFiles"));
        }
        return fileArray;
    }

    @NotNull
    public String getPresentableName() {
        String string = IdeBundle.message((String)"title.custom.actions.schemas", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/ui/customization/CustomActionsSchema", "getPresentableName"));
        }
        return string;
    }

    public String getExternalFileName() {
        return "customization";
    }

    private static class ActionUrlComparator
    implements Comparator<ActionUrl> {
        public static ActionUrlComparator INSTANCE = new ActionUrlComparator();
        private static final int DELETED = 1;
        private static final int ADDED = 2;

        private ActionUrlComparator() {
        }

        @Override
        public int compare(ActionUrl u1, ActionUrl u2) {
            int w2;
            int w1 = ActionUrlComparator.getEquivalenceClass(u1);
            if (w1 != (w2 = ActionUrlComparator.getEquivalenceClass(u2))) {
                return w1 - w2;
            }
            if (w1 == 1) {
                return u2.getAbsolutePosition() - u1.getAbsolutePosition();
            }
            return u1.getAbsolutePosition() - u2.getAbsolutePosition();
        }

        private static int getEquivalenceClass(ActionUrl url) {
            switch (url.getActionType()) {
                case -1: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
            }
            return 3;
        }
    }

    private static class Pair {
        String first;
        String second;

        public Pair(String first, String second) {
            this.first = first;
            this.second = second;
        }

        public int hashCode() {
            return this.first.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof Pair && this.first.equals(((Pair)obj).first);
        }
    }
}

