/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.ex;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import org.jetbrains.annotations.NotNull;

public class ApplicationUtil {
    public static <T> T tryRunReadAction(final @NotNull Computable<T> computable) throws CannotRunReadActionException {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "com/intellij/openapi/application/ex/ApplicationUtil", "tryRunReadAction"));
        }
        final Ref result = new Ref();
        if (((ApplicationEx)ApplicationManager.getApplication()).tryRunReadAction(new Runnable(){

            @Override
            public void run() {
                result.set(computable.compute());
            }
        })) {
            return (T)result.get();
        }
        throw new CannotRunReadActionException();
    }

    public static void tryRunReadAction(@NotNull Runnable computable) throws CannotRunReadActionException {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "com/intellij/openapi/application/ex/ApplicationUtil", "tryRunReadAction"));
        }
        if (!((ApplicationEx)ApplicationManager.getApplication()).tryRunReadAction(computable)) {
            throw new CannotRunReadActionException();
        }
    }

    public static class CannotRunReadActionException
    extends RuntimeException {
        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

