/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceDescriptor;
import com.intellij.openapi.components.ex.ComponentManagerEx;
import com.intellij.openapi.components.impl.CachingComponentAdapter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.PairProcessor;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.pico.AssignableToComponentAdapter;
import com.intellij.util.pico.ConstructorInjectionComponentAdapter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoVisitor;

public class ServiceManagerImpl
implements BaseComponent {
    private static final Logger LOG = Logger.getInstance(ServiceManagerImpl.class);
    private static final ExtensionPointName<ServiceDescriptor> APP_SERVICES = new ExtensionPointName("com.intellij.applicationService");
    private static final ExtensionPointName<ServiceDescriptor> PROJECT_SERVICES = new ExtensionPointName("com.intellij.projectService");
    private ExtensionPointName<ServiceDescriptor> myExtensionPointName;
    private ExtensionPointListener<ServiceDescriptor> myExtensionPointListener;

    public ServiceManagerImpl() {
        this.installEP(APP_SERVICES, (ComponentManager)ApplicationManager.getApplication());
    }

    public ServiceManagerImpl(Project project) {
        this.installEP(PROJECT_SERVICES, (ComponentManager)project);
    }

    protected ServiceManagerImpl(boolean ignoreInit) {
    }

    protected void installEP(ExtensionPointName<ServiceDescriptor> pointName, final ComponentManager componentManager) {
        this.myExtensionPointName = pointName;
        ExtensionPoint extensionPoint = Extensions.getArea(null).getExtensionPoint(pointName);
        final MutablePicoContainer picoContainer = (MutablePicoContainer)componentManager.getPicoContainer();
        this.myExtensionPointListener = new ExtensionPointListener<ServiceDescriptor>(){

            public void extensionAdded(@NotNull ServiceDescriptor descriptor, PluginDescriptor pluginDescriptor) {
                ComponentAdapter oldAdapter;
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/openapi/components/impl/ServiceManagerImpl$1", "extensionAdded"));
                }
                if (descriptor.overrides && (oldAdapter = picoContainer.unregisterComponent((Object)descriptor.getInterface())) == null) {
                    throw new RuntimeException("Service: " + descriptor.getInterface() + " doesn't override anything");
                }
                picoContainer.registerComponent((ComponentAdapter)new MyComponentAdapter(descriptor, pluginDescriptor, (ComponentManagerEx)componentManager));
            }

            public void extensionRemoved(@NotNull ServiceDescriptor extension, PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/openapi/components/impl/ServiceManagerImpl$1", "extensionRemoved"));
                }
                picoContainer.unregisterComponent((Object)extension.getInterface());
            }
        };
        extensionPoint.addExtensionPointListener(this.myExtensionPointListener);
    }

    public List<ServiceDescriptor> getAllDescriptors() {
        ServiceDescriptor[] extensions = (ServiceDescriptor[])Extensions.getExtensions(this.myExtensionPointName);
        return Arrays.asList(extensions);
    }

    public static void processAllImplementationClasses(@NotNull ComponentManager componentManager, @NotNull PairProcessor<Class<?>, PluginDescriptor> processor) {
        if (componentManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentManager", "com/intellij/openapi/components/impl/ServiceManagerImpl", "processAllImplementationClasses"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/components/impl/ServiceManagerImpl", "processAllImplementationClasses"));
        }
        Collection adapters = componentManager.getPicoContainer().getComponentAdapters();
        if (adapters.isEmpty()) {
            return;
        }
        for (Object o : adapters) {
            Class<?> aClass;
            if (!(o instanceof MyComponentAdapter)) continue;
            MyComponentAdapter adapter = (MyComponentAdapter)o;
            PluginDescriptor pluginDescriptor = adapter.myPluginDescriptor;
            try {
                ComponentAdapter delegate = adapter.myDelegate;
                if (delegate == null) {
                    ClassLoader classLoader = pluginDescriptor == null ? ServiceManagerImpl.class.getClassLoader() : pluginDescriptor.getPluginClassLoader();
                    aClass = Class.forName(adapter.myDescriptor.getImplementation(), false, classLoader);
                } else {
                    aClass = delegate.getComponentImplementation();
                }
            }
            catch (Throwable e) {
                LOG.error(e);
                continue;
            }
            if (processor.process((Object)aClass, (Object)pluginDescriptor)) continue;
            break;
        }
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        String string = this.getClass().getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/ServiceManagerImpl", "getComponentName"));
        }
        return string;
    }

    public void initComponent() {
    }

    public void disposeComponent() {
        ExtensionPoint extensionPoint = Extensions.getArea(null).getExtensionPoint(this.myExtensionPointName);
        extensionPoint.removeExtensionPointListener(this.myExtensionPointListener);
    }

    private static class MyComponentAdapter
    implements AssignableToComponentAdapter {
        private ComponentAdapter myDelegate;
        private final ServiceDescriptor myDescriptor;
        private final PluginDescriptor myPluginDescriptor;
        private final ComponentManagerEx myComponentManager;
        private volatile Object myInitializedComponentInstance = null;

        public MyComponentAdapter(ServiceDescriptor descriptor, PluginDescriptor pluginDescriptor, ComponentManagerEx componentManager) {
            this.myDescriptor = descriptor;
            this.myPluginDescriptor = pluginDescriptor;
            this.myComponentManager = componentManager;
            this.myDelegate = null;
        }

        public String getComponentKey() {
            return this.myDescriptor.getInterface();
        }

        public Class getComponentImplementation() {
            return this.loadClass(this.myDescriptor.getInterface());
        }

        private Class loadClass(String className) {
            try {
                ClassLoader classLoader = this.myPluginDescriptor != null ? this.myPluginDescriptor.getPluginClassLoader() : this.getClass().getClassLoader();
                return Class.forName(className, true, classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        public Object getComponentInstance(final PicoContainer container) throws PicoInitializationException, PicoIntrospectionException {
            Object instance = this.myInitializedComponentInstance;
            if (instance != null) {
                return instance;
            }
            return ApplicationManager.getApplication().runReadAction((Computable)new Computable<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                public Object compute() {
                    Object instance;
                    block6: {
                        Object object;
                        HeavyProcessLatch.INSTANCE.processStarted();
                        try {
                            MyComponentAdapter myComponentAdapter = MyComponentAdapter.this;
                            // MONITORENTER : myComponentAdapter
                            instance = MyComponentAdapter.this.myInitializedComponentInstance;
                            if (instance == null) break block6;
                            object = instance;
                            // MONITOREXIT : myComponentAdapter
                        }
                        catch (Throwable throwable) {
                            HeavyProcessLatch.INSTANCE.processFinished();
                            throw throwable;
                        }
                        HeavyProcessLatch.INSTANCE.processFinished();
                        return object;
                    }
                    instance = MyComponentAdapter.this.initializeInstance(container);
                    MyComponentAdapter.this.myInitializedComponentInstance = instance;
                    Object object = instance;
                    // MONITOREXIT : myComponentAdapter
                    HeavyProcessLatch.INSTANCE.processFinished();
                    return object;
                }
            });
        }

        protected Object initializeInstance(PicoContainer container) {
            Object serviceInstance = this.getDelegate().getComponentInstance(container);
            if (serviceInstance instanceof Disposable) {
                Disposer.register((Disposable)this.myComponentManager, (Disposable)((Disposable)serviceInstance));
            }
            this.myComponentManager.initializeComponent(serviceInstance, true);
            return serviceInstance;
        }

        private synchronized ComponentAdapter getDelegate() {
            if (this.myDelegate == null) {
                this.myDelegate = new CachingComponentAdapter((ComponentAdapter)new ConstructorInjectionComponentAdapter((Object)this.getComponentKey(), this.loadClass(this.myDescriptor.getImplementation()), null, true));
            }
            return this.myDelegate;
        }

        public void verify(PicoContainer container) throws PicoIntrospectionException {
            this.getDelegate().verify(container);
        }

        public void accept(PicoVisitor visitor) {
            visitor.visitComponentAdapter((ComponentAdapter)this);
        }

        public boolean isAssignableTo(Class aClass) {
            return aClass.getName().equals(this.getComponentKey());
        }

        public String getAssignableToClassName() {
            return this.myDescriptor.getInterface();
        }

        public String toString() {
            return "ServiceComponentAdapter[" + this.myDescriptor.getInterface() + "]: implementation=" + this.myDescriptor.getImplementation() + ", plugin=" + this.myPluginDescriptor;
        }
    }
}

