/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.StateStorageException;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.ComponentManagerImpl;
import com.intellij.openapi.components.impl.stores.BaseFileConfigurableStoreImpl;
import com.intellij.openapi.components.impl.stores.FileBasedStorage;
import com.intellij.openapi.components.impl.stores.IModuleStore;
import com.intellij.openapi.components.impl.stores.ModuleStateStorageManager;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.components.impl.stores.StorageData;
import com.intellij.openapi.components.impl.stores.StorageUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.module.impl.ModuleImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.messages.MessageBus;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleStoreImpl
extends BaseFileConfigurableStoreImpl
implements IModuleStore {
    private static final Logger LOG = Logger.getInstance(ModuleStoreImpl.class);
    private final ModuleImpl myModule;

    public ModuleStoreImpl(ComponentManagerImpl componentManager, ModuleImpl module) {
        super(componentManager);
        this.myModule = module;
    }

    @Override
    protected FileBasedStorage getMainStorage() {
        FileBasedStorage storage = (FileBasedStorage)this.getStateStorageManager().getStateStorage("$MODULE_FILE$", RoamingType.PER_USER);
        assert (storage != null);
        return storage;
    }

    @Override
    protected Project getProject() {
        return this.myModule.getProject();
    }

    @Override
    public void load() throws IOException, StateStorageException {
        Collection<String> macros;
        super.load();
        ModuleFileData storageData = this.getMainStorageData();
        String moduleTypeId = (String)storageData.myOptions.get("type");
        this.myModule.setOption("type", ModuleTypeManager.getInstance().findByID(moduleTypeId).getId());
        if (ApplicationManager.getApplication().isHeadlessEnvironment() || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        final TrackingPathMacroSubstitutor substitutor = this.getStateStorageManager().getMacroSubstitutor();
        if (substitutor != null && !(macros = substitutor.getUnknownMacros(null)).isEmpty()) {
            final Project project = this.myModule.getProject();
            StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(new Runnable(){

                @Override
                public void run() {
                    StorageUtil.notifyUnknownMacros(substitutor, project, null);
                }
            });
        }
    }

    @Override
    public ModuleFileData getMainStorageData() throws StateStorageException {
        return (ModuleFileData)super.getMainStorageData();
    }

    @Override
    public void setModuleFilePath(@NotNull String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/components/impl/stores/ModuleStoreImpl", "setModuleFilePath"));
        }
        String path = filePath.replace(File.separatorChar, '/');
        LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
        StateStorageManager storageManager = this.getStateStorageManager();
        storageManager.clearStateStorage("$MODULE_FILE$");
        storageManager.addMacro("$MODULE_FILE$", path);
    }

    @Override
    @Nullable
    public VirtualFile getModuleFile() {
        return this.getMainStorage().getVirtualFile();
    }

    @Override
    @NotNull
    public String getModuleFilePath() {
        String string = this.getMainStorage().getFilePath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ModuleStoreImpl", "getModuleFilePath"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getModuleFileName() {
        String string = PathUtilRt.getFileName((String)this.getMainStorage().getFilePath());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ModuleStoreImpl", "getModuleFileName"));
        }
        return string;
    }

    @Override
    public void setOption(String optionName, String optionValue) {
        try {
            this.getMainStorageData().setOption(optionName, optionValue);
        }
        catch (StateStorageException e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    public void clearOption(String optionName) {
        try {
            this.getMainStorageData().clearOption(optionName);
        }
        catch (StateStorageException e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    public String getOptionValue(String optionName) {
        try {
            return this.getMainStorageData().getOptionValue(optionName);
        }
        catch (StateStorageException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @Override
    protected boolean optimizeTestLoading() {
        return ((ProjectEx)this.myModule.getProject()).isOptimiseTestLoadSpeed();
    }

    @Override
    @NotNull
    protected MessageBus getMessageBus() {
        MessageBus messageBus = this.myModule.getMessageBus();
        if (messageBus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ModuleStoreImpl", "getMessageBus"));
        }
        return messageBus;
    }

    @Override
    @NotNull
    protected StateStorageManager createStateStorageManager() {
        ModuleStateStorageManager moduleStateStorageManager = new ModuleStateStorageManager(PathMacroManager.getInstance(this.getComponentManager()).createTrackingSubstitutor(), this.myModule);
        if (moduleStateStorageManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ModuleStoreImpl", "createStateStorageManager"));
        }
        return moduleStateStorageManager;
    }

    static class ModuleFileData
    extends BaseFileConfigurableStoreImpl.BaseStorageData {
        private final Map<String, String> myOptions;
        private final Module myModule;

        public ModuleFileData(String rootElementName, Module module) {
            super(rootElementName);
            this.myModule = module;
            this.myOptions = new THashMap(2);
        }

        protected ModuleFileData(ModuleFileData storageData) {
            super(storageData);
            this.myOptions = new THashMap(storageData.myOptions);
            this.myModule = storageData.myModule;
        }

        @Override
        public void load(@NotNull Element rootElement, @Nullable PathMacroSubstitutor pathMacroSubstitutor, boolean intern) {
            if (rootElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "com/intellij/openapi/components/impl/stores/ModuleStoreImpl$ModuleFileData", "load"));
            }
            super.load(rootElement, pathMacroSubstitutor, intern);
            for (Attribute attribute : rootElement.getAttributes()) {
                this.myOptions.put(attribute.getName(), attribute.getValue());
            }
        }

        @Override
        @NotNull
        protected Element save(@NotNull Map<String, Element> newLiveStates) {
            if (newLiveStates == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newLiveStates", "com/intellij/openapi/components/impl/stores/ModuleStoreImpl$ModuleFileData", "save"));
            }
            Element root = super.save(newLiveStates);
            this.myOptions.put("version", Integer.toString(this.myVersion));
            Object[] options = ArrayUtil.toStringArray(this.myOptions.keySet());
            Arrays.sort(options);
            for (Object option : options) {
                root.setAttribute((String)option, this.myOptions.get(option));
            }
            root.removeAttribute("version");
            root.setAttribute("version", Integer.toString(this.myVersion));
            Element element = root;
            if (element == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ModuleStoreImpl$ModuleFileData", "save"));
            }
            return element;
        }

        @Override
        public StorageData clone() {
            return new ModuleFileData(this);
        }

        @Override
        @Nullable
        public Set<String> getChangedComponentNames(@NotNull StorageData newStorageData, @Nullable PathMacroSubstitutor substitutor) {
            if (newStorageData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newStorageData", "com/intellij/openapi/components/impl/stores/ModuleStoreImpl$ModuleFileData", "getChangedComponentNames"));
            }
            ModuleFileData data = (ModuleFileData)newStorageData;
            if (!((Object)this.myOptions).equals(data.myOptions)) {
                return null;
            }
            return super.getChangedComponentNames(newStorageData, substitutor);
        }

        public void setOption(String optionName, String optionValue) {
            this.myOptions.put(optionName, optionValue);
        }

        public void clearOption(String optionName) {
            this.myOptions.remove(optionName);
        }

        public String getOptionValue(String optionName) {
            return this.myOptions.get(optionName);
        }
    }
}

