/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageException;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.store.ComponentSaveSession;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class StoreUtil {
    private StoreUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doSave(@NotNull IComponentStore stateStore) {
        if (stateStore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateStore", "com/intellij/openapi/components/impl/stores/StoreUtil", "doSave"));
        }
        ComponentSaveSession session = stateStore.startSave();
        if (session == null) {
            return;
        }
        ShutDownTracker.getInstance().registerStopperThread(Thread.currentThread());
        try {
            SmartList readonlyFiles = new SmartList();
            session.save((List<Pair<StateStorage.SaveSession, VirtualFile>>)readonlyFiles);
        }
        catch (Throwable e) {
            PluginId pluginId = IdeErrorsDialog.findPluginId(e);
            if (pluginId == null) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new StateStorageException(e);
            }
            throw new PluginException(e, pluginId);
        }
        finally {
            try {
                session.finishSave();
            }
            finally {
                ShutDownTracker.getInstance().unregisterStopperThread(Thread.currentThread());
            }
        }
    }
}

