/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.ArrowPainter;
import com.intellij.openapi.editor.impl.ColorProvider;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapDrawingType;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapPainter;
import com.intellij.openapi.util.Computable;
import java.awt.Graphics;
import org.jetbrains.annotations.NotNull;

public class ArrowSoftWrapPainter
implements SoftWrapPainter {
    private final HeightProvider myHeightProvider = new HeightProvider();
    private final Editor myEditor;
    private final ArrowPainter myArrowPainter;
    private int myMinWidth = -1;

    public ArrowSoftWrapPainter(Editor editor) {
        this.myEditor = editor;
        this.myArrowPainter = new ArrowPainter(ColorProvider.byColor(this.myEditor.getColorsScheme().getDefaultForeground()), new WidthProvider(), this.myHeightProvider);
    }

    @Override
    public int paint(@NotNull Graphics g, @NotNull SoftWrapDrawingType drawingType, int x, int y, int lineHeight) {
        int result;
        int end;
        int start;
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/softwrap/ArrowSoftWrapPainter", "paint"));
        }
        if (drawingType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "drawingType", "com/intellij/openapi/editor/impl/softwrap/ArrowSoftWrapPainter", "paint"));
        }
        this.myHeightProvider.myHeight = lineHeight / 2;
        switch (drawingType) {
            case BEFORE_SOFT_WRAP_LINE_FEED: {
                start = x;
                end = this.myEditor.getScrollingModel().getVisibleArea().width;
                result = end - start;
                break;
            }
            case AFTER_SOFT_WRAP: {
                start = 0;
                end = x;
                result = 0;
                break;
            }
            default: {
                throw new IllegalStateException("Soft wrap arrow painting is not set up for drawing type " + (Object)((Object)drawingType));
            }
        }
        this.myArrowPainter.paint(g, y + lineHeight - g.getFontMetrics().getDescent(), start, end);
        return result;
    }

    @Override
    public int getDrawingHorizontalOffset(@NotNull Graphics g, @NotNull SoftWrapDrawingType drawingType, int x, int y, int lineHeight) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/softwrap/ArrowSoftWrapPainter", "getDrawingHorizontalOffset"));
        }
        if (drawingType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "drawingType", "com/intellij/openapi/editor/impl/softwrap/ArrowSoftWrapPainter", "getDrawingHorizontalOffset"));
        }
        switch (drawingType) {
            case BEFORE_SOFT_WRAP_LINE_FEED: {
                return this.myEditor.getScrollingModel().getVisibleArea().width - x;
            }
            case AFTER_SOFT_WRAP: {
                return 0;
            }
        }
        throw new IllegalStateException("Soft wrap arrow painting is not set up for drawing type " + (Object)((Object)drawingType));
    }

    @Override
    public int getMinDrawingWidth(@NotNull SoftWrapDrawingType drawingType) {
        if (drawingType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "drawingType", "com/intellij/openapi/editor/impl/softwrap/ArrowSoftWrapPainter", "getMinDrawingWidth"));
        }
        if (this.myMinWidth < 0) {
            this.myMinWidth = EditorUtil.charWidth('a', 0, this.myEditor);
        }
        return this.myMinWidth;
    }

    @Override
    public boolean canUse() {
        return true;
    }

    private class WidthProvider
    implements Computable<Integer> {
        private WidthProvider() {
        }

        public Integer compute() {
            return EditorUtil.getSpaceWidth(0, ArrowSoftWrapPainter.this.myEditor);
        }
    }

    private static class HeightProvider
    implements Computable<Integer> {
        public int myHeight;

        private HeightProvider() {
        }

        public Integer compute() {
            return this.myHeight;
        }
    }
}

