/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleRootModificationUtil {
    public static void addModuleLibrary(Module module, String libName, List<String> classesRoots, List<String> sourceRoots) {
        ModuleRootModificationUtil.addModuleLibrary(module, libName, classesRoots, sourceRoots, DependencyScope.COMPILE);
    }

    public static void addModuleLibrary(Module module, String libName, List<String> classesRoots, List<String> sourceRoots, DependencyScope scope) {
        ModuleRootModificationUtil.addModuleLibrary(module, libName, classesRoots, sourceRoots, Collections.<String>emptyList(), scope);
    }

    public static void addModuleLibrary(Module module, String libName, List<String> classesRoots, List<String> sourceRoots, List<String> excludedRoots, DependencyScope scope) {
        ModuleRootModificationUtil.addModuleLibrary(module, libName, classesRoots, sourceRoots, excludedRoots, scope, false);
    }

    public static void addModuleLibrary(Module module, final String libName, final List<String> classesRoots, final List<String> sourceRoots, final List<String> excludedRoots, final DependencyScope scope, final boolean exported) {
        ModuleRootModificationUtil.updateModel(module, new Consumer<ModifiableRootModel>(){

            public void consume(ModifiableRootModel model) {
                LibraryEx library = (LibraryEx)model.getModuleLibraryTable().createLibrary(libName);
                final LibraryEx.ModifiableModelEx libraryModel = library.getModifiableModel();
                for (String root : classesRoots) {
                    libraryModel.addRoot(root, OrderRootType.CLASSES);
                }
                for (String root : sourceRoots) {
                    libraryModel.addRoot(root, OrderRootType.SOURCES);
                }
                for (String excluded : excludedRoots) {
                    libraryModel.addExcludedRoot(excluded);
                }
                LibraryOrderEntry entry = model.findLibraryOrderEntry((Library)library);
                assert (entry != null) : library;
                entry.setScope(scope);
                entry.setExported(exported);
                ModuleRootModificationUtil.doWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        libraryModel.commit();
                    }
                });
            }
        });
    }

    public static void addModuleLibrary(Module module, String classesRootUrl) {
        ModuleRootModificationUtil.addModuleLibrary(module, null, Collections.singletonList(classesRootUrl), Collections.<String>emptyList());
    }

    public static void addDependency(Module module, Library library) {
        ModuleRootModificationUtil.addDependency(module, library, DependencyScope.COMPILE, false);
    }

    public static void addDependency(Module module, final Library library, final DependencyScope scope, final boolean exported) {
        ModuleRootModificationUtil.updateModel(module, new Consumer<ModifiableRootModel>(){

            public void consume(ModifiableRootModel model) {
                LibraryOrderEntry entry = model.addLibraryEntry(library);
                entry.setExported(exported);
                entry.setScope(scope);
            }
        });
    }

    public static void setModuleSdk(Module module, final @Nullable Sdk sdk) {
        ModuleRootModificationUtil.updateModel(module, new Consumer<ModifiableRootModel>(){

            public void consume(ModifiableRootModel model) {
                model.setSdk(sdk);
            }
        });
    }

    public static void setSdkInherited(Module module) {
        ModuleRootModificationUtil.updateModel(module, new Consumer<ModifiableRootModel>(){

            public void consume(ModifiableRootModel model) {
                model.inheritSdk();
            }
        });
    }

    public static void addDependency(Module from, Module to) {
        ModuleRootModificationUtil.addDependency(from, to, DependencyScope.COMPILE, false);
    }

    public static void addDependency(Module from, final Module to, final DependencyScope scope, final boolean exported) {
        ModuleRootModificationUtil.updateModel(from, new Consumer<ModifiableRootModel>(){

            public void consume(ModifiableRootModel model) {
                ModuleOrderEntry entry = model.addModuleOrderEntry(to);
                entry.setScope(scope);
                entry.setExported(exported);
            }
        });
    }

    public static void updateModel(final @NotNull Module module, @NotNull Consumer<ModifiableRootModel> task) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/ModuleRootModificationUtil", "updateModel"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/roots/ModuleRootModificationUtil", "updateModel"));
        }
        final ModifiableRootModel model = (ModifiableRootModel)ApplicationManager.getApplication().runReadAction((Computable)new Computable<ModifiableRootModel>(){

            public ModifiableRootModel compute() {
                return ModuleRootManager.getInstance((Module)module).getModifiableModel();
            }
        });
        try {
            task.consume((Object)model);
            ModuleRootModificationUtil.doWriteAction(new Runnable(){

                @Override
                public void run() {
                    model.commit();
                }
            });
        }
        catch (RuntimeException e) {
            model.dispose();
            throw e;
        }
        catch (Error e) {
            model.dispose();
            throw e;
        }
    }

    public static void updateExcludedFolders(Module module, final @NotNull VirtualFile contentRoot, final Collection<String> urlsToUnExclude, final Collection<String> urlsToExclude) {
        if (contentRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentRoot", "com/intellij/openapi/roots/ModuleRootModificationUtil", "updateExcludedFolders"));
        }
        ModuleRootModificationUtil.updateModel(module, new Consumer<ModifiableRootModel>(){

            public void consume(ModifiableRootModel modifiableModel) {
                for (ContentEntry contentEntry : modifiableModel.getContentEntries()) {
                    if (!contentRoot.equals(contentEntry.getFile())) continue;
                    for (String url : urlsToUnExclude) {
                        contentEntry.removeExcludeFolder(url);
                    }
                    for (String url : urlsToExclude) {
                        contentEntry.addExcludeFolder(url);
                    }
                    break;
                }
            }
        });
    }

    private static void doWriteAction(final Runnable action) {
        final Application application = ApplicationManager.getApplication();
        application.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                application.runWriteAction(action);
            }
        }, application.getDefaultModalityState());
    }
}

