/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.updateSettings.impl.ButtonInfo;
import com.intellij.openapi.updateSettings.impl.PatchInfo;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.util.containers.ContainerUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

public class BuildInfo
implements Comparable<BuildInfo> {
    private final BuildNumber myNumber;
    private final String myVersion;
    private final String myMessage;
    @Nullable
    private final Date myReleaseDate;
    private final List<PatchInfo> myPatches;
    private final List<ButtonInfo> myButtons;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.updateSettings.impl.BuildInfo");

    public BuildInfo(Element node) {
        this.myNumber = BuildNumber.fromString((String)node.getAttributeValue("number"));
        this.myVersion = node.getAttributeValue("version");
        Date releaseDate = null;
        String date = node.getAttributeValue("releaseDate");
        if (date != null) {
            try {
                releaseDate = new SimpleDateFormat("yyyyMMdd", Locale.US).parse(date);
            }
            catch (ParseException e) {
                LOG.info("Failed to parse build release date " + date);
            }
        }
        this.myReleaseDate = releaseDate;
        this.myPatches = new ArrayList<PatchInfo>();
        for (Element patchNode : node.getChildren("patch")) {
            this.myPatches.add(new PatchInfo(patchNode));
        }
        this.myButtons = new ArrayList<ButtonInfo>();
        for (Element buttonNode : node.getChildren("button")) {
            this.myButtons.add(new ButtonInfo(buttonNode));
        }
        Element messageTag = node.getChild("message");
        this.myMessage = messageTag != null ? messageTag.getValue() : "";
    }

    @Override
    public int compareTo(BuildInfo o) {
        return this.myNumber.compareTo(o.myNumber);
    }

    public BuildNumber getNumber() {
        return this.myNumber;
    }

    public String getVersion() {
        return this.myVersion != null ? this.myVersion : "";
    }

    public String getMessage() {
        return this.myMessage;
    }

    @Nullable
    public Date getReleaseDate() {
        return this.myReleaseDate;
    }

    @Nullable
    public PatchInfo findPatchForCurrentBuild() {
        BuildNumber currentBuild = ApplicationInfo.getInstance().getBuild();
        for (PatchInfo each : this.myPatches) {
            if (!each.isAvailable() || !each.getFromBuild().asStringWithoutProductCode().equals(currentBuild.asStringWithoutProductCode())) continue;
            return each;
        }
        return null;
    }

    public List<ButtonInfo> getButtons() {
        return ContainerUtil.immutableList(this.myButtons);
    }

    public String toString() {
        return "BuildInfo(number=" + this.myNumber + ")";
    }
}

