/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.CallbackData;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManagerProxy;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.io.storage.HeavyProcessLatch;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public class UpdateRequestsQueue {
    private final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.UpdateRequestsQueue");
    private static final String ourHeavyLatchOptimization = "vcs.local.changes.track.heavy.latch";
    private final Project myProject;
    private final AtomicReference<ScheduledExecutorService> myExecutor;
    private final Runnable myDelegate;
    private final Object myLock;
    private volatile boolean myStarted;
    private volatile boolean myStopped;
    private volatile boolean myIgnoreBackgroundOperation;
    private boolean myRequestSubmitted;
    private boolean myRequestRunning;
    private final List<Runnable> myWaitingUpdateCompletionQueue;
    private final List<Semaphore> myWaitingUpdateCompletionSemaphores = new ArrayList<Semaphore>();
    private final ProjectLevelVcsManager myPlVcsManager;
    private final StartupManager myStartupManager;
    private final boolean myTrackHeavyLatch;
    private final Getter<Boolean> myIsStoppedGetter;

    public UpdateRequestsQueue(Project project, AtomicReference<ScheduledExecutorService> executor, Runnable delegate) {
        this.myProject = project;
        this.myExecutor = executor;
        this.myTrackHeavyLatch = Boolean.parseBoolean(System.getProperty(ourHeavyLatchOptimization));
        this.myDelegate = delegate;
        this.myPlVcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        this.myStartupManager = StartupManager.getInstance((Project)this.myProject);
        this.myLock = new Object();
        this.myWaitingUpdateCompletionQueue = new ArrayList<Runnable>();
        this.myStarted = false;
        this.myStopped = false;
        this.myIsStoppedGetter = new Getter<Boolean>(){

            public Boolean get() {
                return UpdateRequestsQueue.this.isStopped();
            }
        };
    }

    public void initialized() {
        this.LOG.debug("Initialized for project: " + this.myProject.getName());
        this.myStarted = true;
    }

    public Getter<Boolean> getIsStoppedGetter() {
        return this.myIsStoppedGetter;
    }

    public boolean isStopped() {
        return this.myStopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule() {
        Object object = this.myLock;
        synchronized (object) {
            if (!this.myStarted && ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            if (!this.myStopped && !this.myRequestSubmitted) {
                MyRunnable runnable = new MyRunnable();
                this.myRequestSubmitted = true;
                this.myExecutor.get().schedule(runnable, 300L, TimeUnit.MILLISECONDS);
                this.LOG.debug("Scheduled for project: " + this.myProject.getName() + ", runnable: " + runnable.hashCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.myLock;
        synchronized (object) {
            this.myStopped = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceGo() {
        Object object = this.myLock;
        synchronized (object) {
            this.myStopped = false;
            this.myRequestSubmitted = false;
            this.myRequestRunning = false;
        }
        this.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void go() {
        Object object = this.myLock;
        synchronized (object) {
            this.myStopped = false;
        }
        this.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.LOG.debug("Calling stop for project: " + this.myProject.getName());
        ArrayList<Runnable> waiters = new ArrayList<Runnable>(this.myWaitingUpdateCompletionQueue.size());
        Object object = this.myLock;
        synchronized (object) {
            this.myStopped = true;
            waiters.addAll(this.myWaitingUpdateCompletionQueue);
            this.myWaitingUpdateCompletionQueue.clear();
        }
        this.LOG.debug("Calling runnables in stop for project: " + this.myProject.getName());
        for (Runnable runnable : waiters) {
            runnable.run();
        }
        this.LOG.debug("Stop finished for project: " + this.myProject.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilRefreshed() {
        Semaphore semaphore;
        do {
            semaphore = new Semaphore();
            Object object = this.myLock;
            synchronized (object) {
                if (!this.myRequestSubmitted && !this.myRequestRunning) {
                    return;
                }
                semaphore.down();
                this.myWaitingUpdateCompletionSemaphores.add(semaphore);
            }
        } while (semaphore.waitFor(100000L));
        this.LOG.error("Too long VCS update");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeSemaphores() {
        Object object = this.myLock;
        synchronized (object) {
            for (Semaphore semaphore : this.myWaitingUpdateCompletionSemaphores) {
                semaphore.up();
            }
            this.myWaitingUpdateCompletionSemaphores.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeAfterUpdate(final Runnable afterUpdate, InvokeAfterUpdateMode mode, String title, @Nullable Consumer<VcsDirtyScopeManager> dirtyScopeManagerFiller, ModalityState state) {
        this.LOG.debug("invokeAfterUpdate for project: " + this.myProject.getName());
        CallbackData data = CallbackData.create(afterUpdate, title, state, mode, this.myProject);
        VcsDirtyScopeManagerProxy managerProxy = null;
        if (dirtyScopeManagerFiller != null) {
            managerProxy = new VcsDirtyScopeManagerProxy();
            dirtyScopeManagerFiller.consume((Object)managerProxy);
        }
        if (!this.myStopped && managerProxy != null) {
            managerProxy.callRealManager(VcsDirtyScopeManager.getInstance((Project)this.myProject));
        }
        Object object = this.myLock;
        synchronized (object) {
            if (!this.myStopped) {
                this.myWaitingUpdateCompletionQueue.add(data.getCallback());
                this.schedule();
            }
        }
        if (this.myStopped) {
            this.LOG.debug("invokeAfterUpdate: stopped, invoke right now for project: " + this.myProject.getName());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!UpdateRequestsQueue.this.myProject.isDisposed()) {
                        afterUpdate.run();
                    }
                }
            });
            return;
        }
        if (data.getWrapperStarter() != null) {
            data.getWrapperStarter().run();
        }
        this.LOG.debug("invokeAfterUpdate: exit for project: " + this.myProject.getName());
    }

    private boolean checkHeavyOperations() {
        if (this.myIgnoreBackgroundOperation) {
            return false;
        }
        return this.myPlVcsManager.isBackgroundVcsOperationRunning() || this.myTrackHeavyLatch && HeavyProcessLatch.INSTANCE.isRunning();
    }

    private boolean checkLifeCycle() {
        return !this.myStarted || !((StartupManagerImpl)this.myStartupManager).startupActivityPassed();
    }

    public void setIgnoreBackgroundOperation(boolean ignoreBackgroundOperation) {
        this.myIgnoreBackgroundOperation = ignoreBackgroundOperation;
    }

    private class MyRunnable
    implements Runnable {
        private MyRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            Object object;
            ArrayList copy;
            block25: {
                copy = new ArrayList(UpdateRequestsQueue.this.myWaitingUpdateCompletionQueue.size());
                object = UpdateRequestsQueue.this.myLock;
                // MONITORENTER : object
                UpdateRequestsQueue.this.LOG.assertTrue(!UpdateRequestsQueue.this.myRequestRunning);
                UpdateRequestsQueue.this.myRequestRunning = true;
                if (!UpdateRequestsQueue.this.myStopped) break block25;
                UpdateRequestsQueue.this.myRequestSubmitted = false;
                UpdateRequestsQueue.this.LOG.debug("MyRunnable: STOPPED, project: " + UpdateRequestsQueue.this.myProject.getName() + ", runnable: " + this.hashCode());
                // MONITOREXIT : object
                Object object2 = UpdateRequestsQueue.this.myLock;
                // MONITORENTER : object2
                UpdateRequestsQueue.this.myRequestRunning = false;
                UpdateRequestsQueue.this.LOG.debug("MyRunnable: delete executed, project: " + UpdateRequestsQueue.this.myProject.getName() + ", runnable: " + this.hashCode());
                if (!copy.isEmpty()) {
                    UpdateRequestsQueue.this.myWaitingUpdateCompletionQueue.removeAll(copy);
                }
                if (!(UpdateRequestsQueue.this.myWaitingUpdateCompletionQueue.isEmpty() || UpdateRequestsQueue.this.myRequestSubmitted || UpdateRequestsQueue.this.myStopped)) {
                    UpdateRequestsQueue.this.LOG.error("No update task to handle request(s)");
                }
                // MONITOREXIT : object2
                Iterator i$ = copy.iterator();
                while (true) {
                    if (!i$.hasNext()) {
                        UpdateRequestsQueue.this.freeSemaphores();
                        UpdateRequestsQueue.this.LOG.debug("MyRunnable: Runnables executed, project: " + UpdateRequestsQueue.this.myProject.getName() + ", runnable: " + this.hashCode());
                        return;
                    }
                    Runnable runnable = (Runnable)i$.next();
                    runnable.run();
                }
            }
            if (UpdateRequestsQueue.this.checkLifeCycle() || UpdateRequestsQueue.this.checkHeavyOperations()) {
                UpdateRequestsQueue.this.LOG.debug("MyRunnable: reschedule, project: " + UpdateRequestsQueue.this.myProject.getName() + ", runnable: " + this.hashCode());
                UpdateRequestsQueue.this.myRequestSubmitted = false;
                UpdateRequestsQueue.this.schedule();
                // MONITOREXIT : object
                Iterator i$ = UpdateRequestsQueue.this.myLock;
                // MONITORENTER : i$
                UpdateRequestsQueue.this.myRequestRunning = false;
                UpdateRequestsQueue.this.LOG.debug("MyRunnable: delete executed, project: " + UpdateRequestsQueue.this.myProject.getName() + ", runnable: " + this.hashCode());
                if (!copy.isEmpty()) {
                    UpdateRequestsQueue.this.myWaitingUpdateCompletionQueue.removeAll(copy);
                }
                if (!(UpdateRequestsQueue.this.myWaitingUpdateCompletionQueue.isEmpty() || UpdateRequestsQueue.this.myRequestSubmitted || UpdateRequestsQueue.this.myStopped)) {
                    UpdateRequestsQueue.this.LOG.error("No update task to handle request(s)");
                }
                // MONITOREXIT : i$
                i$ = copy.iterator();
                while (true) {
                    if (!i$.hasNext()) {
                        UpdateRequestsQueue.this.freeSemaphores();
                        UpdateRequestsQueue.this.LOG.debug("MyRunnable: Runnables executed, project: " + UpdateRequestsQueue.this.myProject.getName() + ", runnable: " + this.hashCode());
                        return;
                    }
                    Runnable runnable = (Runnable)i$.next();
                    runnable.run();
                }
            }
            try {
                copy.addAll(UpdateRequestsQueue.this.myWaitingUpdateCompletionQueue);
                UpdateRequestsQueue.this.myRequestSubmitted = false;
                // MONITOREXIT : object
                UpdateRequestsQueue.this.LOG.debug("MyRunnable: INVOKE, project: " + UpdateRequestsQueue.this.myProject.getName() + ", runnable: " + this.hashCode());
                UpdateRequestsQueue.this.myDelegate.run();
                UpdateRequestsQueue.this.LOG.debug("MyRunnable: invokeD, project: " + UpdateRequestsQueue.this.myProject.getName() + ", runnable: " + this.hashCode());
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                object = UpdateRequestsQueue.this.myLock;
            }
        }
    }
}

