/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeModifier;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsDirtyScopeImpl
extends VcsModifiableDirtyScope {
    private final Map<VirtualFile, THashSet<FilePath>> myDirtyFiles = new HashMap<VirtualFile, THashSet<FilePath>>();
    private final Map<VirtualFile, THashSet<FilePath>> myDirtyDirectoriesRecursively = new HashMap<VirtualFile, THashSet<FilePath>>();
    private final Set<VirtualFile> myAffectedContentRoots = new THashSet();
    private final Project myProject;
    private final ProjectLevelVcsManager myVcsManager;
    private final AbstractVcs myVcs;
    private VcsDirtyScopeModifier myVcsDirtyScopeModifier;
    private boolean myWasEverythingDirty;

    public VcsDirtyScopeImpl(AbstractVcs vcs, Project project) {
        this.myProject = project;
        this.myVcs = vcs;
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        this.myWasEverythingDirty = false;
        this.myVcsDirtyScopeModifier = new VcsDirtyScopeModifier(){

            public Collection<VirtualFile> getAffectedVcsRoots() {
                return Collections.unmodifiableCollection(VcsDirtyScopeImpl.this.myDirtyDirectoriesRecursively.keySet());
            }

            public Iterator<FilePath> getDirtyFilesIterator() {
                if (VcsDirtyScopeImpl.this.myDirtyFiles.isEmpty()) {
                    return Collections.emptyList().iterator();
                }
                ArrayList<Iterator> iteratorList = new ArrayList<Iterator>(VcsDirtyScopeImpl.this.myDirtyFiles.size());
                for (THashSet paths : VcsDirtyScopeImpl.this.myDirtyFiles.values()) {
                    iteratorList.add(paths.iterator());
                }
                return ContainerUtil.concatIterators(iteratorList);
            }

            @NotNull
            public Iterator<FilePath> getDirtyDirectoriesIterator(VirtualFile root) {
                THashSet filePaths = (THashSet)VcsDirtyScopeImpl.this.myDirtyDirectoriesRecursively.get(root);
                if (filePaths != null) {
                    Iterator iterator = filePaths.iterator();
                    if (iterator == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/VcsDirtyScopeImpl$1", "getDirtyDirectoriesIterator"));
                    }
                    return iterator;
                }
                Iterator iterator = ContainerUtil.emptyIterator();
                if (iterator == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/VcsDirtyScopeImpl$1", "getDirtyDirectoriesIterator"));
                }
                return iterator;
            }

            public void recheckDirtyKeys() {
                this.recheckMap(VcsDirtyScopeImpl.this.myDirtyDirectoriesRecursively);
                this.recheckMap(VcsDirtyScopeImpl.this.myDirtyFiles);
            }

            private void recheckMap(Map<VirtualFile, THashSet<FilePath>> map) {
                Iterator<THashSet<FilePath>> iterator = map.values().iterator();
                while (iterator.hasNext()) {
                    THashSet<FilePath> next = iterator.next();
                    if (!next.isEmpty()) continue;
                    iterator.remove();
                }
            }
        };
    }

    public Collection<VirtualFile> getAffectedContentRoots() {
        return this.myAffectedContentRoots;
    }

    public Collection<VirtualFile> getAffectedContentRootsWithCheck() {
        if (this.myVcs.allowsNestedRoots()) {
            ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myVcs.getProject());
            VirtualFile[] roots = vcsManager.getRootsUnderVcs(this.myVcs);
            HashSet<VirtualFile> result = new HashSet<VirtualFile>(this.myAffectedContentRoots);
            for (VirtualFile root : roots) {
                for (VirtualFile dir : this.myDirtyDirectoriesRecursively.keySet()) {
                    if (!VfsUtilCore.isAncestor((VirtualFile)dir, (VirtualFile)root, (boolean)true)) continue;
                    result.add(root);
                }
            }
            return new SmartList(result);
        }
        return this.myAffectedContentRoots;
    }

    public Project getProject() {
        return this.myProject;
    }

    public AbstractVcs getVcs() {
        return this.myVcs;
    }

    public Set<FilePath> getDirtyFiles() {
        THashSet result = new THashSet();
        for (THashSet<FilePath> paths : this.myDirtyFiles.values()) {
            result.addAll(paths);
        }
        for (THashSet<FilePath> paths : this.myDirtyFiles.values()) {
            for (FilePath filePath : paths) {
                VirtualFile vFile = filePath.getVirtualFile();
                if (vFile == null || !vFile.isValid() || !vFile.isDirectory()) continue;
                for (VirtualFile child : vFile.getChildren()) {
                    result.add((Object)new FilePathImpl(child));
                }
            }
        }
        return result;
    }

    public Set<FilePath> getDirtyFilesNoExpand() {
        THashSet paths = new THashSet();
        for (THashSet<FilePath> filePaths : this.myDirtyFiles.values()) {
            paths.addAll(filePaths);
        }
        return paths;
    }

    public Set<FilePath> getRecursivelyDirtyDirectories() {
        THashSet result = new THashSet();
        for (THashSet<FilePath> dirsByRoot : this.myDirtyDirectoriesRecursively.values()) {
            result.addAll(dirsByRoot);
        }
        return result;
    }

    public boolean isRecursivelyDirty(VirtualFile vf) {
        for (THashSet<FilePath> dirsByRoot : this.myDirtyDirectoriesRecursively.values()) {
            for (FilePath dir : dirsByRoot) {
                VirtualFile dirVf = dir.getVirtualFile();
                if (dirVf == null || !VfsUtilCore.isAncestor((VirtualFile)dirVf, (VirtualFile)vf, (boolean)false)) continue;
                return true;
            }
        }
        return false;
    }

    public void addDirtyData(final Collection<FilePath> dirs, final Collection<FilePath> files) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                HashSet newFiles = new HashSet(files);
                newFiles.removeAll(dirs);
                MultiMap perRoot = MultiMap.createSet();
                for (Map.Entry entry : VcsDirtyScopeImpl.this.myDirtyDirectoriesRecursively.entrySet()) {
                    newFiles.removeAll((Collection)entry.getValue());
                    for (FilePath path : (THashSet)entry.getValue()) {
                        perRoot.putValue(entry.getKey(), (Object)new FileOrDir(path, true));
                    }
                }
                for (Map.Entry entry : VcsDirtyScopeImpl.this.myDirtyFiles.entrySet()) {
                    for (FilePath path : (THashSet)entry.getValue()) {
                        perRoot.putValue(entry.getKey(), (Object)new FileOrDir(path, false));
                    }
                }
                for (FilePath dir : dirs) {
                    VcsDirtyScopeImpl.this.addFilePathToMap((MultiMap<VirtualFile, FileOrDir>)perRoot, dir, true);
                }
                for (FilePath file : newFiles) {
                    VcsDirtyScopeImpl.this.addFilePathToMap((MultiMap<VirtualFile, FileOrDir>)perRoot, file, false);
                }
                for (Map.Entry entry : perRoot.entrySet()) {
                    Collection set = (Collection)entry.getValue();
                    Collection newCollection = FileUtil.removeAncestors((Collection)set, (Convertor)new Convertor<FileOrDir, String>(){

                        public String convert(FileOrDir o) {
                            return o.myPath.getPath();
                        }
                    }, (PairProcessor)new PairProcessor<FileOrDir, FileOrDir>(){

                        public boolean process(FileOrDir parent, FileOrDir child) {
                            if (parent.myRecursive) {
                                return true;
                            }
                            if (child.myRecursive || child.myPath.isDirectory()) {
                                return false;
                            }
                            return Comparing.equal((Object)child.myPath.getParentPath(), (Object)parent.myPath);
                        }
                    });
                    set.retainAll(newCollection);
                }
                VcsDirtyScopeImpl.this.myAffectedContentRoots.addAll(perRoot.keySet());
                for (Map.Entry entry : perRoot.entrySet()) {
                    VirtualFile root = (VirtualFile)entry.getKey();
                    THashSet curFiles = new THashSet();
                    THashSet curDirs = new THashSet();
                    Collection value = (Collection)entry.getValue();
                    for (FileOrDir fileOrDir : value) {
                        if (fileOrDir.myRecursive) {
                            curDirs.add((Object)fileOrDir.myPath);
                            continue;
                        }
                        curFiles.add((Object)fileOrDir.myPath);
                    }
                    if (!curDirs.isEmpty()) {
                        VcsDirtyScopeImpl.this.myDirtyDirectoriesRecursively.put(root, curDirs);
                    }
                    if (curFiles.isEmpty()) continue;
                    VcsDirtyScopeImpl.this.myDirtyFiles.put(root, curFiles);
                }
            }
        });
    }

    private void addFilePathToMap(MultiMap<VirtualFile, FileOrDir> perRoot, FilePath dir, boolean recursively) {
        VirtualFile vcsRoot = this.myVcsManager.getVcsRootFor(dir);
        if (vcsRoot != null) {
            perRoot.putValue((Object)vcsRoot, (Object)new FileOrDir(dir, recursively));
        }
    }

    public void addDirtyDirRecursively(final FilePath newcomer) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                VirtualFile vcsRoot = VcsDirtyScopeImpl.this.myVcsManager.getVcsRootFor(newcomer);
                if (vcsRoot == null) {
                    return;
                }
                VcsDirtyScopeImpl.this.myAffectedContentRoots.add(vcsRoot);
                for (Map.Entry entry : VcsDirtyScopeImpl.this.myDirtyFiles.entrySet()) {
                    THashSet files;
                    VirtualFile groupRoot = (VirtualFile)entry.getKey();
                    if (groupRoot == null || !VfsUtilCore.isAncestor((VirtualFile)vcsRoot, (VirtualFile)groupRoot, (boolean)false) || (files = (THashSet)entry.getValue()) == null) continue;
                    Iterator it = files.iterator();
                    while (it.hasNext()) {
                        FilePath oldBoy = (FilePath)it.next();
                        if (!oldBoy.isUnder(newcomer, false)) continue;
                        it.remove();
                    }
                }
                THashSet dirsByRoot = (THashSet)VcsDirtyScopeImpl.this.myDirtyDirectoriesRecursively.get(vcsRoot);
                if (dirsByRoot == null) {
                    dirsByRoot = new THashSet();
                    VcsDirtyScopeImpl.this.myDirtyDirectoriesRecursively.put(vcsRoot, dirsByRoot);
                } else {
                    Iterator it = dirsByRoot.iterator();
                    while (it.hasNext()) {
                        FilePath oldBoy = (FilePath)it.next();
                        if (newcomer.isUnder(oldBoy, false)) {
                            return;
                        }
                        if (!oldBoy.isUnder(newcomer, false)) continue;
                        it.remove();
                    }
                }
                dirsByRoot.add((Object)newcomer);
            }
        });
    }

    public void addDirtyFile(final FilePath newcomer) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                THashSet dirtyFiles;
                VirtualFile vcsRoot = VcsDirtyScopeImpl.this.myVcsManager.getVcsRootFor(newcomer);
                VcsDirtyScopeImpl.this.myAffectedContentRoots.add(vcsRoot);
                THashSet dirsByRoot = (THashSet)VcsDirtyScopeImpl.this.myDirtyDirectoriesRecursively.get(vcsRoot);
                if (dirsByRoot != null) {
                    for (FilePath oldBoy : dirsByRoot) {
                        if (!newcomer.isUnder(oldBoy, false)) continue;
                        return;
                    }
                }
                if ((dirtyFiles = (THashSet)VcsDirtyScopeImpl.this.myDirtyFiles.get(vcsRoot)) == null) {
                    THashSet set = new THashSet();
                    set.add((Object)newcomer);
                    VcsDirtyScopeImpl.this.myDirtyFiles.put(vcsRoot, set);
                } else if (newcomer.isDirectory()) {
                    Iterator iterator = dirtyFiles.iterator();
                    while (iterator.hasNext()) {
                        FilePath oldBoy = (FilePath)iterator.next();
                        if (oldBoy.isDirectory() || !Comparing.equal((Object)oldBoy.getVirtualFileParent(), (Object)newcomer.getVirtualFile())) continue;
                        iterator.remove();
                    }
                } else if (!dirtyFiles.isEmpty()) {
                    VirtualFile parent = newcomer.getVirtualFileParent();
                    if (parent != null && dirtyFiles.contains((Object)new FilePathImpl(parent))) {
                        return;
                    }
                    dirtyFiles.add((Object)newcomer);
                }
            }
        });
    }

    public void iterate(Processor<FilePath> iterator) {
        VirtualFile vFile;
        if (this.myProject.isDisposed()) {
            return;
        }
        for (VirtualFile root : this.myAffectedContentRoots) {
            THashSet<FilePath> dirsByRoot = this.myDirtyDirectoriesRecursively.get(root);
            if (dirsByRoot == null) continue;
            for (FilePath dir : dirsByRoot) {
                vFile = dir.getVirtualFile();
                if (vFile == null || !vFile.isValid()) continue;
                this.myVcsManager.iterateVcsRoot(vFile, iterator);
            }
        }
        for (VirtualFile root : this.myAffectedContentRoots) {
            THashSet<FilePath> files = this.myDirtyFiles.get(root);
            if (files == null) continue;
            for (FilePath file : files) {
                iterator.process((Object)file);
                vFile = file.getVirtualFile();
                if (vFile == null || !vFile.isValid() || !vFile.isDirectory()) continue;
                for (VirtualFile child : vFile.getChildren()) {
                    iterator.process((Object)new FilePathImpl(child));
                }
            }
        }
    }

    public void iterateExistingInsideScope(Processor<VirtualFile> processor) {
        VirtualFile vFile;
        if (this.myProject.isDisposed()) {
            return;
        }
        for (VirtualFile root : this.myAffectedContentRoots) {
            THashSet<FilePath> dirsByRoot = this.myDirtyDirectoriesRecursively.get(root);
            if (dirsByRoot == null) continue;
            for (FilePath dir : dirsByRoot) {
                vFile = VcsDirtyScopeImpl.obtainVirtualFile(dir);
                if (vFile == null || !vFile.isValid()) continue;
                this.myVcsManager.iterateVfUnderVcsRoot(vFile, processor);
            }
        }
        for (VirtualFile root : this.myAffectedContentRoots) {
            THashSet<FilePath> files = this.myDirtyFiles.get(root);
            if (files == null) continue;
            for (FilePath file : files) {
                vFile = VcsDirtyScopeImpl.obtainVirtualFile(file);
                if (vFile == null || !vFile.isValid()) continue;
                processor.process((Object)vFile);
                if (!vFile.isDirectory()) continue;
                for (VirtualFile child : vFile.getChildren()) {
                    processor.process((Object)child);
                }
            }
        }
    }

    @Nullable
    private static VirtualFile obtainVirtualFile(FilePath file) {
        VirtualFile vFile = file.getVirtualFile();
        return vFile == null ? VfsUtil.findFileByIoFile((File)file.getIOFile(), (boolean)false) : vFile;
    }

    public boolean isEmpty() {
        return this.myDirtyDirectoriesRecursively.isEmpty() && this.myDirtyFiles.isEmpty();
    }

    public boolean belongsTo(final FilePath path, final Consumer<AbstractVcs> vcsConsumer) {
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                if (VcsDirtyScopeImpl.this.myProject.isDisposed()) {
                    return Boolean.FALSE;
                }
                VcsRoot rootObject = VcsDirtyScopeImpl.this.myVcsManager.getVcsRootObjectFor(path);
                if (vcsConsumer != null && rootObject != null) {
                    vcsConsumer.consume((Object)rootObject.getVcs());
                }
                if (rootObject == null || rootObject.getVcs() != VcsDirtyScopeImpl.this.myVcs) {
                    return Boolean.FALSE;
                }
                VirtualFile vcsRoot = rootObject.getPath();
                if (vcsRoot != null) {
                    for (VirtualFile contentRoot : VcsDirtyScopeImpl.this.myAffectedContentRoots) {
                        THashSet dirsByRoot;
                        if (!VfsUtilCore.isAncestor((VirtualFile)contentRoot, (VirtualFile)vcsRoot, (boolean)false) || (dirsByRoot = (THashSet)VcsDirtyScopeImpl.this.myDirtyDirectoriesRecursively.get(contentRoot)) == null) continue;
                        for (FilePath filePath : dirsByRoot) {
                            if (!path.isUnder(filePath, false)) continue;
                            return Boolean.TRUE;
                        }
                    }
                }
                if (!VcsDirtyScopeImpl.this.myDirtyFiles.isEmpty()) {
                    VirtualFile vParent = path.getVirtualFileParent();
                    FilePathImpl parent = vParent != null && vParent.isValid() ? new FilePathImpl(vParent) : FilePathImpl.create(path.getIOFile().getParentFile());
                    return VcsDirtyScopeImpl.this.isInDirtyFiles(path) || VcsDirtyScopeImpl.this.isInDirtyFiles(parent);
                }
                return Boolean.FALSE;
            }
        });
    }

    private boolean isInDirtyFiles(FilePath path) {
        THashSet<FilePath> files;
        VcsRoot rootObject = this.myVcsManager.getVcsRootObjectFor(path);
        return rootObject != null && this.myVcs.equals((Object)rootObject.getVcs()) && (files = this.myDirtyFiles.get(rootObject.getPath())) != null && files.contains((Object)path);
    }

    public boolean belongsTo(FilePath path) {
        return this.belongsTo(path, null);
    }

    @NonNls
    public String toString() {
        StringBuilder result = new StringBuilder("VcsDirtyScope[");
        if (!this.myDirtyFiles.isEmpty()) {
            result.append(" files=");
            for (THashSet<FilePath> paths : this.myDirtyFiles.values()) {
                for (FilePath file : paths) {
                    result.append(file).append(" ");
                }
            }
        }
        if (!this.myDirtyDirectoriesRecursively.isEmpty()) {
            result.append(" dirs=");
            for (THashSet<FilePath> dirsByRoot : this.myDirtyDirectoriesRecursively.values()) {
                for (FilePath file : dirsByRoot) {
                    result.append(file).append(" ");
                }
            }
        }
        result.append("affected roots=");
        for (VirtualFile contentRoot : this.myAffectedContentRoots) {
            result.append(contentRoot.getPath()).append(" ");
        }
        result.append("affected roots DISCLOSED=");
        for (VirtualFile contentRoot : this.getAffectedContentRootsWithCheck()) {
            result.append(contentRoot.getPath()).append(" ");
        }
        result.append("]");
        return result.toString();
    }

    public VcsDirtyScopeModifier getModifier() {
        return this.myVcsDirtyScopeModifier;
    }

    public boolean wasEveryThingDirty() {
        return this.myWasEverythingDirty;
    }

    public void setWasEverythingDirty(boolean wasEverythingDirty) {
        this.myWasEverythingDirty = wasEverythingDirty;
    }

    private static class FileOrDir {
        private final FilePath myPath;
        private final boolean myRecursive;

        private FileOrDir(FilePath path, boolean recursive) {
            this.myPath = path;
            this.myRecursive = recursive;
        }
    }
}

