/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates;

import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.platform.templates.ArchivedProjectTemplate;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.Icon;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalArchivedTemplate
extends ArchivedProjectTemplate {
    public static final String DESCRIPTION_PATH = ".idea/description.html";
    static final String TEMPLATE_DESCRIPTOR = ".idea/project-template.xml";
    private final URL myArchivePath;
    private final ModuleType myModuleType;
    private Icon myIcon;

    public LocalArchivedTemplate(@NotNull URL archivePath, @NotNull ClassLoader classLoader) {
        if (archivePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "archivePath", "com/intellij/platform/templates/LocalArchivedTemplate", "<init>"));
        }
        if (classLoader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classLoader", "com/intellij/platform/templates/LocalArchivedTemplate", "<init>"));
        }
        super(LocalArchivedTemplate.getTemplateName(archivePath), null);
        this.myArchivePath = archivePath;
        this.myModuleType = LocalArchivedTemplate.computeModuleType(this);
        String s = this.readEntry(new Condition<ZipEntry>(){

            public boolean value(ZipEntry entry) {
                return entry.getName().endsWith(LocalArchivedTemplate.TEMPLATE_DESCRIPTOR);
            }
        });
        if (s != null) {
            try {
                Element templateElement = JDOMUtil.loadDocument((CharSequence)s).getRootElement();
                this.populateFromElement(templateElement, Namespace.NO_NAMESPACE);
                String iconPath = templateElement.getChildText("icon-path");
                if (iconPath != null) {
                    this.myIcon = IconLoader.findIcon((String)iconPath, (ClassLoader)classLoader);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static String getTemplateName(URL url) {
        String fileName = new File(url.getPath()).getName();
        return fileName.substring(0, fileName.length() - ".zip".length()).replace('_', ' ');
    }

    public String getDescription() {
        return this.readEntry(new Condition<ZipEntry>(){

            public boolean value(ZipEntry entry) {
                return entry.getName().endsWith(LocalArchivedTemplate.DESCRIPTION_PATH);
            }
        });
    }

    @Override
    public Icon getIcon() {
        return this.myIcon == null ? super.getIcon() : this.myIcon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    String readEntry(Condition<ZipEntry> condition) {
        ZipInputStream stream = null;
        try {
            ZipEntry entry;
            stream = this.getStream();
            while ((entry = stream.getNextEntry()) != null) {
                if (!condition.value((Object)entry)) continue;
                String string = StreamUtil.readText((InputStream)stream, (String)"UTF-8");
                return string;
            }
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        finally {
            StreamUtil.closeStream((Closeable)stream);
        }
        return null;
    }

    @NotNull
    private static ModuleType computeModuleType(LocalArchivedTemplate template) {
        ModuleType moduleType;
        String iml = template.readEntry(new Condition<ZipEntry>(){

            public boolean value(ZipEntry entry) {
                return entry.getName().endsWith(".iml");
            }
        });
        if (iml == null) {
            ModuleType moduleType2 = ModuleType.EMPTY;
            if (moduleType2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/templates/LocalArchivedTemplate", "computeModuleType"));
            }
            return moduleType2;
        }
        try {
            Document document = JDOMUtil.loadDocument((CharSequence)iml);
            String type = document.getRootElement().getAttributeValue("type");
            moduleType = ModuleTypeManager.getInstance().findByID(type);
        }
        catch (Exception e) {
            ModuleType moduleType3 = ModuleType.EMPTY;
            if (moduleType3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/templates/LocalArchivedTemplate", "computeModuleType"));
            }
            return moduleType3;
        }
        if (moduleType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/templates/LocalArchivedTemplate", "computeModuleType"));
        }
        return moduleType;
    }

    @Override
    protected ModuleType getModuleType() {
        return this.myModuleType;
    }

    @Override
    public ZipInputStream getStream() throws IOException {
        return new ZipInputStream(this.myArchivePath.openStream());
    }

    public URL getArchivePath() {
        return this.myArchivePath;
    }
}

