/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsTypeElementImpl;
import com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ClsReferenceParameterListImpl
extends ClsElementImpl
implements PsiReferenceParameterList {
    @NonNls
    private static final String EXTENDS_PREFIX = "?extends";
    @NonNls
    private static final String SUPER_PREFIX = "?super";
    private final PsiElement myParent;
    private final ClsTypeElementImpl[] myTypeParameters;
    private volatile PsiType[] myTypeParametersCachedTypes = null;

    public ClsReferenceParameterListImpl(PsiElement parent, String[] classParameters) {
        this.myParent = parent;
        int length = classParameters.length;
        this.myTypeParameters = new ClsTypeElementImpl[length];
        for (int i = 0; i < length; ++i) {
            String s = classParameters[length - i - 1];
            char variance = '\u0000';
            if (s.startsWith(EXTENDS_PREFIX)) {
                variance = '+';
                s = s.substring(EXTENDS_PREFIX.length());
            } else if (s.startsWith(SUPER_PREFIX)) {
                variance = '-';
                s = s.substring(SUPER_PREFIX.length());
            } else if (StringUtil.startsWithChar((CharSequence)s, (char)'?')) {
                variance = '*';
                s = s.substring(1);
            }
            this.myTypeParameters[i] = new ClsTypeElementImpl((PsiElement)this, s, variance);
        }
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/psi/impl/compiled/ClsReferenceParameterListImpl", "appendMirrorText"));
        }
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/compiled/ClsReferenceParameterListImpl", "setMirror"));
        }
    }

    @NotNull
    public PsiTypeElement[] getTypeParameterElements() {
        if (this.myTypeParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsReferenceParameterListImpl", "getTypeParameterElements"));
        }
        return this.myTypeParameters;
    }

    @NotNull
    public PsiType[] getTypeArguments() {
        PsiType[] cachedTypes = this.myTypeParametersCachedTypes;
        if (cachedTypes == null) {
            cachedTypes = PsiType.createArray((int)this.myTypeParameters.length);
            for (int i = 0; i < cachedTypes.length; ++i) {
                cachedTypes[cachedTypes.length - i - 1] = this.myTypeParameters[i].getType();
            }
            this.myTypeParametersCachedTypes = cachedTypes;
        }
        if (cachedTypes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsReferenceParameterListImpl", "getTypeArguments"));
        }
        return cachedTypes;
    }

    @NotNull
    public PsiElement[] getChildren() {
        if (this.myTypeParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsReferenceParameterListImpl", "getChildren"));
        }
        return this.myTypeParameters;
    }

    public PsiElement getParent() {
        return this.myParent;
    }
}

