/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.scopes.ModulesScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.search.PsiSearchHelperImpl;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaFunctionalExpressionSearcher
implements QueryExecutor<PsiFunctionalExpression, FunctionalExpressionSearch.SearchParameters> {
    private static final Logger LOG = Logger.getInstance((String)("#" + JavaFunctionalExpressionSearcher.class.getName()));

    public boolean execute(final @NotNull FunctionalExpressionSearch.SearchParameters queryParameters, @NotNull Processor<PsiFunctionalExpression> consumer) {
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "execute"));
        }
        final PsiClass aClass = queryParameters.getElementToSearch();
        HashSet highLevelModules = new HashSet();
        if (((Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>((Set)highLevelModules){
            final /* synthetic */ Set val$highLevelModules;
            {
                this.val$highLevelModules = set;
            }

            public Boolean compute() {
                if (LambdaUtil.isFunctionalClass((PsiClass)aClass)) {
                    Project project = aClass.getProject();
                    boolean projectLevelIsHigh = PsiUtil.getLanguageLevel((Project)project).isAtLeast(LanguageLevel.JDK_1_8);
                    for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                        LanguageLevel level;
                        LanguageLevelModuleExtension extension = (LanguageLevelModuleExtension)ModuleRootManager.getInstance((Module)module).getModuleExtension(LanguageLevelModuleExtension.class);
                        if (extension == null || ((level = extension.getLanguageLevel()) != null || !projectLevelIsHigh) && (level == null || !level.isAtLeast(LanguageLevel.JDK_1_8))) continue;
                        this.val$highLevelModules.add(module);
                    }
                    return this.val$highLevelModules.isEmpty();
                }
                return true;
            }
        })).booleanValue()) {
            return true;
        }
        return JavaFunctionalExpressionSearcher.collectFunctionalExpressions(aClass, (SearchScope)ApplicationManager.getApplication().runReadAction((Computable)new Computable<SearchScope>(){

            public SearchScope compute() {
                return queryParameters.getEffectiveSearchScope();
            }
        }), consumer, (Set<Module>)highLevelModules);
    }

    public static boolean collectFunctionalExpressions(final PsiClass aClass, final SearchScope searchScope, final Processor<PsiFunctionalExpression> consumer, Set<Module> highLevelModules) {
        final SearchScope classScope = (SearchScope)ApplicationManager.getApplication().runReadAction((Computable)new Computable<SearchScope>(){

            public SearchScope compute() {
                return aClass.getUseScope();
            }
        });
        SearchScope useScope = (SearchScope)ApplicationManager.getApplication().runReadAction((Computable)new Computable<SearchScope>(){

            public SearchScope compute() {
                return searchScope.intersectWith(classScope);
            }
        });
        Project project = PsiUtilCore.getProjectInReadAction((PsiElement)aClass);
        final GlobalSearchScope scope = new ModulesScope(highLevelModules, project).intersectWith((GlobalSearchScope)(useScope instanceof GlobalSearchScope ? (GlobalSearchScope)useScope : new EverythingGlobalScope(project)));
        final ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        HashSet files = new HashSet();
        CommonProcessors.CollectProcessor<VirtualFile> processor = new CommonProcessors.CollectProcessor<VirtualFile>((Collection)files){

            protected boolean accept(VirtualFile virtualFile) {
                return scope.contains(virtualFile) && virtualFile.getFileType() == JavaFileType.INSTANCE && index.isInSource(virtualFile);
            }
        };
        PsiSearchHelperImpl helper = (PsiSearchHelperImpl)PsiSearchHelper.SERVICE.getInstance((Project)project);
        helper.processFilesWithText(scope, (short)1, true, "::", (Processor<VirtualFile>)processor);
        helper.processFilesWithText(scope, (short)1, true, "->", (Processor<VirtualFile>)processor);
        LOG.info("#files: " + files.size());
        final PsiManager psiManager = PsiManager.getInstance((Project)project);
        for (final VirtualFile file : files) {
            if (((Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    return JavaFunctionalExpressionSearcher.processFileWithFunctionalInterfaces(aClass, (Processor<PsiFunctionalExpression>)consumer, psiManager, file);
                }
            })).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private static boolean processFileWithFunctionalInterfaces(final PsiClass aClass, final Processor<PsiFunctionalExpression> consumer, final PsiManager psiManager, VirtualFile file) {
        PsiFile psiFile = psiManager.findFile(file);
        if (psiFile != null) {
            final Ref ref = new Ref((Object)true);
            psiFile.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitElement(PsiElement element) {
                    if (!((Boolean)ref.get()).booleanValue()) {
                        return;
                    }
                    super.visitElement(element);
                }

                private void visitFunctionalExpression(PsiFunctionalExpression expression) {
                    PsiType functionalInterfaceType = expression.getFunctionalInterfaceType();
                    if (psiManager.areElementsEquivalent((PsiElement)PsiUtil.resolveClassInType((PsiType)functionalInterfaceType), (PsiElement)aClass) && !consumer.process((Object)expression)) {
                        ref.set((Object)false);
                    }
                }

                public void visitLambdaExpression(PsiLambdaExpression expression) {
                    super.visitLambdaExpression(expression);
                    this.visitFunctionalExpression((PsiFunctionalExpression)expression);
                }

                public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
                    super.visitMethodReferenceExpression(expression);
                    this.visitFunctionalExpression((PsiFunctionalExpression)expression);
                }
            });
            if (!((Boolean)ref.get()).booleanValue()) {
                return false;
            }
        }
        return true;
    }
}

