/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.java.MethodReferenceResolver;
import com.intellij.psi.impl.source.tree.java.PsiReferenceExpressionBase;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.ElementClassFilter;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.conflictResolvers.DuplicateConflictResolver;
import com.intellij.psi.scope.processor.FilterScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiMethodReferenceExpressionImpl
extends PsiReferenceExpressionBase
implements PsiMethodReferenceExpression {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.java.PsiMethodReferenceExpressionImpl");
    private static final MethodReferenceResolver RESOLVER = new MethodReferenceResolver();

    public PsiMethodReferenceExpressionImpl() {
        super(JavaElementType.METHOD_REF_EXPRESSION);
    }

    public PsiTypeElement getQualifierType() {
        PsiElement qualifier = this.getQualifier();
        return qualifier instanceof PsiTypeElement ? (PsiTypeElement)qualifier : null;
    }

    @Nullable
    public PsiType getFunctionalInterfaceType() {
        return FunctionalInterfaceParameterizationUtil.getGroundTargetType(LambdaUtil.getFunctionalInterfaceType((PsiElement)this, (boolean)true));
    }

    public boolean isExact() {
        return this.getPotentiallyApplicableMember() != null;
    }

    public boolean isPotentiallyCompatible(final PsiType functionalInterfaceType) {
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType);
        if (interfaceMethod == null) {
            return false;
        }
        MethodReferenceResolver resolver = new MethodReferenceResolver(){

            @Override
            protected PsiConflictResolver createResolver(PsiMethodReferenceExpressionImpl referenceExpression, PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult, PsiMethod interfaceMethod, MethodSignature signature) {
                return DuplicateConflictResolver.INSTANCE;
            }

            @Override
            protected PsiType getInterfaceType(PsiMethodReferenceExpression reference) {
                return functionalInterfaceType;
            }
        };
        JavaResolveResult[] result = resolver.resolve(this, this.getContainingFile(), false);
        PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult((PsiMethodReferenceExpression)this);
        int interfaceArity = interfaceMethod.getParameterList().getParametersCount();
        for (JavaResolveResult resolveResult : result) {
            PsiElement element = resolveResult.getElement();
            if (element instanceof PsiMethod) {
                boolean isStatic = ((PsiMethod)element).hasModifierProperty("static");
                if (qualifierResolveResult.isReferenceTypeQualified() && this.getReferenceNameElement() instanceof PsiIdentifier) {
                    int parametersCount = ((PsiMethod)element).getParameterList().getParametersCount();
                    if (parametersCount == interfaceArity && isStatic) {
                        return true;
                    }
                    if (parametersCount == interfaceArity - 1 && !isStatic) {
                        return true;
                    }
                    if (!((PsiMethod)element).isVarArgs()) continue;
                    return true;
                }
                if (isStatic) continue;
                return true;
            }
            if (!(element instanceof PsiClass)) continue;
            return true;
        }
        return false;
    }

    public PsiMember getPotentiallyApplicableMember() {
        return (PsiMember)CachedValuesManager.getCachedValue((PsiElement)this, (CachedValueProvider)new CachedValueProvider<PsiMember>(){

            @Nullable
            public CachedValueProvider.Result<PsiMember> compute() {
                return CachedValueProvider.Result.createSingleDependency((Object)PsiMethodReferenceExpressionImpl.this.getPotentiallyApplicableMemberInternal(), (Object)PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
            }
        });
    }

    private PsiMember getPotentiallyApplicableMemberInternal() {
        PsiElement element = this.getReferenceNameElement();
        PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult((PsiMethodReferenceExpression)this);
        PsiClass containingClass = qualifierResolveResult.getContainingClass();
        if (containingClass != null) {
            PsiMethod[] methods = null;
            if (element instanceof PsiIdentifier) {
                String identifierName = element.getText();
                ArrayList<PsiMethod> result = new ArrayList<PsiMethod>();
                for (HierarchicalMethodSignature signature : containingClass.getVisibleSignatures()) {
                    if (!identifierName.equals(signature.getName())) continue;
                    result.add(signature.getMethod());
                }
                methods = result.toArray(new PsiMethod[result.size()]);
            } else if (this.isConstructor()) {
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.getProject());
                PsiClass arrayClass = factory.getArrayClass(PsiUtil.getLanguageLevel((PsiElement)this));
                if (arrayClass == containingClass) {
                    PsiType componentType = qualifierResolveResult.getSubstitutor().substitute(arrayClass.getTypeParameters()[0]);
                    LOG.assertTrue(componentType != null, (Object)qualifierResolveResult.getSubstitutor());
                    return factory.createMethodFromText("public " + componentType.createArrayType().getCanonicalText() + " __array__(int i) {return null;}", (PsiElement)this);
                }
                methods = containingClass.getConstructors();
            }
            if (methods != null) {
                PsiMethod psiMethod = null;
                if (methods.length > 0) {
                    for (PsiMethod method : methods) {
                        if (!PsiUtil.isAccessible((PsiMember)method, (PsiElement)this, null)) continue;
                        if (psiMethod != null) {
                            return null;
                        }
                        psiMethod = method;
                    }
                    if (psiMethod == null) {
                        return null;
                    }
                    if (psiMethod.isVarArgs()) {
                        return null;
                    }
                    if (psiMethod.getTypeParameters().length > 0) {
                        PsiReferenceParameterList parameterList = this.getParameterList();
                        return parameterList != null && parameterList.getTypeParameterElements().length > 0 ? psiMethod : null;
                    }
                    PsiSubstitutor classSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)psiMethod.getContainingClass(), (PsiClass)containingClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                    HashSet<PsiType> signature = new HashSet<PsiType>(Arrays.asList(psiMethod.getSignature(PsiSubstitutor.EMPTY).getParameterTypes()));
                    signature.add(psiMethod.getReturnType());
                    boolean free = true;
                    for (PsiType type : signature) {
                        if (classSubstitutor != null) {
                            type = classSubstitutor.substitute(type);
                        }
                        if (type == null || !PsiPolyExpressionUtil.mentionsTypeParameters(type, ContainerUtil.newHashSet((Object[])containingClass.getTypeParameters())).booleanValue()) continue;
                        free = false;
                        break;
                    }
                    if (free) {
                        return psiMethod;
                    }
                }
                if (containingClass.hasTypeParameters()) {
                    PsiReferenceParameterList parameterList;
                    PsiElement qualifier = this.getQualifier();
                    PsiJavaCodeReferenceElement referenceElement = null;
                    if (qualifier instanceof PsiTypeElement) {
                        referenceElement = ((PsiTypeElement)qualifier).getInnermostComponentReferenceElement();
                    } else if (qualifier instanceof PsiReferenceExpression) {
                        PsiReferenceExpression expression = (PsiReferenceExpression)qualifier;
                        if (qualifierResolveResult.isReferenceTypeQualified()) {
                            referenceElement = expression;
                        }
                    }
                    if (referenceElement != null && ((parameterList = referenceElement.getParameterList()) == null || parameterList.getTypeParameterElements().length == 0)) {
                        return null;
                    }
                }
                return psiMethod == null ? containingClass : psiMethod;
            }
        }
        return null;
    }

    public PsiExpression getQualifierExpression() {
        PsiElement qualifier = this.getQualifier();
        return qualifier instanceof PsiExpression ? (PsiExpression)qualifier : null;
    }

    public PsiType getType() {
        return new PsiMethodReferenceType((PsiMethodReferenceExpression)this);
    }

    public PsiElement getReferenceNameElement() {
        PsiElement element = this.getLastChild();
        return element instanceof PsiIdentifier || PsiUtil.isJavaToken((PsiElement)element, (IElementType)JavaTokenType.NEW_KEYWORD) ? element : null;
    }

    public void processVariants(@NotNull PsiScopeProcessor processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl", "processVariants"));
        }
        FilterScopeProcessor proc = new FilterScopeProcessor((ElementFilter)ElementClassFilter.METHOD, processor);
        PsiScopesUtil.resolveAndWalk(proc, (PsiJavaCodeReferenceElement)this, null, true);
    }

    @Override
    public void setQualifierExpression(@Nullable PsiExpression newQualifier) throws IncorrectOperationException {
        if (newQualifier == null) {
            LOG.error("Forbidden null qualifier");
            return;
        }
        PsiExpression expression = this.getQualifierExpression();
        if (expression != null) {
            expression.replace((PsiElement)newQualifier);
        } else {
            PsiElement qualifier = this.getQualifier();
            if (qualifier != null) {
                qualifier.replace((PsiElement)newQualifier);
            }
        }
    }

    @Override
    public int getChildRole(ASTNode child) {
        IElementType elType = child.getElementType();
        if (elType == JavaTokenType.DOUBLE_COLON) {
            return 253;
        }
        if (elType == JavaTokenType.IDENTIFIER) {
            return 53;
        }
        if (elType == JavaElementType.REFERENCE_EXPRESSION) {
            return 119;
        }
        return 64;
    }

    @NotNull
    public JavaResolveResult[] multiResolve(boolean incompleteCode) {
        JavaResolveResult[] javaResolveResultArray = PsiImplUtil.multiResolveImpl(this, incompleteCode, RESOLVER);
        if (javaResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl", "multiResolve"));
        }
        return javaResolveResultArray;
    }

    public PsiElement getQualifier() {
        PsiElement element = this.getFirstChild();
        return element instanceof PsiExpression || element instanceof PsiTypeElement ? element : null;
    }

    public TextRange getRangeInElement() {
        PsiElement element = this.getReferenceNameElement();
        if (element != null) {
            int offsetInParent = element.getStartOffsetInParent();
            return new TextRange(offsetInParent, offsetInParent + element.getTextLength());
        }
        PsiElement colons = this.findPsiChildByType(JavaTokenType.DOUBLE_COLON);
        if (colons != null) {
            int offsetInParent = colons.getStartOffsetInParent();
            return new TextRange(offsetInParent, offsetInParent + colons.getTextLength());
        }
        LOG.error(this.getText());
        return null;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl", "getCanonicalText"));
        }
        return string;
    }

    @Override
    public boolean isReferenceTo(PsiElement element) {
        if (!(element instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method = (PsiMethod)element;
        PsiElement nameElement = this.getReferenceNameElement();
        if (nameElement instanceof PsiIdentifier ? !nameElement.getText().equals(method.getName()) : PsiUtil.isJavaToken((PsiElement)nameElement, (IElementType)JavaTokenType.NEW_KEYWORD) && !method.isConstructor()) {
            return false;
        }
        return element.getManager().areElementsEquivalent(element, this.resolve());
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitMethodReferenceExpression((PsiMethodReferenceExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl", "bindToElement"));
        }
        return this;
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        PsiElement oldIdentifier = this.findChildByRoleAsPsiElement(53);
        if (oldIdentifier == null) {
            oldIdentifier = this.findChildByRoleAsPsiElement(119);
        }
        if (oldIdentifier == null) {
            throw new IncorrectOperationException();
        }
        String oldRefName = oldIdentifier.getText();
        if ("this".equals(oldRefName) || "super".equals(oldRefName) || "new".equals(oldRefName) || Comparing.strEqual((String)oldRefName, (String)newElementName)) {
            return this;
        }
        PsiIdentifier identifier = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createIdentifier(newElementName);
        oldIdentifier.replace((PsiElement)identifier);
        return this;
    }

    public boolean isConstructor() {
        PsiElement element = this.getReferenceNameElement();
        return element instanceof PsiKeyword && "new".equals(element.getText());
    }

    @Override
    public String toString() {
        return "PsiMethodReferenceExpression:" + this.getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAcceptable(PsiType left) {
        JavaResolveResult result;
        MethodCandidateInfo.CurrentCandidateProperties candidateProperties;
        if (left instanceof PsiIntersectionType) {
            for (PsiType conjunct : ((PsiIntersectionType)left).getConjuncts()) {
                if (!this.isAcceptable(conjunct)) continue;
                return true;
            }
            return false;
        }
        PsiElement argsList = PsiTreeUtil.getParentOfType((PsiElement)this, PsiExpressionList.class);
        boolean isExact = this.isExact();
        if (MethodCandidateInfo.ourOverloadGuard.currentStack().contains(argsList) && isExact && (candidateProperties = MethodCandidateInfo.getCurrentMethod((PsiElement)argsList)) != null && !InferenceSession.isPertinentToApplicability((PsiExpression)this, candidateProperties.getMethod())) {
            return true;
        }
        if (!this.isPotentiallyCompatible(left = FunctionalInterfaceParameterizationUtil.getGroundTargetType(left))) {
            return false;
        }
        if (MethodCandidateInfo.ourOverloadGuard.currentStack().contains(argsList) && !isExact) {
            return true;
        }
        Map map = PsiMethodReferenceUtil.getFunctionalTypeMap();
        try {
            if (map.put(this, left) != null) {
                boolean bl = false;
                return bl;
            }
            result = this.advancedResolve(false);
        }
        finally {
            map.remove(this);
        }
        PsiElement resolve = result.getElement();
        if (resolve == null) {
            return false;
        }
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)left);
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClassType.ClassResolveResult)resolveResult);
        if (interfaceMethod != null) {
            PsiType interfaceReturnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)left);
            if (interfaceReturnType == PsiType.VOID || interfaceReturnType == null) {
                return true;
            }
            PsiSubstitutor subst = result.getSubstitutor();
            PsiClassType methodReturnType = null;
            PsiClass containingClass = null;
            if (resolve instanceof PsiMethod) {
                containingClass = ((PsiMethod)resolve).getContainingClass();
                PsiType returnType = PsiTypesUtil.patchMethodGetClassReturnType((PsiExpression)this, (PsiReferenceExpression)this, (PsiMethod)((PsiMethod)resolve), null, (LanguageLevel)PsiUtil.getLanguageLevel((PsiElement)this));
                if (returnType == null) {
                    returnType = ((PsiMethod)resolve).getReturnType();
                }
                if (returnType == PsiType.VOID) {
                    return false;
                }
                PsiClass qContainingClass = PsiMethodReferenceUtil.getQualifierResolveResult((PsiMethodReferenceExpression)this).getContainingClass();
                if (qContainingClass != null && containingClass != null && PsiMethodReferenceUtil.isReceiverType((PsiType)left, (PsiClass)containingClass, (PsiMethod)((PsiMethod)resolve))) {
                    LOG.assertTrue((subst = TypeConversionUtil.getClassSubstitutor((PsiClass)containingClass, (PsiClass)qContainingClass, (PsiSubstitutor)subst)) != null);
                }
                methodReturnType = subst.substitute(returnType);
            } else if (resolve instanceof PsiClass) {
                PsiTypeParameter[] typeParameters;
                if (resolve == JavaPsiFacade.getElementFactory((Project)resolve.getProject()).getArrayClass(PsiUtil.getLanguageLevel((PsiElement)resolve)) && (typeParameters = ((PsiClass)resolve).getTypeParameters()).length == 1) {
                    PsiType arrayComponentType = subst.substitute(typeParameters[0]);
                    if (arrayComponentType == null) {
                        return false;
                    }
                    methodReturnType = arrayComponentType.createArrayType();
                }
                containingClass = (PsiClass)resolve;
            }
            if (methodReturnType == null) {
                if (containingClass == null) {
                    return false;
                }
                methodReturnType = JavaPsiFacade.getElementFactory((Project)this.getProject()).createType(containingClass, subst);
            }
            return TypeConversionUtil.isAssignable((PsiType)interfaceReturnType, methodReturnType, (boolean)false);
        }
        return false;
    }

    @Nullable
    public Icon getIcon(int flags) {
        return AllIcons.Nodes.AnonymousClass;
    }
}

