/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.SingleTaskController;
import com.intellij.vcs.log.data.VcsLogHashMap;
import com.intellij.vcs.log.data.VcsLogJoiner;
import com.intellij.vcs.log.data.VcsLogMultiRepoJoiner;
import com.intellij.vcs.log.data.VcsLogRefreshNotEnoughDataException;
import com.intellij.vcs.log.data.VcsLogRefresher;
import com.intellij.vcs.log.data.VcsUserRegistryImpl;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.GraphCommitImpl;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.impl.RequirementsImpl;
import com.intellij.vcs.log.util.StopWatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogRefresherImpl
implements VcsLogRefresher {
    private static final Logger LOG = Logger.getInstance(VcsLogRefresherImpl.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsLogHashMap myHashMap;
    @NotNull
    private final Map<VirtualFile, VcsLogProvider> myProviders;
    @NotNull
    private final VcsUserRegistryImpl myUserRegistry;
    @NotNull
    private final Map<Hash, VcsCommitMetadata> myTopCommitsDetailsCache;
    @NotNull
    private final Consumer<Exception> myExceptionHandler;
    private final int myRecentCommitCount;
    @NotNull
    private final SingleTaskController<RefreshRequest, DataPack> mySingleTaskController;
    @NotNull
    private DataPack myDataPack;

    public VcsLogRefresherImpl(@NotNull Project project, @NotNull VcsLogHashMap hashMap, @NotNull Map<VirtualFile, VcsLogProvider> providers, @NotNull VcsUserRegistryImpl userRegistry, @NotNull Map<Hash, VcsCommitMetadata> topCommitsDetailsCache, final @NotNull Consumer<DataPack> dataPackUpdateHandler, @NotNull Consumer<Exception> exceptionHandler, int recentCommitsCount) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/data/VcsLogRefresherImpl", "<init>"));
        }
        if (hashMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashMap", "com/intellij/vcs/log/data/VcsLogRefresherImpl", "<init>"));
        }
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "com/intellij/vcs/log/data/VcsLogRefresherImpl", "<init>"));
        }
        if (userRegistry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userRegistry", "com/intellij/vcs/log/data/VcsLogRefresherImpl", "<init>"));
        }
        if (topCommitsDetailsCache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topCommitsDetailsCache", "com/intellij/vcs/log/data/VcsLogRefresherImpl", "<init>"));
        }
        if (dataPackUpdateHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPackUpdateHandler", "com/intellij/vcs/log/data/VcsLogRefresherImpl", "<init>"));
        }
        if (exceptionHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionHandler", "com/intellij/vcs/log/data/VcsLogRefresherImpl", "<init>"));
        }
        this.myDataPack = DataPack.EMPTY;
        this.myProject = project;
        this.myHashMap = hashMap;
        this.myProviders = providers;
        this.myUserRegistry = userRegistry;
        this.myTopCommitsDetailsCache = topCommitsDetailsCache;
        this.myExceptionHandler = exceptionHandler;
        this.myRecentCommitCount = recentCommitsCount;
        Consumer<DataPack> dataPackUpdater = new Consumer<DataPack>(){

            public void consume(@NotNull DataPack dataPack) {
                if (dataPack == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/data/VcsLogRefresherImpl$1", "consume"));
                }
                VcsLogRefresherImpl.this.myDataPack = dataPack;
                dataPackUpdateHandler.consume((Object)dataPack);
            }
        };
        this.mySingleTaskController = new SingleTaskController<RefreshRequest, DataPack>((Consumer)dataPackUpdater){

            @Override
            protected void startNewBackgroundTask() {
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ProgressManagerImpl.runProcessWithProgressAsynchronously(new MyRefreshTask(VcsLogRefresherImpl.this.myDataPack));
                    }
                });
            }
        };
    }

    @Override
    @NotNull
    public DataPack readFirstBlock() {
        DataPack dataPack;
        try {
            LogInfo data = this.loadRecentData(new CommitCountRequirements(this.myRecentCommitCount).asMap(this.myProviders.keySet()));
            Collection commits = data.getCommits();
            Map<VirtualFile, Set<VcsRef>> refs = data.getRefs();
            DataPack dataPack2 = DataPack.build(VcsLogRefresherImpl.multiRepoJoin(commits), refs, this.myProviders, this.myHashMap, false);
            this.mySingleTaskController.request(RefreshRequest.RELOAD_ALL);
            dataPack = dataPack2;
        }
        catch (VcsException e) {
            this.myExceptionHandler.consume((Object)e);
            DataPack dataPack3 = DataPack.EMPTY;
            if (dataPack3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogRefresherImpl", "readFirstBlock"));
            }
            return dataPack3;
        }
        if (dataPack == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogRefresherImpl", "readFirstBlock"));
        }
        return dataPack;
    }

    @NotNull
    private LogInfo loadRecentData(final @NotNull Map<VirtualFile, VcsLogProvider.Requirements> requirements) throws VcsException {
        if (requirements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requirements", "com/intellij/vcs/log/data/VcsLogRefresherImpl", "loadRecentData"));
        }
        final StopWatch sw = StopWatch.start("loading commits");
        final LogInfo logInfo = new LogInfo();
        new ProviderIterator(){

            @Override
            public void each(@NotNull VirtualFile root, @NotNull VcsLogProvider provider) throws VcsException {
                if (root == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/VcsLogRefresherImpl$3", "each"));
                }
                if (provider == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/vcs/log/data/VcsLogRefresherImpl$3", "each"));
                }
                VcsLogProvider.DetailedLogData data = provider.readFirstBlock(root, (VcsLogProvider.Requirements)requirements.get(root));
                VcsLogRefresherImpl.this.storeUsersAndDetails(data.getCommits());
                logInfo.put(root, VcsLogRefresherImpl.this.compactCommits(data.getCommits()));
                logInfo.put(root, data.getRefs());
                sw.rootCompleted(root);
            }
        }.iterate(this.getProvidersForRoots(requirements.keySet()));
        this.myUserRegistry.flush();
        sw.report();
        LogInfo logInfo2 = logInfo;
        if (logInfo2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogRefresherImpl", "loadRecentData"));
        }
        return logInfo2;
    }

    @NotNull
    private Map<VirtualFile, VcsLogProvider> getProvidersForRoots(@NotNull Set<VirtualFile> roots) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/vcs/log/data/VcsLogRefresherImpl", "getProvidersForRoots"));
        }
        Map map = ContainerUtil.map2Map(roots, (Function)new Function<VirtualFile, Pair<VirtualFile, VcsLogProvider>>(){

            public Pair<VirtualFile, VcsLogProvider> fun(VirtualFile root) {
                return Pair.create((Object)root, VcsLogRefresherImpl.this.myProviders.get(root));
            }
        });
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogRefresherImpl", "getProvidersForRoots"));
        }
        return map;
    }

    @Override
    public void refresh(@NotNull Collection<VirtualFile> rootsToRefresh) {
        if (rootsToRefresh == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootsToRefresh", "com/intellij/vcs/log/data/VcsLogRefresherImpl", "refresh"));
        }
        if (!rootsToRefresh.isEmpty()) {
            this.mySingleTaskController.request(new RefreshRequest(rootsToRefresh));
        }
    }

    @NotNull
    private static <T extends GraphCommit<Integer>> List<T> multiRepoJoin(@NotNull Collection<List<T>> commits) {
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "com/intellij/vcs/log/data/VcsLogRefresherImpl", "multiRepoJoin"));
        }
        StopWatch sw = StopWatch.start("multi-repo join");
        List joined = new VcsLogMultiRepoJoiner().join(commits);
        sw.report();
        List list = joined;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogRefresherImpl", "multiRepoJoin"));
        }
        return list;
    }

    @NotNull
    private List<GraphCommit<Integer>> compactCommits(@NotNull List<? extends TimedVcsCommit> commits) {
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "com/intellij/vcs/log/data/VcsLogRefresherImpl", "compactCommits"));
        }
        StopWatch sw = StopWatch.start("compacting commits");
        List map = ContainerUtil.map(commits, (Function)new Function<TimedVcsCommit, GraphCommit<Integer>>(){

            @NotNull
            public GraphCommit<Integer> fun(@NotNull TimedVcsCommit commit) {
                if (commit == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "com/intellij/vcs/log/data/VcsLogRefresherImpl$5", "fun"));
                }
                GraphCommitImpl graphCommitImpl = VcsLogRefresherImpl.this.compactCommit(commit);
                if (graphCommitImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogRefresherImpl$5", "fun"));
                }
                return graphCommitImpl;
            }
        });
        this.myHashMap.flush();
        sw.report();
        List list = map;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogRefresherImpl", "compactCommits"));
        }
        return list;
    }

    @NotNull
    private GraphCommitImpl<Integer> compactCommit(@NotNull TimedVcsCommit commit) {
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "com/intellij/vcs/log/data/VcsLogRefresherImpl", "compactCommit"));
        }
        GraphCommitImpl<Integer> graphCommitImpl = new GraphCommitImpl<Integer>(this.myHashMap.getCommitIndex((Hash)commit.getId()), ContainerUtil.map((Collection)commit.getParents(), this.myHashMap.asIndexGetter()), commit.getTimestamp());
        if (graphCommitImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogRefresherImpl", "compactCommit"));
        }
        return graphCommitImpl;
    }

    private void storeUsersAndDetails(@NotNull Collection<? extends VcsCommitMetadata> metadatas) {
        if (metadatas == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metadatas", "com/intellij/vcs/log/data/VcsLogRefresherImpl", "storeUsersAndDetails"));
        }
        for (VcsCommitMetadata vcsCommitMetadata : metadatas) {
            this.myUserRegistry.addUser(vcsCommitMetadata.getAuthor());
            this.myUserRegistry.addUser(vcsCommitMetadata.getCommitter());
            this.myTopCommitsDetailsCache.put((Hash)vcsCommitMetadata.getId(), vcsCommitMetadata);
        }
    }

    private static class LogInfo {
        private final Map<VirtualFile, Set<VcsRef>> myRefs = ContainerUtil.newHashMap();
        private final Map<VirtualFile, List<GraphCommit<Integer>>> myCommits = ContainerUtil.newHashMap();

        private LogInfo() {
        }

        void put(@NotNull VirtualFile root, @NotNull List<GraphCommit<Integer>> commits) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/VcsLogRefresherImpl$LogInfo", "put"));
            }
            if (commits == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "com/intellij/vcs/log/data/VcsLogRefresherImpl$LogInfo", "put"));
            }
            this.myCommits.put(root, commits);
        }

        void put(@NotNull VirtualFile root, @NotNull Set<VcsRef> refs) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/VcsLogRefresherImpl$LogInfo", "put"));
            }
            if (refs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/vcs/log/data/VcsLogRefresherImpl$LogInfo", "put"));
            }
            this.myRefs.put(root, refs);
        }

        @NotNull
        Collection<List<GraphCommit<Integer>>> getCommits() {
            Collection<List<GraphCommit<Integer>>> collection = this.myCommits.values();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogRefresherImpl$LogInfo", "getCommits"));
            }
            return collection;
        }

        List<GraphCommit<Integer>> getCommits(@NotNull VirtualFile root) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/VcsLogRefresherImpl$LogInfo", "getCommits"));
            }
            return this.myCommits.get(root);
        }

        @NotNull
        Map<VirtualFile, Set<VcsRef>> getRefs() {
            Map<VirtualFile, Set<VcsRef>> map = this.myRefs;
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogRefresherImpl$LogInfo", "getRefs"));
            }
            return map;
        }

        public Set<VcsRef> getRefs(@NotNull VirtualFile root) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/VcsLogRefresherImpl$LogInfo", "getRefs"));
            }
            return this.myRefs.get(root);
        }
    }

    private static class CommitCountRequirements
    implements VcsLogProvider.Requirements {
        private final int myCommitCount;

        public CommitCountRequirements(int commitCount) {
            this.myCommitCount = commitCount;
        }

        public int getCommitCount() {
            return this.myCommitCount;
        }

        @NotNull
        Map<VirtualFile, VcsLogProvider.Requirements> asMap(@NotNull Collection<VirtualFile> roots) {
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/vcs/log/data/VcsLogRefresherImpl$CommitCountRequirements", "asMap"));
            }
            Map map = ContainerUtil.map2Map(roots, (Function)new Function<VirtualFile, Pair<VirtualFile, VcsLogProvider.Requirements>>(){

                public Pair<VirtualFile, VcsLogProvider.Requirements> fun(VirtualFile root) {
                    return Pair.create((Object)root, (Object)CommitCountRequirements.this);
                }
            });
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogRefresherImpl$CommitCountRequirements", "asMap"));
            }
            return map;
        }
    }

    private static abstract class ProviderIterator {
        private ProviderIterator() {
        }

        abstract void each(@NotNull VirtualFile var1, @NotNull VcsLogProvider var2) throws VcsException;

        final void iterate(@NotNull Map<VirtualFile, VcsLogProvider> providers) throws VcsException {
            if (providers == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "com/intellij/vcs/log/data/VcsLogRefresherImpl$ProviderIterator", "iterate"));
            }
            for (Map.Entry<VirtualFile, VcsLogProvider> entry : providers.entrySet()) {
                this.each(entry.getKey(), entry.getValue());
            }
        }
    }

    private static class RefreshRequest {
        private static final RefreshRequest RELOAD_ALL = new RefreshRequest(Collections.<VirtualFile>emptyList());
        private final Collection<VirtualFile> rootsToRefresh;

        RefreshRequest(@NotNull Collection<VirtualFile> rootsToRefresh) {
            if (rootsToRefresh == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootsToRefresh", "com/intellij/vcs/log/data/VcsLogRefresherImpl$RefreshRequest", "<init>"));
            }
            this.rootsToRefresh = rootsToRefresh;
        }
    }

    private class MyRefreshTask
    extends Task.Backgroundable {
        @NotNull
        private DataPack myCurrentDataPack;
        @NotNull
        private final LogInfo myLoadedInfo;

        MyRefreshTask(DataPack currentDataPack) {
            if (currentDataPack == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentDataPack", "com/intellij/vcs/log/data/VcsLogRefresherImpl$MyRefreshTask", "<init>"));
            }
            super(VcsLogRefresherImpl.this.myProject, "Refreshing history...", false);
            this.myLoadedInfo = new LogInfo();
            this.myCurrentDataPack = currentDataPack;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/vcs/log/data/VcsLogRefresherImpl$MyRefreshTask", "run"));
            }
            DataPack dataPack = this.myCurrentDataPack;
            while (true) {
                List<RefreshRequest> requests;
                Collection<VirtualFile> rootsToRefresh;
                if ((rootsToRefresh = this.getRootsToRefresh(requests = VcsLogRefresherImpl.this.mySingleTaskController.popRequests())).isEmpty()) break;
                dataPack = this.doRefresh(rootsToRefresh);
            }
            VcsLogRefresherImpl.this.mySingleTaskController.taskCompleted(dataPack);
        }

        @NotNull
        private Collection<VirtualFile> getRootsToRefresh(@NotNull List<RefreshRequest> requests) {
            if (requests == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requests", "com/intellij/vcs/log/data/VcsLogRefresherImpl$MyRefreshTask", "getRootsToRefresh"));
            }
            ArrayList rootsToRefresh = ContainerUtil.newArrayList();
            for (RefreshRequest request : requests) {
                if (request == RefreshRequest.RELOAD_ALL) {
                    this.myCurrentDataPack = DataPack.EMPTY;
                    Set<VirtualFile> set = VcsLogRefresherImpl.this.myProviders.keySet();
                    if (set == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogRefresherImpl$MyRefreshTask", "getRootsToRefresh"));
                    }
                    return set;
                }
                rootsToRefresh.addAll(request.rootsToRefresh);
            }
            ArrayList arrayList = rootsToRefresh;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogRefresherImpl$MyRefreshTask", "getRootsToRefresh"));
            }
            return arrayList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NotNull
        private DataPack doRefresh(@NotNull Collection<VirtualFile> roots) {
            DataPack dataPack;
            StopWatch sw;
            block14: {
                DataPack dataPack2;
                block13: {
                    if (roots == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/vcs/log/data/VcsLogRefresherImpl$MyRefreshTask", "doRefresh"));
                    }
                    sw = StopWatch.start("refresh");
                    PermanentGraph<Integer> permanentGraph = this.myCurrentDataPack.isFull() ? this.myCurrentDataPack.getPermanentGraph() : null;
                    Map<VirtualFile, Set<VcsRef>> currentRefs = this.myCurrentDataPack.getRefsModel().getAllRefsByRoot();
                    try {
                        if (permanentGraph != null) {
                            int commitCount = VcsLogRefresherImpl.this.myRecentCommitCount;
                            for (int attempt = 0; attempt <= 1; commitCount *= 5, ++attempt) {
                                this.loadLogAndRefs(roots, currentRefs, commitCount);
                                List compoundLog = VcsLogRefresherImpl.multiRepoJoin(this.myLoadedInfo.getCommits());
                                Map<VirtualFile, Set<VcsRef>> allNewRefs = this.getAllNewRefs(this.myLoadedInfo, currentRefs);
                                List<GraphCommit<Integer>> joinedFullLog = this.join(compoundLog, permanentGraph.getAllCommits(), currentRefs, allNewRefs);
                                if (joinedFullLog == null) {
                                    continue;
                                }
                                DataPack dataPack3 = DataPack.build(joinedFullLog, allNewRefs, VcsLogRefresherImpl.this.myProviders, VcsLogRefresherImpl.this.myHashMap, true);
                                dataPack2 = dataPack3;
                                break block13;
                            }
                            LOG.info("Couldn't join " + commitCount / 5 + " recent commits to the log (" + permanentGraph.getAllCommits().size() + " commits)");
                        }
                        DataPack commitCount = this.loadFullLog();
                        dataPack = commitCount;
                        break block14;
                    }
                    catch (Exception e) {
                        VcsLogRefresherImpl.this.myExceptionHandler.consume((Object)e);
                        DataPack dataPack4 = DataPack.EMPTY;
                        DataPack dataPack5 = dataPack4;
                        if (dataPack5 == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogRefresherImpl$MyRefreshTask", "doRefresh"));
                        }
                        return dataPack5;
                    }
                }
                if (dataPack2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogRefresherImpl$MyRefreshTask", "doRefresh"));
                }
                return dataPack2;
            }
            if (dataPack == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogRefresherImpl$MyRefreshTask", "doRefresh"));
            }
            return dataPack;
            finally {
                sw.report();
            }
        }

        @NotNull
        private Map<VirtualFile, Set<VcsRef>> getAllNewRefs(@NotNull LogInfo newInfo, @NotNull Map<VirtualFile, Set<VcsRef>> previousRefs) {
            if (newInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newInfo", "com/intellij/vcs/log/data/VcsLogRefresherImpl$MyRefreshTask", "getAllNewRefs"));
            }
            if (previousRefs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "previousRefs", "com/intellij/vcs/log/data/VcsLogRefresherImpl$MyRefreshTask", "getAllNewRefs"));
            }
            HashMap result = ContainerUtil.newHashMap();
            Iterator<VirtualFile> i$ = previousRefs.keySet().iterator();
            while (i$.hasNext()) {
                VirtualFile root;
                Set<VcsRef> newInfoRefs = newInfo.getRefs(root = i$.next());
                result.put(root, newInfoRefs != null ? newInfoRefs : previousRefs.get(root));
            }
            HashMap hashMap = result;
            if (hashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogRefresherImpl$MyRefreshTask", "getAllNewRefs"));
            }
            return hashMap;
        }

        private void loadLogAndRefs(@NotNull Collection<VirtualFile> roots, @NotNull Map<VirtualFile, Set<VcsRef>> prevRefs, int commitCount) throws VcsException {
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/vcs/log/data/VcsLogRefresherImpl$MyRefreshTask", "loadLogAndRefs"));
            }
            if (prevRefs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prevRefs", "com/intellij/vcs/log/data/VcsLogRefresherImpl$MyRefreshTask", "loadLogAndRefs"));
            }
            LogInfo logInfo = VcsLogRefresherImpl.this.loadRecentData(this.prepareRequirements(roots, commitCount, prevRefs));
            for (VirtualFile root : roots) {
                this.myLoadedInfo.put(root, logInfo.getCommits(root));
                this.myLoadedInfo.put(root, logInfo.getRefs(root));
            }
        }

        @NotNull
        private Map<VirtualFile, VcsLogProvider.Requirements> prepareRequirements(@NotNull Collection<VirtualFile> roots, int commitCount, @NotNull Map<VirtualFile, Set<VcsRef>> prevRefs) {
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/vcs/log/data/VcsLogRefresherImpl$MyRefreshTask", "prepareRequirements"));
            }
            if (prevRefs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prevRefs", "com/intellij/vcs/log/data/VcsLogRefresherImpl$MyRefreshTask", "prepareRequirements"));
            }
            HashMap requirements = ContainerUtil.newHashMap();
            for (VirtualFile root : roots) {
                requirements.put(root, new RequirementsImpl(commitCount, true, ContainerUtil.notNullize(prevRefs.get(root))));
            }
            HashMap hashMap = requirements;
            if (hashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogRefresherImpl$MyRefreshTask", "prepareRequirements"));
            }
            return hashMap;
        }

        @Nullable
        private List<GraphCommit<Integer>> join(@NotNull List<? extends GraphCommit<Integer>> recentCommits, @NotNull List<GraphCommit<Integer>> fullLog, @NotNull Map<VirtualFile, Set<VcsRef>> previousRefs, @NotNull Map<VirtualFile, Set<VcsRef>> newRefs) {
            if (recentCommits == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "recentCommits", "com/intellij/vcs/log/data/VcsLogRefresherImpl$MyRefreshTask", "join"));
            }
            if (fullLog == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullLog", "com/intellij/vcs/log/data/VcsLogRefresherImpl$MyRefreshTask", "join"));
            }
            if (previousRefs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "previousRefs", "com/intellij/vcs/log/data/VcsLogRefresherImpl$MyRefreshTask", "join"));
            }
            if (newRefs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newRefs", "com/intellij/vcs/log/data/VcsLogRefresherImpl$MyRefreshTask", "join"));
            }
            StopWatch sw = StopWatch.start("joining new commits");
            Function<VcsRef, Integer> ref2Int = new Function<VcsRef, Integer>(){

                public Integer fun(@NotNull VcsRef ref) {
                    if (ref == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/vcs/log/data/VcsLogRefresherImpl$MyRefreshTask$1", "fun"));
                    }
                    return VcsLogRefresherImpl.this.myHashMap.getCommitIndex(ref.getCommitHash());
                }
            };
            List prevRefIndices = ContainerUtil.map((Collection)ContainerUtil.concat(previousRefs.values()), (Function)ref2Int);
            List newRefIndices = ContainerUtil.map((Collection)ContainerUtil.concat(newRefs.values()), (Function)ref2Int);
            try {
                List commits = (List)new VcsLogJoiner<CommitId, GraphCommit<Integer>>().addCommits(fullLog, prevRefIndices, recentCommits, newRefIndices).first;
                sw.report();
                return commits;
            }
            catch (VcsLogRefreshNotEnoughDataException e) {
                LOG.info((Throwable)e);
            }
            catch (IllegalStateException e) {
                LOG.info((Throwable)e);
            }
            return null;
        }

        @NotNull
        private DataPack loadFullLog() throws VcsException {
            StopWatch sw = StopWatch.start("full log reload");
            LogInfo logInfo = this.readFullLogFromVcs();
            List graphCommits = VcsLogRefresherImpl.multiRepoJoin(logInfo.getCommits());
            DataPack dataPack = DataPack.build(graphCommits, logInfo.getRefs(), VcsLogRefresherImpl.this.myProviders, VcsLogRefresherImpl.this.myHashMap, true);
            sw.report();
            DataPack dataPack2 = dataPack;
            if (dataPack2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogRefresherImpl$MyRefreshTask", "loadFullLog"));
            }
            return dataPack2;
        }

        @NotNull
        private LogInfo readFullLogFromVcs() throws VcsException {
            final StopWatch sw = StopWatch.start("read full log from VCS");
            final LogInfo logInfo = new LogInfo();
            new ProviderIterator(){

                @Override
                void each(@NotNull VirtualFile root, @NotNull VcsLogProvider provider) throws VcsException {
                    if (root == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/VcsLogRefresherImpl$MyRefreshTask$2", "each"));
                    }
                    if (provider == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/vcs/log/data/VcsLogRefresherImpl$MyRefreshTask$2", "each"));
                    }
                    final ArrayList graphCommits = ContainerUtil.newArrayList();
                    VcsLogProvider.LogData data = provider.readAllHashes(root, (Consumer)new Consumer<TimedVcsCommit>(){

                        public void consume(@NotNull TimedVcsCommit commit) {
                            if (commit == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "com/intellij/vcs/log/data/VcsLogRefresherImpl$MyRefreshTask$2$1", "consume"));
                            }
                            graphCommits.add(VcsLogRefresherImpl.this.compactCommit(commit));
                        }
                    });
                    logInfo.put(root, graphCommits);
                    logInfo.put(root, data.getRefs());
                    VcsLogRefresherImpl.this.myUserRegistry.addUsers(data.getUsers());
                    sw.rootCompleted(root);
                }
            }.iterate(VcsLogRefresherImpl.this.myProviders);
            VcsLogRefresherImpl.this.myUserRegistry.flush();
            sw.report();
            LogInfo logInfo2 = logInfo;
            if (logInfo2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogRefresherImpl$MyRefreshTask", "readFullLogFromVcs"));
            }
            return logInfo2;
        }
    }
}

