/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.visible;

import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.vcs.log.graph.api.LinearGraphWithHiddenNodes;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphNode;
import com.intellij.vcs.log.graph.utils.DfsUtil;
import com.intellij.vcs.log.graph.utils.Flags;
import com.intellij.vcs.log.graph.utils.ListenerController;
import com.intellij.vcs.log.graph.utils.impl.BitSetFlags;
import com.intellij.vcs.log.graph.utils.impl.SetListenerController;
import gnu.trove.TIntIntHashMap;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CollapsedGraphWithHiddenNodes
implements LinearGraphWithHiddenNodes {
    @NotNull
    private final LinearGraphWithHiddenNodes myDelegateGraph;
    @NotNull
    private final Flags myVisibleNodes;
    @NotNull
    private final DfsUtil myDfsUtil;
    @NotNull
    private final TIntIntHashMap upToEdge;
    @NotNull
    private final TIntIntHashMap downToEdge;
    @NotNull
    private final SetListenerController<LinearGraphWithHiddenNodes.UpdateListener> myListenerController;

    public CollapsedGraphWithHiddenNodes(@NotNull LinearGraphWithHiddenNodes delegateGraph) {
        if (delegateGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateGraph", "com/intellij/vcs/log/graph/impl/visible/CollapsedGraphWithHiddenNodes", "<init>"));
        }
        this.myDfsUtil = new DfsUtil();
        this.upToEdge = new TIntIntHashMap();
        this.downToEdge = new TIntIntHashMap();
        this.myListenerController = new SetListenerController();
        this.myDelegateGraph = delegateGraph;
        delegateGraph.getListenerController().addListener(new LinearGraphWithHiddenNodes.UpdateListener(){

            @Override
            public void update(int upNodeIndex, int downNodeIndex) {
                CollapsedGraphWithHiddenNodes.this.callListeners(upNodeIndex, downNodeIndex);
            }
        });
        this.myVisibleNodes = new BitSetFlags(delegateGraph.nodesCount(), true);
    }

    public void fastCollapse(int upNodeIndex, final int downNodeIndex) {
        this.myDfsUtil.nodeDfsIterator(upNodeIndex, new DfsUtil.NextNode(){

            @Override
            public int fun(int currentNode) {
                if (CollapsedGraphWithHiddenNodes.this.upToEdge.containsKey(currentNode)) {
                    int downNode = CollapsedGraphWithHiddenNodes.this.upToEdge.remove(currentNode);
                    CollapsedGraphWithHiddenNodes.this.downToEdge.remove(downNode);
                    if (downNode == downNodeIndex) {
                        return -1;
                    }
                    CollapsedGraphWithHiddenNodes.this.myVisibleNodes.set(downNode, false);
                    return downNode;
                }
                for (int downNode : CollapsedGraphWithHiddenNodes.this.myDelegateGraph.getDownNodes(currentNode)) {
                    if (!CollapsedGraphWithHiddenNodes.this.myVisibleNodes.get(downNode) || downNode == downNodeIndex) continue;
                    CollapsedGraphWithHiddenNodes.this.myVisibleNodes.set(downNode, false);
                    return downNode;
                }
                return -1;
            }
        });
        this.upToEdge.put(upNodeIndex, downNodeIndex);
        this.downToEdge.put(downNodeIndex, upNodeIndex);
    }

    public void collapse(int upNodeIndex, int downNodeIndex) {
        this.fastCollapse(upNodeIndex, downNodeIndex);
        this.callListeners(upNodeIndex, downNodeIndex);
    }

    public void expand(int upNodeIndex, final int downNodeIndex) {
        this.upToEdge.remove(upNodeIndex);
        this.downToEdge.remove(downNodeIndex);
        this.myDfsUtil.nodeDfsIterator(upNodeIndex, new DfsUtil.NextNode(){

            @Override
            public int fun(int currentNode) {
                for (int downNode : CollapsedGraphWithHiddenNodes.this.myDelegateGraph.getDownNodes(currentNode)) {
                    if (CollapsedGraphWithHiddenNodes.this.myVisibleNodes.get(downNode) || downNode == downNodeIndex) continue;
                    CollapsedGraphWithHiddenNodes.this.myVisibleNodes.set(downNode, true);
                    return downNode;
                }
                return -1;
            }
        });
        this.callListeners(upNodeIndex, downNodeIndex);
    }

    private void callListeners(final int upNodeIndex, final int downNodeIndex) {
        this.myListenerController.callListeners(new Consumer<LinearGraphWithHiddenNodes.UpdateListener>(){

            public void consume(LinearGraphWithHiddenNodes.UpdateListener updateListener) {
                updateListener.update(upNodeIndex, downNodeIndex);
            }
        });
    }

    @Override
    public boolean nodeIsVisible(int nodeIndex) {
        if (nodeIndex == Integer.MAX_VALUE) {
            return true;
        }
        return this.myVisibleNodes.get(nodeIndex) && this.myDelegateGraph.nodeIsVisible(nodeIndex);
    }

    public void callListeners() {
        this.callListeners(0, this.myDelegateGraph.nodesCount() - 1);
    }

    public void expandAll() {
        this.upToEdge.clear();
        this.downToEdge.clear();
        this.myVisibleNodes.setAll(true);
        this.callListeners();
    }

    @Override
    @NotNull
    public GraphNode.Type getNodeType(int nodeIndex) {
        GraphNode.Type type = GraphNode.Type.USUAL;
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/visible/CollapsedGraphWithHiddenNodes", "getNodeType"));
        }
        return type;
    }

    @Override
    @NotNull
    public GraphEdge.Type getEdgeType(int upNodeIndex, int downNodeIndex) {
        if (this.upToEdge.containsKey(upNodeIndex)) {
            GraphEdge.Type type = GraphEdge.Type.HIDE;
            if (type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/visible/CollapsedGraphWithHiddenNodes", "getEdgeType"));
            }
            return type;
        }
        GraphEdge.Type type = GraphEdge.Type.USUAL;
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/visible/CollapsedGraphWithHiddenNodes", "getEdgeType"));
        }
        return type;
    }

    @Override
    @NotNull
    public ListenerController<LinearGraphWithHiddenNodes.UpdateListener> getListenerController() {
        SetListenerController<LinearGraphWithHiddenNodes.UpdateListener> setListenerController = this.myListenerController;
        if (setListenerController == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/visible/CollapsedGraphWithHiddenNodes", "getListenerController"));
        }
        return setListenerController;
    }

    @Override
    public int nodesCount() {
        return this.myDelegateGraph.nodesCount();
    }

    @Override
    @NotNull
    public List<Integer> getUpNodes(int nodeIndex) {
        if (this.downToEdge.containsKey(nodeIndex)) {
            List<Integer> list = Collections.singletonList(this.downToEdge.get(nodeIndex));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/visible/CollapsedGraphWithHiddenNodes", "getUpNodes"));
            }
            return list;
        }
        SmartList upNodes = new SmartList();
        for (int upNode : this.myDelegateGraph.getUpNodes(nodeIndex)) {
            if (!this.nodeIsVisible(upNode)) continue;
            upNodes.add(upNode);
        }
        SmartList smartList = upNodes;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/visible/CollapsedGraphWithHiddenNodes", "getUpNodes"));
        }
        return smartList;
    }

    @Override
    @NotNull
    public List<Integer> getDownNodes(int nodeIndex) {
        if (this.upToEdge.containsKey(nodeIndex)) {
            List<Integer> list = Collections.singletonList(this.upToEdge.get(nodeIndex));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/visible/CollapsedGraphWithHiddenNodes", "getDownNodes"));
            }
            return list;
        }
        SmartList downNodes = new SmartList();
        for (int downNode : this.myDelegateGraph.getDownNodes(nodeIndex)) {
            if (!this.nodeIsVisible(downNode)) continue;
            downNodes.add(downNode);
        }
        SmartList smartList = downNodes;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/visible/CollapsedGraphWithHiddenNodes", "getDownNodes"));
        }
        return smartList;
    }
}

