/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.printer.idea;

import com.intellij.vcs.log.graph.SimplePrintElement;
import java.awt.Point;
import org.jetbrains.annotations.NotNull;

public class PositionUtil {
    private static float distance(int x1, int y1, int x2, int y2) {
        return (float)Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
    }

    public static boolean overUpEdge(int upPosition, int downPosition, int x, int y) {
        float thick = 1.5f;
        int x1 = 15 * downPosition + 7;
        int y1 = 11;
        int x2 = 15 * upPosition + 7;
        int y2 = -11;
        return PositionUtil.distance(x1, y1, x, y) + PositionUtil.distance(x2, y2, x, y) < PositionUtil.distance(x1, y1, x2, y2) + thick;
    }

    public static boolean overDownEdge(int upPosition, int downPosition, int x, int y) {
        float thick = 1.5f;
        int x1 = 15 * upPosition + 7;
        int y1 = 11;
        int x2 = 15 * downPosition + 7;
        int y2 = 33;
        return PositionUtil.distance(x1, y1, x, y) + PositionUtil.distance(x2, y2, x, y) < PositionUtil.distance(x1, y1, x2, y2) + thick;
    }

    public static boolean overNode(int position, int x, int y, SimplePrintElement.Type type) {
        int r = 4;
        int x0 = 15 * position + 7;
        int y0 = 11;
        if (type == SimplePrintElement.Type.DOWN_ARROW) {
            y0 = 22 - r;
        }
        if (type == SimplePrintElement.Type.UP_ARROW) {
            y0 = r;
        }
        return PositionUtil.distance(x0, y0, x, y) <= (float)r;
    }

    public static int getYInsideRow(@NotNull Point point) {
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/vcs/log/printer/idea/PositionUtil", "getYInsideRow"));
        }
        return point.y - PositionUtil.getRowIndex(point) * 22;
    }

    public static int getRowIndex(@NotNull Point point) {
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/vcs/log/printer/idea/PositionUtil", "getRowIndex"));
        }
        return point.y / 22;
    }
}

