/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.breadcrumbs.BreadcrumbsInfoProvider;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlLanguageBreadcrumbsInfoProvider
extends BreadcrumbsInfoProvider {
    @NonNls
    private static final String CLASS_ATTRIBUTE_NAME = "class";
    @NonNls
    private static final String ID_ATTRIBUTE_NAME = "id";

    public boolean acceptElement(@NotNull PsiElement e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xml/breadcrumbs/XmlLanguageBreadcrumbsInfoProvider", "acceptElement"));
        }
        return e instanceof XmlTag && e.isValid();
    }

    public Language[] getLanguages() {
        return new Language[]{XMLLanguage.INSTANCE, XHTMLLanguage.INSTANCE, HTMLLanguage.INSTANCE};
    }

    @NotNull
    public String getElementInfo(@NotNull PsiElement e) {
        boolean addHtmlInfo;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xml/breadcrumbs/XmlLanguageBreadcrumbsInfoProvider", "getElementInfo"));
        }
        XmlTag tag = (XmlTag)e;
        StringBuilder sb = new StringBuilder();
        sb.append(tag.getName());
        boolean bl = addHtmlInfo = e.getContainingFile().getLanguage() != XMLLanguage.INSTANCE;
        if (addHtmlInfo) {
            String class_value;
            String id_value = tag.getAttributeValue(ID_ATTRIBUTE_NAME);
            if (null != id_value) {
                sb.append("#").append(id_value);
            }
            if (null != (class_value = tag.getAttributeValue(CLASS_ATTRIBUTE_NAME))) {
                StringTokenizer tokenizer = new StringTokenizer(class_value, " ");
                while (tokenizer.hasMoreTokens()) {
                    sb.append(".").append(tokenizer.nextToken());
                }
            }
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/breadcrumbs/XmlLanguageBreadcrumbsInfoProvider", "getElementInfo"));
        }
        return string;
    }

    @Nullable
    public String getElementTooltip(@NotNull PsiElement e) {
        XmlAttribute[] attributes;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xml/breadcrumbs/XmlLanguageBreadcrumbsInfoProvider", "getElementTooltip"));
        }
        XmlTag tag = (XmlTag)e;
        StringBuilder result = new StringBuilder("&lt;");
        result.append(tag.getName());
        for (XmlAttribute each : attributes = tag.getAttributes()) {
            result.append(" ").append(each.getText());
        }
        if (tag.isEmpty()) {
            result.append("/&gt;");
        } else {
            result.append("&gt;...&lt;/").append(tag.getName()).append("&gt;");
        }
        return result.toString();
    }
}

