/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachedNumberConstructorCallInspection
extends BaseInspection {
    private static final Set<String> cachedNumberTypes = new HashSet<String>();
    public static boolean ignoreStringArguments;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("cached.number.constructor.call.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/CachedNumberConstructorCallInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("cached.number.constructor.call.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/CachedNumberConstructorCallInspection", "buildErrorString"));
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("cached.number.constructor.call.ignore.string.arguments.option", new Object[0]), (InspectionProfileEntry)this, "ignoreStringArguments");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LongConstructorVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        PsiNewExpression expression = (PsiNewExpression)infos[0];
        PsiJavaCodeReferenceElement classReference = expression.getClassReference();
        assert (classReference != null);
        String className = classReference.getText();
        return new CachedNumberConstructorCallFix(className);
    }

    static {
        cachedNumberTypes.add("java.lang.Long");
        cachedNumberTypes.add("java.lang.Byte");
        cachedNumberTypes.add("java.lang.Integer");
        cachedNumberTypes.add("java.lang.Short");
        ignoreStringArguments = false;
    }

    private static class LongConstructorVisitor
    extends BaseInspectionVisitor {
        private LongConstructorVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/numeric/CachedNumberConstructorCallInspection$LongConstructorVisitor", "visitNewExpression"));
            }
            if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)expression)) {
                return;
            }
            super.visitNewExpression(expression);
            PsiType type = expression.getType();
            if (type == null) {
                return;
            }
            String canonicalText = type.getCanonicalText();
            if (!cachedNumberTypes.contains(canonicalText)) {
                return;
            }
            PsiClass aClass = ClassUtils.getContainingClass((PsiElement)expression);
            if (aClass != null && cachedNumberTypes.contains(aClass.getQualifiedName())) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            PsiType argumentType = argument.getType();
            if (argumentType == null || ignoreStringArguments && argumentType.equalsToText("java.lang.String")) {
                return;
            }
            this.registerNewExpressionError(expression, expression);
        }
    }

    private static class CachedNumberConstructorCallFix
    extends InspectionGadgetsFix {
        private final String className;

        CachedNumberConstructorCallFix(String className) {
            this.className = className;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("cached.number.constructor.call.quickfix", this.className);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/CachedNumberConstructorCallInspection$CachedNumberConstructorCallFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Replace with '.valueOf' call" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/CachedNumberConstructorCallInspection$CachedNumberConstructorCallFix", "getFamilyName"));
            }
            return "Replace with '.valueOf' call";
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiNewExpression expression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiNewExpression.class, (boolean)false);
            assert (expression != null);
            PsiExpressionList argList = expression.getArgumentList();
            assert (argList != null);
            PsiExpression[] args = argList.getExpressions();
            PsiExpression arg = args[0];
            String text = arg.getText();
            PsiReplacementUtil.replaceExpression((PsiExpression)expression, this.className + ".valueOf(" + text + ')');
        }
    }
}

