/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.actions;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.tools.idea.ddms.DeviceContext;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import icons.AndroidIcons;
import java.io.IOException;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class ToggleMethodProfilingAction
extends ToggleAction {
    private final Project myProject;
    private final DeviceContext myDeviceContext;

    public ToggleMethodProfilingAction(@NotNull Project p, @NotNull DeviceContext context) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/android/tools/idea/ddms/actions/ToggleMethodProfilingAction", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/ddms/actions/ToggleMethodProfilingAction", "<init>"));
        }
        super(AndroidBundle.message("android.ddms.actions.methodprofile.start", new Object[0]), null, AndroidIcons.Ddms.StartMethodProfiling);
        this.myProject = p;
        this.myDeviceContext = context;
    }

    public boolean isSelected(AnActionEvent e) {
        Client c = this.myDeviceContext.getSelectedClient();
        if (c == null) {
            return false;
        }
        ClientData cd = c.getClientData();
        return cd.getMethodProfilingStatus() == ClientData.MethodProfilingStatus.TRACER_ON || cd.getMethodProfilingStatus() == ClientData.MethodProfilingStatus.SAMPLER_ON;
    }

    public void setSelected(AnActionEvent e, boolean state) {
        Client c = this.myDeviceContext.getSelectedClient();
        if (c == null) {
            return;
        }
        ClientData cd = c.getClientData();
        try {
            if (cd.getMethodProfilingStatus() == ClientData.MethodProfilingStatus.TRACER_ON) {
                c.stopMethodTracer();
            } else {
                c.startMethodTracer();
            }
        }
        catch (IOException e1) {
            Messages.showErrorDialog((Project)this.myProject, (String)("Unexpected error while toggling method profiling: " + e1), (String)"Method Profiling");
        }
    }

    public void update(AnActionEvent e) {
        super.update(e);
        Client c = this.myDeviceContext.getSelectedClient();
        if (c == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        String text = c.getClientData().getMethodProfilingStatus() == ClientData.MethodProfilingStatus.TRACER_ON ? AndroidBundle.message("android.ddms.actions.methodprofile.stop", new Object[0]) : AndroidBundle.message("android.ddms.actions.methodprofile.start", new Object[0]);
        e.getPresentation().setText(text);
        e.getPresentation().setEnabled(true);
    }
}

