/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.invoker.GradleInvoker;
import com.android.tools.idea.gradle.project.AndroidGradleNotification;
import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.gradle.project.NewProjectImportGradleSyncListener;
import com.android.tools.idea.gradle.project.OpenMigrationToGradleUrlHyperlink;
import com.android.tools.idea.gradle.project.PostProjectSetupTasksExecutor;
import com.android.tools.idea.gradle.project.PreSyncChecks;
import com.android.tools.idea.gradle.project.ProjectSetUpTask;
import com.android.tools.idea.gradle.project.SdkSync;
import com.android.tools.idea.gradle.util.FilePaths;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.startup.AndroidStudioSpecificInitializer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleProjectImporter {
    private static final Logger LOG = Logger.getInstance(GradleProjectImporter.class);
    private static final ProjectSystemId SYSTEM_ID = GradleConstants.SYSTEM_ID;
    private final ImporterDelegate myDelegate;
    public static boolean ourSkipSetupFromTest;

    @NotNull
    public static GradleProjectImporter getInstance() {
        GradleProjectImporter gradleProjectImporter = (GradleProjectImporter)ServiceManager.getService(GradleProjectImporter.class);
        if (gradleProjectImporter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/GradleProjectImporter", "getInstance"));
        }
        return gradleProjectImporter;
    }

    public GradleProjectImporter() {
        this.myDelegate = new ImporterDelegate();
    }

    @VisibleForTesting
    GradleProjectImporter(ImporterDelegate delegate) {
        this.myDelegate = delegate;
    }

    public void importProject(@NotNull VirtualFile selectedFile) {
        if (selectedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedFile", "com/android/tools/idea/gradle/project/GradleProjectImporter", "importProject"));
        }
        VirtualFile projectDir = selectedFile.isDirectory() ? selectedFile : selectedFile.getParent();
        File projectDirPath = new File(FileUtil.toSystemDependentName((String)projectDir.getPath()));
        try {
            LocalProperties localProperties = new LocalProperties(projectDirPath);
            if (AndroidStudioSpecificInitializer.isAndroidStudio()) {
                SdkSync.syncIdeAndProjectAndroidHomes(localProperties);
            }
        }
        catch (IOException e) {
            LOG.info("Failed to sync SDKs", (Throwable)e);
            Messages.showErrorDialog((String)e.getMessage(), (String)"Project Import");
            return;
        }
        new GradleSettings(ProjectManager.getInstance().getDefaultProject());
        this.createProjectFileForGradleProject(selectedFile, null);
    }

    private void createProjectFileForGradleProject(@NotNull VirtualFile selectedFile, @Nullable Project parentProject) {
        if (selectedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedFile", "com/android/tools/idea/gradle/project/GradleProjectImporter", "createProjectFileForGradleProject"));
        }
        VirtualFile projectDir = selectedFile.isDirectory() ? selectedFile : selectedFile.getParent();
        File projectDirPath = VfsUtilCore.virtualToIoFile((VirtualFile)projectDir);
        try {
            this.importProject(projectDir.getName(), projectDirPath, true, new NewProjectImportGradleSyncListener(){

                @Override
                public void syncSucceeded(@NotNull Project project) {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleProjectImporter$1", "syncSucceeded"));
                    }
                    1.activateProjectView(project);
                }
            }, parentProject, null);
        }
        catch (Exception e) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new RuntimeException(e);
            }
            Messages.showErrorDialog((String)e.getMessage(), (String)"Project Import");
            LOG.error((Throwable)e);
        }
    }

    public void requestProjectSync(@NotNull Project project, @Nullable GradleSyncListener listener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleProjectImporter", "requestProjectSync"));
        }
        this.requestProjectSync(project, true, listener);
    }

    public void requestProjectSync(final @NotNull Project project, final boolean generateSourcesOnSuccess, final @Nullable GradleSyncListener listener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleProjectImporter", "requestProjectSync"));
        }
        Runnable syncRequest = new Runnable(){

            @Override
            public void run() {
                try {
                    GradleProjectImporter.this.doRequestSync(project, ProgressExecutionMode.IN_BACKGROUND_ASYNC, generateSourcesOnSuccess, listener);
                }
                catch (ConfigurationException e) {
                    Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)e.getTitle());
                }
            }
        };
        AppUIUtil.invokeLaterIfProjectAlive((Project)project, (Runnable)syncRequest);
    }

    public void syncProjectSynchronously(final @NotNull Project project, final boolean generateSourcesOnSuccess, final @Nullable GradleSyncListener listener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleProjectImporter", "syncProjectSynchronously"));
        }
        Runnable syncRequest = new Runnable(){

            @Override
            public void run() {
                try {
                    GradleProjectImporter.this.doRequestSync(project, ProgressExecutionMode.MODAL_SYNC, generateSourcesOnSuccess, listener);
                }
                catch (ConfigurationException e) {
                    Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)e.getTitle());
                }
            }
        };
        UIUtil.invokeAndWaitIfNeeded((Runnable)syncRequest);
    }

    private void doRequestSync(final @NotNull Project project, @NotNull ProgressExecutionMode progressExecutionMode, boolean generateSourcesOnSuccess, final @Nullable GradleSyncListener listener) throws ConfigurationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleProjectImporter", "doRequestSync"));
        }
        if (progressExecutionMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressExecutionMode", "com/android/tools/idea/gradle/project/GradleProjectImporter", "doRequestSync"));
        }
        if (Projects.isGradleProject(project) || GradleProjectImporter.hasTopLevelGradleBuildFile(project)) {
            FileDocumentManager.getInstance().saveAllDocuments();
            GradleProjectImporter.setUpGradleSettings(project);
            GradleProjectImporter.resetProject(project);
            this.doImport(project, false, progressExecutionMode, generateSourcesOnSuccess, listener);
        } else {
            Runnable notificationTask = new Runnable(){

                @Override
                public void run() {
                    String msg = String.format("The project '%s' is not a Gradle-based project", project.getName());
                    AndroidGradleNotification.getInstance(project).showBalloon("Project Sync", msg, NotificationType.ERROR, new OpenMigrationToGradleUrlHyperlink());
                    if (listener != null) {
                        listener.syncFailed(project, msg);
                    }
                }
            };
            Application application = ApplicationManager.getApplication();
            if (application.isDispatchThread()) {
                notificationTask.run();
            } else {
                application.invokeLater(notificationTask);
            }
        }
    }

    private static boolean hasTopLevelGradleBuildFile(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleProjectImporter", "hasTopLevelGradleBuildFile"));
        }
        VirtualFile baseDir = project.getBaseDir();
        VirtualFile gradleBuildFile = baseDir.findChild("build.gradle");
        return gradleBuildFile != null && gradleBuildFile.exists() && !gradleBuildFile.isDirectory();
    }

    private static void resetProject(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleProjectImporter", "resetProject"));
        }
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)true, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project){

            public void execute() {
                GradleSyncState.getInstance(project).runIdeProjectModificationAction(new Runnable(){

                    @Override
                    public void run() {
                        this.doExecute();
                    }
                });
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void doExecute() {
                LibraryTable libraryTable = ProjectLibraryTable.getInstance((Project)project);
                LibraryTable.ModifiableModel model = libraryTable.getModifiableModel();
                try {
                    for (Library library : model.getLibraries()) {
                        model.removeLibrary(library);
                    }
                }
                finally {
                    model.commit();
                }
                ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
                for (Module module : moduleManager.getModules()) {
                    AndroidFacet facet = AndroidFacet.getInstance(module);
                    if (facet == null) continue;
                    facet.setIdeaAndroidProject(null);
                }
            }
        });
    }

    public void importNewlyCreatedProject(@NotNull String projectName, @NotNull File projectRootDir, @Nullable GradleSyncListener listener, @Nullable Project project, @Nullable LanguageLevel initialLanguageLevel) throws IOException, ConfigurationException {
        if (projectName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectName", "com/android/tools/idea/gradle/project/GradleProjectImporter", "importNewlyCreatedProject"));
        }
        if (projectRootDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectRootDir", "com/android/tools/idea/gradle/project/GradleProjectImporter", "importNewlyCreatedProject"));
        }
        this.doImport(projectName, projectRootDir, true, listener, project, initialLanguageLevel);
    }

    public void importProject(@NotNull String projectName, @NotNull File projectRootDir, boolean generateSourcesOnSuccess, @Nullable GradleSyncListener listener, @Nullable Project project, @Nullable LanguageLevel initialLanguageLevel) throws IOException, ConfigurationException {
        if (projectName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectName", "com/android/tools/idea/gradle/project/GradleProjectImporter", "importProject"));
        }
        if (projectRootDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectRootDir", "com/android/tools/idea/gradle/project/GradleProjectImporter", "importProject"));
        }
        this.doImport(projectName, projectRootDir, generateSourcesOnSuccess, listener, project, initialLanguageLevel);
    }

    private void doImport(@NotNull String projectName, @NotNull File projectRootDir, boolean generateSourcesOnSuccess, @Nullable GradleSyncListener listener, @Nullable Project project, @Nullable LanguageLevel initialLanguageLevel) throws IOException, ConfigurationException {
        if (projectName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectName", "com/android/tools/idea/gradle/project/GradleProjectImporter", "doImport"));
        }
        if (projectRootDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectRootDir", "com/android/tools/idea/gradle/project/GradleProjectImporter", "doImport"));
        }
        GradleProjectImporter.createTopLevelBuildFileIfNotExisting(projectRootDir);
        GradleProjectImporter.createIdeaProjectDir(projectRootDir);
        Project newProject = project == null ? GradleProjectImporter.createProject(projectName, projectRootDir.getPath()) : project;
        GradleProjectImporter.setUpProject(newProject, initialLanguageLevel);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            newProject.save();
        }
        this.doImport(newProject, true, ProgressExecutionMode.MODAL_SYNC, generateSourcesOnSuccess, listener);
    }

    private static void createTopLevelBuildFileIfNotExisting(@NotNull File projectRootDir) throws IOException {
        if (projectRootDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectRootDir", "com/android/tools/idea/gradle/project/GradleProjectImporter", "createTopLevelBuildFileIfNotExisting"));
        }
        File projectFile = GradleUtil.getGradleBuildFilePath(projectRootDir);
        if (projectFile.isFile()) {
            return;
        }
        FileUtilRt.createIfNotExists((File)projectFile);
        String contents = "// Top-level build file where you can add configuration options common to all sub-projects/modules." + SystemProperties.getLineSeparator();
        FileUtil.writeToFile((File)projectFile, (String)contents);
    }

    private static void createIdeaProjectDir(@NotNull File projectRootDir) throws IOException {
        if (projectRootDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectRootDir", "com/android/tools/idea/gradle/project/GradleProjectImporter", "createIdeaProjectDir"));
        }
        File ideaDir = new File(projectRootDir, ".idea");
        if (ideaDir.isDirectory()) {
            boolean librariesDirDeleted;
            File librariesDir = new File(ideaDir, "libraries");
            if (librariesDir.exists() && !(librariesDirDeleted = FileUtil.delete((File)librariesDir))) {
                LOG.info(String.format("Failed to delete %1$s'", librariesDir.getPath()));
            }
        } else {
            FileUtil.ensureExists((File)ideaDir);
        }
    }

    @NotNull
    private static Project createProject(@NotNull String projectName, @NotNull String projectPath) throws ConfigurationException {
        if (projectName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectName", "com/android/tools/idea/gradle/project/GradleProjectImporter", "createProject"));
        }
        if (projectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectPath", "com/android/tools/idea/gradle/project/GradleProjectImporter", "createProject"));
        }
        ProjectManager projectManager = ProjectManager.getInstance();
        Project newProject = projectManager.createProject(projectName, projectPath);
        if (newProject == null) {
            throw new NullPointerException("Failed to create a new IDEA project");
        }
        Project project = newProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/GradleProjectImporter", "createProject"));
        }
        return project;
    }

    private static void setUpProject(final @NotNull Project newProject, final @Nullable LanguageLevel initialLanguageLevel) {
        if (newProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newProject", "com/android/tools/idea/gradle/project/GradleProjectImporter", "setUpProject"));
        }
        CommandProcessor.getInstance().executeCommand(newProject, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        LanguageLevelProjectExtension extension;
                        if (initialLanguageLevel != null && (extension = LanguageLevelProjectExtension.getInstance((Project)newProject)) != null) {
                            extension.setLanguageLevel(initialLanguageLevel);
                        }
                        File compilerOutputDir = new File(newProject.getBasePath(), FileUtil.join((String[])new String[]{"build", "classes"}));
                        String compilerOutputDirUrl = FilePaths.pathToIdeaUrl(compilerOutputDir);
                        CompilerProjectExtension compilerProjectExt = CompilerProjectExtension.getInstance((Project)newProject);
                        assert (compilerProjectExt != null);
                        compilerProjectExt.setCompilerOutputUrl(compilerOutputDirUrl);
                        GradleProjectImporter.setUpGradleSettings(newProject);
                    }
                });
            }
        }, null, null);
    }

    private static void setUpGradleSettings(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleProjectImporter", "setUpGradleSettings"));
        }
        GradleProjectSettings projectSettings = GradleUtil.getGradleProjectSettings(project);
        if (projectSettings == null) {
            projectSettings = new GradleProjectSettings();
        }
        projectSettings.setUseAutoImport(false);
        GradleProjectImporter.setUpGradleProjectSettings(project, projectSettings);
        GradleSettings gradleSettings = GradleSettings.getInstance((Project)project);
        gradleSettings.setLinkedProjectsSettings((Collection)ImmutableList.of((Object)projectSettings));
    }

    private static void setUpGradleProjectSettings(@NotNull Project project, @NotNull GradleProjectSettings settings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleProjectImporter", "setUpGradleProjectSettings"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/android/tools/idea/gradle/project/GradleProjectImporter", "setUpGradleProjectSettings"));
        }
        settings.setExternalProjectPath(FileUtil.toCanonicalPath((String)project.getBasePath()));
    }

    private void doImport(@NotNull Project project, boolean newProject, @NotNull ProgressExecutionMode progressExecutionMode, boolean generateSourcesOnSuccess, @Nullable GradleSyncListener listener) throws ConfigurationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleProjectImporter", "doImport"));
        }
        if (progressExecutionMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressExecutionMode", "com/android/tools/idea/gradle/project/GradleProjectImporter", "doImport"));
        }
        if (!PreSyncChecks.canSync(project)) {
            GradleSyncState syncState = GradleSyncState.getInstance(project);
            syncState.syncStarted(true);
            NewProjectImportGradleSyncListener.createTopLevelProjectAndOpen(project);
            syncState.syncFailed("Issues with settings.gradle file (e.g. empty file)");
            return;
        }
        if (AndroidStudioSpecificInitializer.isAndroidStudio() && Projects.isDirectGradleInvocationEnabled(project)) {
            GradleInvoker.getInstance(project).clearConsoleAndBuildMessages();
        }
        project.putUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT, (Object)true);
        project.putUserData(Projects.HAS_UNRESOLVED_DEPENDENCIES, (Object)false);
        project.putUserData(Projects.HAS_WRONG_JDK, (Object)false);
        PostProjectSetupTasksExecutor.getInstance(project).setGenerateSourcesAfterSync(generateSourcesOnSuccess);
        GradleSyncState.getInstance(project).syncStarted(!newProject);
        this.myDelegate.importProject(project, new ProjectSetUpTask(project, newProject, listener), progressExecutionMode);
    }

    static class ImporterDelegate {
        ImporterDelegate() {
        }

        void importProject(@NotNull Project project, @NotNull ExternalProjectRefreshCallback callback, @NotNull ProgressExecutionMode progressExecutionMode) throws ConfigurationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleProjectImporter$ImporterDelegate", "importProject"));
            }
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/android/tools/idea/gradle/project/GradleProjectImporter$ImporterDelegate", "importProject"));
            }
            if (progressExecutionMode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressExecutionMode", "com/android/tools/idea/gradle/project/GradleProjectImporter$ImporterDelegate", "importProject"));
            }
            try {
                String externalProjectPath = FileUtil.toCanonicalPath((String)project.getBasePath());
                ExternalSystemUtil.refreshProject((Project)project, (ProjectSystemId)SYSTEM_ID, (String)externalProjectPath, (ExternalProjectRefreshCallback)callback, (boolean)false, (ProgressExecutionMode)progressExecutionMode, (boolean)true);
            }
            catch (RuntimeException e) {
                String externalSystemName = SYSTEM_ID.getReadableName();
                throw new ConfigurationException(e.getMessage(), ExternalSystemBundle.message((String)"error.cannot.parse.project", (Object[])new Object[]{externalSystemName}));
            }
        }
    }
}

