/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.gradle.structure.AndroidProjectStructureConfigurable;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.startup.AndroidStudioSpecificInitializer;
import com.intellij.compiler.actions.ArtifactAwareProjectSettingsService;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.IdeaProjectSettingsService;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.packaging.artifacts.Artifact;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidProjectSettingsService
extends ProjectSettingsService
implements ArtifactAwareProjectSettingsService {
    private final Project myProject;
    private final IdeaProjectSettingsService myDelegate;

    public AndroidProjectSettingsService(Project project) {
        this.myProject = project;
        this.myDelegate = new IdeaProjectSettingsService(project);
    }

    public void openProjectSettings() {
        this.myDelegate.openProjectSettings();
    }

    public void openGlobalLibraries() {
        if (!this.isGradleProjectInAndroidStudio()) {
            this.myDelegate.openGlobalLibraries();
        }
    }

    public void openLibrary(@NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/android/tools/idea/gradle/structure/AndroidProjectSettingsService", "openLibrary"));
        }
        if (!this.isGradleProjectInAndroidStudio()) {
            this.myDelegate.openLibrary(library);
        }
    }

    public boolean canOpenModuleSettings() {
        if (this.isGradleProjectInAndroidStudio()) {
            return true;
        }
        return this.myDelegate.canOpenModuleSettings();
    }

    public void openModuleLibrarySettings(Module module) {
        if (this.isGradleProjectInAndroidStudio()) {
            this.openModuleSettings(module);
        } else {
            this.myDelegate.openModuleLibrarySettings(module);
        }
    }

    public void openModuleSettings(Module module) {
        if (this.isGradleProjectInAndroidStudio()) {
            AndroidProjectStructureConfigurable.getInstance(this.myProject).showDialogAndSelect(module);
        } else {
            this.myDelegate.openModuleSettings(module);
        }
    }

    public void openSdkSettings() {
        AndroidProjectStructureConfigurable configurable = AndroidProjectStructureConfigurable.getInstance(this.myProject);
        configurable.showDialogAndSelectSdksPage();
    }

    public void openAndSelectDependency(@NotNull Module module, @NotNull GradleCoordinate dependency) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/structure/AndroidProjectSettingsService", "openAndSelectDependency"));
        }
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/structure/AndroidProjectSettingsService", "openAndSelectDependency"));
        }
        AndroidProjectStructureConfigurable configurable = AndroidProjectStructureConfigurable.getInstance(this.myProject);
        configurable.showDialogAndSelectDependency(module, dependency);
    }

    public boolean canOpenModuleLibrarySettings() {
        if (this.isGradleProjectInAndroidStudio()) {
            return false;
        }
        return this.myDelegate.canOpenModuleLibrarySettings();
    }

    public boolean canOpenContentEntriesSettings() {
        if (this.isGradleProjectInAndroidStudio()) {
            return false;
        }
        return this.myDelegate.canOpenContentEntriesSettings();
    }

    public void openContentEntriesSettings(Module module) {
        if (this.isGradleProjectInAndroidStudio()) {
            this.openModuleSettings(module);
        } else {
            this.myDelegate.openContentEntriesSettings(module);
        }
    }

    public boolean canOpenModuleDependenciesSettings() {
        if (this.isGradleProjectInAndroidStudio()) {
            return false;
        }
        return this.myDelegate.canOpenModuleDependenciesSettings();
    }

    public void openModuleDependenciesSettings(@NotNull Module module, @Nullable OrderEntry orderEntry) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/structure/AndroidProjectSettingsService", "openModuleDependenciesSettings"));
        }
        if (this.isGradleProjectInAndroidStudio()) {
            this.openModuleSettings(module);
        } else {
            this.myDelegate.openModuleDependenciesSettings(module, orderEntry);
        }
    }

    public boolean canOpenLibraryOrSdkSettings(OrderEntry orderEntry) {
        if (this.isGradleProjectInAndroidStudio()) {
            return false;
        }
        return this.myDelegate.canOpenLibraryOrSdkSettings(orderEntry);
    }

    public void openLibraryOrSdkSettings(@NotNull OrderEntry orderEntry) {
        if (orderEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orderEntry", "com/android/tools/idea/gradle/structure/AndroidProjectSettingsService", "openLibraryOrSdkSettings"));
        }
        if (!this.isGradleProjectInAndroidStudio()) {
            this.myDelegate.openLibraryOrSdkSettings(orderEntry);
        }
    }

    public boolean processModulesMoved(Module[] modules, @Nullable ModuleGroup targetGroup) {
        if (this.isGradleProjectInAndroidStudio()) {
            return false;
        }
        return this.myDelegate.processModulesMoved(modules, targetGroup);
    }

    public void showModuleConfigurationDialog(String moduleToSelect, String editorNameToSelect) {
        if (this.isGradleProjectInAndroidStudio()) {
            Module module = ModuleManager.getInstance((Project)this.myProject).findModuleByName(moduleToSelect);
            assert (module != null);
            AndroidProjectStructureConfigurable.getInstance(this.myProject).showDialogAndSelect(module);
        } else {
            this.myDelegate.showModuleConfigurationDialog(moduleToSelect, editorNameToSelect);
        }
    }

    public Sdk chooseAndSetSdk() {
        return this.myDelegate.chooseAndSetSdk();
    }

    public void openArtifactSettings(@Nullable Artifact artifact) {
        if (!this.isGradleProjectInAndroidStudio()) {
            this.myDelegate.openArtifactSettings(artifact);
        }
    }

    private boolean isGradleProjectInAndroidStudio() {
        return AndroidStudioSpecificInitializer.isAndroidStudio() && Projects.isGradleProject(this.myProject);
    }
}

