/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.stats;

import com.android.annotations.NonNull;
import com.android.tools.idea.stats.BuildRecord;
import com.android.tools.idea.stats.Counter;
import com.android.tools.idea.stats.KeyString;
import com.android.tools.idea.stats.LegacySdkStatsService;
import com.android.tools.idea.stats.OsInfo;
import com.android.tools.idea.stats.StatsProto;
import com.android.tools.idea.stats.StudioBuildStatsPersistenceComponent;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.UsagesCollector;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.connect.StatisticsConnectionService;
import com.intellij.internal.statistic.connect.StatisticsResult;
import com.intellij.internal.statistic.connect.StatisticsService;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.util.net.HttpConfigurable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidStatisticsService
implements StatisticsService {
    private static final Logger LOG = Logger.getInstance((String)("#" + AndroidStatisticsService.class.getName()));
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String HTTP_POST = "POST";
    private static final int HTTP_STATUS_OK = 200;
    private static final String PROTOBUF_CONTENT = "application/x-protobuf";

    @NonNull
    public Notification createNotification(@NotNull String groupDisplayId, @Nullable NotificationListener listener) {
        if (groupDisplayId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupDisplayId", "com/android/tools/idea/stats/AndroidStatisticsService", "createNotification"));
        }
        String fullProductName = ApplicationNamesInfo.getInstance().getFullProductName();
        String companyName = ApplicationInfo.getInstance().getCompanyName();
        String text = "<html>Please click <a href='allow'>I agree</a> if you want to help make " + fullProductName + " better or <a href='decline'>I don't agree</a> otherwise. <a href='settings'>more...</a></html>";
        String title = "Help improve " + fullProductName + " by sending usage statistics to " + companyName;
        return new Notification(groupDisplayId, title, text, NotificationType.INFORMATION, listener);
    }

    @Nullable
    public Map<String, String> getStatisticsConfigurationLabels() {
        HashMap<String, String> labels = new HashMap<String, String>();
        String fullProductName = ApplicationNamesInfo.getInstance().getFullProductName();
        String companyName = ApplicationInfo.getInstance().getCompanyName();
        labels.put("title", "Help improve " + fullProductName + " by sending usage statistics to " + companyName);
        labels.put("allow-checkbox", "Send usage statistics to " + companyName);
        labels.put("details", "<html>This allows " + companyName + " to collect information about your plugins configuration (what is enabled and what is not)" + "<br/>and feature usage statistics (e.g. how frequently you're using code completion)." + "<br/>This data is collected in accordance with " + companyName + "'s privacy policy.</html>");
        return labels;
    }

    public StatisticsResult send() {
        LegacySdkStatsService sdkstats = this.sendLegacyPing();
        StatisticsResult result = this.sendUsageStats(sdkstats);
        result = this.sendBuildStats(sdkstats);
        return result;
    }

    static StatisticsResult areStatisticsAuthorized() {
        StatisticsConnectionService service = new StatisticsConnectionService();
        String serviceUrl = service.getServiceUrl();
        if (serviceUrl == null) {
            return new StatisticsResult(StatisticsResult.ResultCode.ERROR_IN_CONFIG, "ERROR");
        }
        if (!service.isTransmissionPermitted().booleanValue()) {
            return new StatisticsResult(StatisticsResult.ResultCode.NOT_PERMITTED_SERVER, "NOT_PERMITTED");
        }
        return new StatisticsResult(StatisticsResult.ResultCode.SEND, "OK");
    }

    private StatisticsResult sendBuildStats(LegacySdkStatsService sdkstats) {
        StatisticsResult code = AndroidStatisticsService.areStatisticsAuthorized();
        if (code.getCode() != StatisticsResult.ResultCode.SEND) {
            return code;
        }
        StudioBuildStatsPersistenceComponent records = StudioBuildStatsPersistenceComponent.getInstance();
        if (records == null || !records.hasRecords()) {
            return new StatisticsResult(StatisticsResult.ResultCode.NOTHING_TO_SEND, "NOTHING_TO_SEND");
        }
        StatsProto.LogRequest data = this.getRecordData(sdkstats, records);
        String error = null;
        try {
            error = this.sendData(data);
        }
        catch (Exception e) {
            error = e.getClass().getSimpleName() + " " + (e.getMessage() != null ? e.getMessage() : e.toString());
        }
        if (error != null) {
            LOG.debug("[SendStats/AS-2] Error " + (error == null ? "None" : error));
        }
        if (error == null) {
            return new StatisticsResult(StatisticsResult.ResultCode.SEND, "OK");
        }
        return new StatisticsResult(StatisticsResult.ResultCode.SENT_WITH_ERRORS, error);
    }

    @Deprecated
    private StatisticsResult sendUsageStats(LegacySdkStatsService sdkstats) {
        StatisticsResult code = AndroidStatisticsService.areStatisticsAuthorized();
        if (code.getCode() != StatisticsResult.ResultCode.SEND) {
            return code;
        }
        StatisticsConnectionService service = new StatisticsConnectionService();
        StatsProto.LogRequest data = this.getUsageData(sdkstats, service.getDisabledGroups());
        String error = null;
        try {
            error = this.sendData(data);
        }
        catch (Exception e) {
            error = e.getClass().getSimpleName() + " " + (e.getMessage() != null ? e.getMessage() : e.toString());
        }
        if (error != null) {
            LOG.debug("[SendStats/AS-1] Error " + (error == null ? "None" : error));
        }
        if (error == null) {
            return new StatisticsResult(StatisticsResult.ResultCode.SEND, "OK");
        }
        return new StatisticsResult(StatisticsResult.ResultCode.SENT_WITH_ERRORS, error);
    }

    private LegacySdkStatsService sendLegacyPing() {
        LegacySdkStatsService sdkstats = new LegacySdkStatsService();
        sdkstats.ping("studio", ApplicationInfo.getInstance().getFullVersion());
        return sdkstats;
    }

    private StatsProto.LogRequest getRecordData(@NotNull LegacySdkStatsService sdkstats, @NotNull StudioBuildStatsPersistenceComponent records) {
        BuildRecord record;
        if (sdkstats == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkstats", "com/android/tools/idea/stats/AndroidStatisticsService", "getRecordData"));
        }
        if (records == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "records", "com/android/tools/idea/stats/AndroidStatisticsService", "getRecordData"));
        }
        StatsProto.LogRequest.Builder request = StatsProto.LogRequest.newBuilder();
        request.setLogSource(StatsProto.LogRequest.LogSource.ANDROID_STUDIO);
        request.setRequestTimeMs(System.currentTimeMillis());
        String uuid = UpdateChecker.getInstallationUID((PropertiesComponent)PropertiesComponent.getInstance());
        String appVersion = ApplicationInfo.getInstance().getFullVersion();
        request.setClientInfo(this.createClientInfo(sdkstats, uuid, appVersion));
        while (records.hasRecords() && (record = records.getFirstRecord()) != null) {
            StatsProto.LogEvent.Builder evtBuilder = StatsProto.LogEvent.newBuilder();
            evtBuilder.setEventTimeMs(record.getUtcTimestampMs());
            evtBuilder.setTag("build");
            for (KeyString value : record.getData()) {
                StatsProto.LogEventKeyValues.Builder kvBuilder = StatsProto.LogEventKeyValues.newBuilder();
                kvBuilder.setKey(value.getKey());
                kvBuilder.setValue(value.getValue());
                evtBuilder.addValue(kvBuilder);
            }
            request.addLogEvent(evtBuilder.build());
        }
        return request.build();
    }

    private StatsProto.LogRequest getUsageData(@NotNull LegacySdkStatsService sdkstats, @NotNull Set<String> disabledGroups) {
        if (sdkstats == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkstats", "com/android/tools/idea/stats/AndroidStatisticsService", "getUsageData"));
        }
        if (disabledGroups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disabledGroups", "com/android/tools/idea/stats/AndroidStatisticsService", "getUsageData"));
        }
        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        LinkedHashMap<String, KeyString[]> usages = new LinkedHashMap<String, KeyString[]>();
        for (Project project : openProjects) {
            Map<String, KeyString[]> allUsages = this.getAllUsages(project, disabledGroups);
            usages.putAll(allUsages);
        }
        String uuid = UpdateChecker.getInstallationUID((PropertiesComponent)PropertiesComponent.getInstance());
        String appVersion = ApplicationInfo.getInstance().getFullVersion();
        return this.createRequest(sdkstats, uuid, appVersion, usages);
    }

    @NotNull
    public Map<String, KeyString[]> getAllUsages(@Nullable Project project, @NotNull Set<String> disabledGroups) {
        if (disabledGroups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disabledGroups", "com/android/tools/idea/stats/AndroidStatisticsService", "getAllUsages"));
        }
        LinkedHashMap<String, KeyString[]> allUsages = new LinkedHashMap<String, KeyString[]>();
        for (UsagesCollector usagesCollector : (UsagesCollector[])Extensions.getExtensions((ExtensionPointName)UsagesCollector.EP_NAME)) {
            GroupDescriptor groupDescriptor = usagesCollector.getGroupId();
            String groupId = groupDescriptor.getId();
            if (disabledGroups.contains(groupId)) continue;
            try {
                Set usages = usagesCollector.getUsages(project);
                TreeSet<Counter> counters = new TreeSet<Counter>();
                for (UsageDescriptor usage : usages) {
                    Counter counter = new Counter(usage.getKey(), usage.getValue());
                    counters.add(counter);
                }
                allUsages.put(groupId, counters.toArray(new Counter[counters.size()]));
            }
            catch (CollectUsagesException e) {
                LOG.info((Throwable)e);
            }
        }
        LinkedHashMap<String, KeyString[]> linkedHashMap = allUsages;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/stats/AndroidStatisticsService", "getAllUsages"));
        }
        return linkedHashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String sendData(@NotNull StatsProto.LogRequest request) throws IOException {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/android/tools/idea/stats/AndroidStatisticsService", "sendData"));
        }
        if (request == null) {
            return "[SendStats] Invalid arguments";
        }
        String url = "https://play.google.com/log";
        byte[] data = request.toByteArray();
        HttpURLConnection connection = HttpConfigurable.getInstance().openHttpConnection(url);
        connection.setConnectTimeout(2000);
        connection.setReadTimeout(2000);
        connection.setDoOutput(true);
        connection.setRequestMethod(HTTP_POST);
        connection.setRequestProperty(CONTENT_TYPE, PROTOBUF_CONTENT);
        OutputStream os = connection.getOutputStream();
        try {
            os.write(data);
        }
        finally {
            os.close();
        }
        int code = connection.getResponseCode();
        if (code == 200) {
            return null;
        }
        return "[SendStats] Error " + code;
    }

    public StatsProto.LogRequest createRequest(@NotNull LegacySdkStatsService sdkstats, @NotNull String uuid, @NotNull String appVersion, @NotNull Map<String, KeyString[]> usages) {
        if (sdkstats == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkstats", "com/android/tools/idea/stats/AndroidStatisticsService", "createRequest"));
        }
        if (uuid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uuid", "com/android/tools/idea/stats/AndroidStatisticsService", "createRequest"));
        }
        if (appVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appVersion", "com/android/tools/idea/stats/AndroidStatisticsService", "createRequest"));
        }
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/android/tools/idea/stats/AndroidStatisticsService", "createRequest"));
        }
        StatsProto.LogRequest.Builder request = StatsProto.LogRequest.newBuilder();
        request.setLogSource(StatsProto.LogRequest.LogSource.ANDROID_STUDIO);
        request.setRequestTimeMs(System.currentTimeMillis());
        request.setClientInfo(this.createClientInfo(sdkstats, uuid, appVersion));
        for (Map.Entry<String, KeyString[]> entry : usages.entrySet()) {
            request.addLogEvent(this.createEvent(entry.getKey(), entry.getValue()));
        }
        request.addLogEvent(this.createEvent("jvm", new KeyString[]{new KeyString("jvm-info", sdkstats.getJvmInfo()), new KeyString("jvm-vers", sdkstats.getJvmVersion()), new KeyString("jvm-arch", sdkstats.getJvmArch())}));
        return request.build();
    }

    private StatsProto.LogEvent createEvent(@NotNull String groupId, @NotNull KeyString[] values) {
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "com/android/tools/idea/stats/AndroidStatisticsService", "createEvent"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/android/tools/idea/stats/AndroidStatisticsService", "createEvent"));
        }
        StatsProto.LogEvent.Builder evtBuilder = StatsProto.LogEvent.newBuilder();
        evtBuilder.setEventTimeMs(System.currentTimeMillis());
        evtBuilder.setTag(groupId);
        for (KeyString value : values) {
            StatsProto.LogEventKeyValues.Builder kvBuilder = StatsProto.LogEventKeyValues.newBuilder();
            kvBuilder.setKey(value.getKey());
            kvBuilder.setValue(value.getValue());
            evtBuilder.addValue(kvBuilder);
        }
        return evtBuilder.build();
    }

    private StatsProto.ClientInfo createClientInfo(@NotNull LegacySdkStatsService sdkstats, @NotNull String uuid, @NotNull String appVersion) {
        if (sdkstats == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkstats", "com/android/tools/idea/stats/AndroidStatisticsService", "createClientInfo"));
        }
        if (uuid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uuid", "com/android/tools/idea/stats/AndroidStatisticsService", "createClientInfo"));
        }
        if (appVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appVersion", "com/android/tools/idea/stats/AndroidStatisticsService", "createClientInfo"));
        }
        StatsProto.DesktopClientInfo.Builder desktop = StatsProto.DesktopClientInfo.newBuilder();
        desktop.setClientId(uuid);
        OsInfo info = sdkstats.getOsName();
        desktop.setOs(info.getOsName());
        String os_vers = info.getOsVersion();
        if (os_vers != null) {
            desktop.setOsMajorVersion(os_vers);
        }
        desktop.setOsFullVersion(info.getOsFull());
        desktop.setApplicationBuild(appVersion);
        StatsProto.ClientInfo.Builder cinfo = StatsProto.ClientInfo.newBuilder();
        cinfo.setClientType(StatsProto.ClientInfo.ClientType.DESKTOP);
        cinfo.setDesktopClientInfo(desktop);
        return cinfo.build();
    }
}

