/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.run;

import com.android.ddmlib.IDevice;
import com.intellij.debugger.engine.RemoteDebugProcessHandler;
import com.intellij.debugger.ui.DebuggerPanelsManager;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RemoteState;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.DefaultProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiClass;
import com.intellij.ui.content.Content;
import com.intellij.xdebugger.DefaultDebugProcessHandler;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.android.dom.manifest.Instrumentation;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.logcat.AndroidToolWindowFactory;
import org.jetbrains.android.run.AndroidExecutionState;
import org.jetbrains.android.run.AndroidProcessText;
import org.jetbrains.android.run.AndroidRunConfigurationBase;
import org.jetbrains.android.run.AndroidRunningState;
import org.jetbrains.android.run.AndroidRunningStateListener;
import org.jetbrains.android.run.AndroidSessionInfo;
import org.jetbrains.android.run.DebugLauncher;
import org.jetbrains.android.run.LogcatExecutionConsole;
import org.jetbrains.android.run.testing.AndroidTestRunConfiguration;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidDebugRunner
extends DefaultProgramRunner {
    public static final Key<AndroidSessionInfo> ANDROID_SESSION_INFO = new Key("ANDROID_SESSION_INFO");
    private static final Object myDebugLock = new Object();
    public static final String ANDROID_LOGCAT_CONTENT_ID = "Android Logcat";
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.run.AndroidDebugRunner");
    private static NotificationGroup ourNotificationGroup;

    private static void tryToCloseOldSessions(final Executor executor, Project project) {
        ProcessHandler[] processes;
        final ExecutionManager manager = ExecutionManager.getInstance((Project)project);
        for (ProcessHandler process : processes = manager.getRunningProcesses()) {
            final AndroidSessionInfo info = (AndroidSessionInfo)process.getUserData(ANDROID_SESSION_INFO);
            if (info == null) continue;
            process.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(ProcessEvent event) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            manager.getContentManager().removeRunContent(executor, info.getDescriptor());
                        }
                    });
                }
            });
            process.detachProcess();
        }
    }

    protected RunContentDescriptor doExecute(@NotNull RunProfileState state, final @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/android/run/AndroidDebugRunner", "doExecute"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/android/run/AndroidDebugRunner", "doExecute"));
        }
        assert (state instanceof AndroidRunningState);
        AndroidRunningState runningState = (AndroidRunningState)state;
        final RunContentDescriptor[] descriptor = new RunContentDescriptor[]{null};
        runningState.addListener(new AndroidRunningStateListener(){

            @Override
            public void executionFailed() {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (descriptor[0] != null) {
                            AndroidDebugRunner.showNotification(environment.getProject(), environment.getExecutor(), descriptor[0], "error", false, NotificationType.ERROR);
                        }
                    }
                });
            }
        });
        descriptor[0] = this.doExec(runningState, environment);
        return descriptor[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RunContentDescriptor doExec(AndroidRunningState state, ExecutionEnvironment environment) throws ExecutionException {
        RunContentDescriptor runDescriptor;
        if (DefaultRunExecutor.EXECUTOR_ID.equals(environment.getExecutor().getId())) {
            RunContentDescriptor descriptor = super.doExecute((RunProfileState)state, environment);
            if (descriptor != null) {
                AndroidDebugRunner.setActivateToolWindowWhenAddedProperty(environment.getProject(), environment.getExecutor(), descriptor, "running");
            }
            return descriptor;
        }
        RunProfile runProfile = environment.getRunProfile();
        if (runProfile instanceof AndroidTestRunConfiguration && !state.getFacet().isGradleProject()) {
            String targetPackage = AndroidDebugRunner.getTargetPackage((AndroidTestRunConfiguration)runProfile, state);
            if (targetPackage == null) {
                throw new ExecutionException(AndroidBundle.message("target.package.not.specified.error", new Object[0]));
            }
            state.setTargetPackageName(targetPackage);
        }
        state.setDebugMode(true);
        Object object = myDebugLock;
        synchronized (object) {
            MyDebugLauncher launcher = new MyDebugLauncher(state, environment);
            state.setDebugLauncher(launcher);
            RunContentDescriptor descriptor = AndroidDebugRunner.embedToExistingSession(environment.getProject(), environment.getExecutor(), state);
            runDescriptor = descriptor != null ? descriptor : super.doExecute((RunProfileState)state, environment);
            launcher.setRunDescriptor(runDescriptor);
            if (descriptor != null) {
                return null;
            }
        }
        if (runDescriptor == null) {
            return null;
        }
        AndroidDebugRunner.tryToCloseOldSessions(environment.getExecutor(), environment.getProject());
        ProcessHandler handler = state.getProcessHandler();
        handler.putUserData(ANDROID_SESSION_INFO, (Object)new AndroidSessionInfo(runDescriptor, state, environment.getExecutor().getId()));
        AndroidDebugRunner.setActivateToolWindowWhenAddedProperty(environment.getProject(), environment.getExecutor(), runDescriptor, "running");
        return runDescriptor;
    }

    private static void setActivateToolWindowWhenAddedProperty(Project project, Executor executor, RunContentDescriptor descriptor, String status) {
        boolean activateToolWindow = AndroidDebugRunner.shouldActivateExecWindow(project);
        descriptor.setActivateToolWindowWhenAdded(activateToolWindow);
        if (!activateToolWindow) {
            AndroidDebugRunner.showNotification(project, executor, descriptor, status, false, NotificationType.INFORMATION);
        }
    }

    private static boolean shouldActivateExecWindow(Project project) {
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(AndroidToolWindowFactory.TOOL_WINDOW_ID);
        return toolWindow == null || !toolWindow.isVisible();
    }

    @Nullable
    private static Pair<ProcessHandler, AndroidSessionInfo> findOldSession(Project project, Executor executor, AndroidRunConfigurationBase configuration) {
        for (ProcessHandler handler : ExecutionManager.getInstance((Project)project).getRunningProcesses()) {
            AndroidSessionInfo info = (AndroidSessionInfo)handler.getUserData(ANDROID_SESSION_INFO);
            if (info == null || !info.getState().getConfiguration().equals((Object)configuration) || !executor.getId().equals(info.getExecutorId())) continue;
            return Pair.create((Object)handler, (Object)info);
        }
        return null;
    }

    @Nullable
    protected static RunContentDescriptor embedToExistingSession(final Project project, final Executor executor, final AndroidRunningState state) {
        ProcessHandler newProcessHandler;
        ProcessHandler oldProcessHandler;
        Pair<ProcessHandler, AndroidSessionInfo> pair = AndroidDebugRunner.findOldSession(project, executor, state.getConfiguration());
        AndroidSessionInfo oldSessionInfo = pair != null ? (AndroidSessionInfo)pair.getSecond() : null;
        ProcessHandler processHandler = oldProcessHandler = pair != null ? (ProcessHandler)pair.getFirst() : null;
        if (oldSessionInfo == null || oldProcessHandler == null) {
            return null;
        }
        AndroidExecutionState oldState = oldSessionInfo.getState();
        IDevice[] oldDevices = oldState.getDevices();
        ConsoleView oldConsole = oldState.getConsoleView();
        if (oldDevices == null || oldConsole == null || oldDevices.length == 0 || oldDevices.length > 1) {
            return null;
        }
        final Ref devicesRef = Ref.create();
        boolean result = ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                devicesRef.set(state.getAllCompatibleDevices());
            }
        }, "Scanning available devices", false, project);
        if (!result) {
            return null;
        }
        List devices = (List)devicesRef.get();
        if (devices.size() == 0 || devices.size() > 1 || devices.get(0) != oldDevices[0]) {
            return null;
        }
        oldProcessHandler.detachProcess();
        state.setTargetDevices(devices.toArray(new IDevice[devices.size()]));
        state.setConsole(oldConsole);
        final RunContentDescriptor oldDescriptor = oldSessionInfo.getDescriptor();
        if (oldDescriptor.getProcessHandler() instanceof RemoteDebugProcessHandler) {
            newProcessHandler = oldDescriptor.getProcessHandler();
            newProcessHandler.destroyProcess();
        } else {
            newProcessHandler = new DefaultDebugProcessHandler();
        }
        oldDescriptor.setProcessHandler(newProcessHandler);
        state.setProcessHandler(newProcessHandler);
        oldConsole.attachToProcess(newProcessHandler);
        AndroidProcessText.attach(newProcessHandler);
        newProcessHandler.notifyTextAvailable("The session was restarted\n", ProcessOutputTypes.STDOUT);
        AndroidDebugRunner.showNotification(project, executor, oldDescriptor, "running", false, NotificationType.INFORMATION);
        state.addListener(new AndroidRunningStateListener(){

            @Override
            public void executionFailed() {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AndroidDebugRunner.showNotification(project, executor, oldDescriptor, "error", false, NotificationType.ERROR);
                    }
                });
            }
        });
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                state.start(false);
            }
        });
        return oldDescriptor;
    }

    private static void showNotification(final Project project, final Executor executor, final RunContentDescriptor descriptor, final String status, final boolean notifySelectedContent, final NotificationType type) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                String notificationMessage;
                if (project.isDisposed()) {
                    return;
                }
                final String sessionName = descriptor.getDisplayName();
                final ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(executor.getToolWindowId());
                Content content = descriptor.getAttachedContent();
                if (content != null && content.isSelected() && toolWindow.isVisible()) {
                    if (!notifySelectedContent) {
                        return;
                    }
                    notificationMessage = "Session '" + sessionName + "': " + status;
                } else {
                    notificationMessage = "Session <a href=''>'" + sessionName + "'</a>: " + status;
                }
                if (ourNotificationGroup == null) {
                    ourNotificationGroup = NotificationGroup.toolWindowGroup((String)"Android Session Restarted", (String)executor.getToolWindowId(), (boolean)true);
                }
                ourNotificationGroup.createNotification("", notificationMessage, type, new NotificationListener(){

                    public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                        if (notification == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "org/jetbrains/android/run/AndroidDebugRunner$6$1", "hyperlinkUpdate"));
                        }
                        if (event == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/android/run/AndroidDebugRunner$6$1", "hyperlinkUpdate"));
                        }
                        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                            RunContentManager contentManager = ExecutionManager.getInstance((Project)project).getContentManager();
                            for (RunContentDescriptor d : contentManager.getAllDescriptors()) {
                                if (!sessionName.equals(d.getDisplayName())) continue;
                                Content content = d.getAttachedContent();
                                content.getManager().setSelectedContent(content);
                                toolWindow.activate(null, true, true);
                                break;
                            }
                        }
                    }
                }).notify(project);
            }
        });
    }

    @Nullable
    private static String getTargetPackage(AndroidTestRunConfiguration configuration, AndroidRunningState state) {
        Manifest manifest = state.getFacet().getManifest();
        assert (manifest != null);
        for (Instrumentation instrumentation : manifest.getInstrumentations()) {
            String targetPackage;
            PsiClass c = (PsiClass)instrumentation.getInstrumentationClass().getValue();
            String runner = configuration.INSTRUMENTATION_RUNNER_CLASS;
            if (c == null || runner.length() != 0 && !runner.equals(c.getQualifiedName()) || (targetPackage = (String)instrumentation.getTargetPackage().getValue()) == null) continue;
            return targetPackage;
        }
        return null;
    }

    @NotNull
    public String getRunnerId() {
        if ("AndroidDebugRunner" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/AndroidDebugRunner", "getRunnerId"));
        }
        return "AndroidDebugRunner";
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "org/jetbrains/android/run/AndroidDebugRunner", "canRun"));
        }
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "org/jetbrains/android/run/AndroidDebugRunner", "canRun"));
        }
        return (DefaultDebugExecutor.EXECUTOR_ID.equals(executorId) || DefaultRunExecutor.EXECUTOR_ID.equals(executorId)) && profile instanceof AndroidRunConfigurationBase;
    }

    private class MyDebugLauncher
    implements DebugLauncher {
        private final Project myProject;
        private final Executor myExecutor;
        private final AndroidRunningState myRunningState;
        private final ExecutionEnvironment myEnvironment;
        private RunContentDescriptor myRunDescriptor;

        public MyDebugLauncher(AndroidRunningState state, ExecutionEnvironment environment) {
            this.myProject = environment.getProject();
            this.myRunningState = state;
            this.myEnvironment = environment;
            this.myExecutor = environment.getExecutor();
        }

        public void setRunDescriptor(RunContentDescriptor runDescriptor) {
            this.myRunDescriptor = runDescriptor;
        }

        @Override
        public void launchDebug(final IDevice device, final String debugPort) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ProcessHandler newProcessHandler;
                    DebuggerPanelsManager manager = DebuggerPanelsManager.getInstance((Project)MyDebugLauncher.this.myProject);
                    AndroidDebugState st = new AndroidDebugState(MyDebugLauncher.this.myProject, new RemoteConnection(true, "localhost", debugPort, false), MyDebugLauncher.this.myRunningState, device);
                    RunContentDescriptor debugDescriptor = null;
                    ProcessHandler processHandler = MyDebugLauncher.this.myRunningState.getProcessHandler();
                    processHandler.detachProcess();
                    try {
                        Object object = myDebugLock;
                        synchronized (object) {
                            assert (MyDebugLauncher.this.myRunDescriptor != null);
                            debugDescriptor = manager.attachVirtualMachine(new ExecutionEnvironmentBuilder(MyDebugLauncher.this.myEnvironment).executor(MyDebugLauncher.this.myExecutor).runner((ProgramRunner)AndroidDebugRunner.this).contentToReuse(MyDebugLauncher.this.myRunDescriptor).build(), (RunProfileState)st, st.getRemoteConnection(), false);
                        }
                    }
                    catch (ExecutionException e) {
                        processHandler.notifyTextAvailable("ExecutionException: " + e.getMessage() + '.', ProcessOutputTypes.STDERR);
                    }
                    ProcessHandler processHandler2 = newProcessHandler = debugDescriptor != null ? debugDescriptor.getProcessHandler() : null;
                    if (debugDescriptor == null || newProcessHandler == null) {
                        LOG.info("cannot start debugging");
                        return;
                    }
                    AndroidProcessText oldText = AndroidProcessText.get(processHandler);
                    if (oldText != null) {
                        oldText.printTo(newProcessHandler);
                    }
                    AndroidProcessText.attach(newProcessHandler);
                    MyDebugLauncher.this.myRunningState.getProcessHandler().putUserData(ANDROID_SESSION_INFO, (Object)new AndroidSessionInfo(debugDescriptor, st, MyDebugLauncher.this.myExecutor.getId()));
                    AndroidDebugRunner.setActivateToolWindowWhenAddedProperty(MyDebugLauncher.this.myProject, MyDebugLauncher.this.myExecutor, debugDescriptor, "debugger connected");
                }
            });
        }
    }

    private static class AndroidDebugState
    implements RemoteState,
    AndroidExecutionState {
        private final Project myProject;
        private final RemoteConnection myConnection;
        private final AndroidRunningState myState;
        private final IDevice myDevice;
        private volatile ConsoleView myConsoleView;

        public AndroidDebugState(Project project, RemoteConnection connection, AndroidRunningState state, IDevice device) {
            this.myProject = project;
            this.myConnection = connection;
            this.myState = state;
            this.myDevice = device;
        }

        public ExecutionResult execute(Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
            if (runner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "org/jetbrains/android/run/AndroidDebugRunner$AndroidDebugState", "execute"));
            }
            RemoteDebugProcessHandler process = new RemoteDebugProcessHandler(this.myProject);
            this.myState.setProcessHandler((ProcessHandler)process);
            this.myConsoleView = this.myState.getConfiguration().attachConsole(this.myState, executor);
            LogcatExecutionConsole console = new LogcatExecutionConsole(this.myProject, this.myDevice, this.myConsoleView, this.myState.getConfiguration().getType().getId());
            return new DefaultExecutionResult((ExecutionConsole)console, (ProcessHandler)process);
        }

        public RemoteConnection getRemoteConnection() {
            return this.myConnection;
        }

        @Override
        public IDevice[] getDevices() {
            return new IDevice[]{this.myDevice};
        }

        @Override
        @Nullable
        public ConsoleView getConsoleView() {
            return this.myConsoleView;
        }

        @Override
        @NotNull
        public AndroidRunConfigurationBase getConfiguration() {
            AndroidRunConfigurationBase androidRunConfigurationBase = this.myState.getConfiguration();
            if (androidRunConfigurationBase == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/AndroidDebugRunner$AndroidDebugState", "getConfiguration"));
            }
            return androidRunConfigurationBase;
        }
    }
}

