/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.GroovyAnnotator;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GroovyAssignabilityCheckInspection;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrAnnotatorImpl
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/annotator/GrAnnotatorImpl", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/groovy/annotator/GrAnnotatorImpl", "annotate"));
        }
        if (element instanceof GroovyPsiElement) {
            GroovyAnnotator annotator = new GroovyAnnotator(holder);
            ((GroovyPsiElement)element).accept(annotator);
            if (PsiUtil.isCompileStatic(element)) {
                GroovyAssignabilityCheckInspection.checkElement((GroovyPsiElement)element, holder);
            }
        } else if (element instanceof PsiComment) {
            String text = element.getText();
            if (text.startsWith("/*") && !text.endsWith("*/")) {
                TextRange range = element.getTextRange();
                holder.createErrorAnnotation(TextRange.create((int)(range.getEndOffset() - 1), (int)range.getEndOffset()), GroovyBundle.message("doc.end.expected", new Object[0]));
            }
        } else {
            GrField field;
            PsiElement parent = element.getParent();
            if (parent instanceof GrMethod) {
                if (element.equals(((GrMethod)parent).getNameIdentifierGroovy()) && ((GrMethod)parent).getReturnTypeElementGroovy() == null) {
                    GroovyAnnotator.checkMethodReturnType((GrMethod)parent, element, holder);
                }
            } else if (parent instanceof GrField && element.equals((field = (GrField)parent).getNameIdentifierGroovy())) {
                GrAccessorMethod[] getters;
                for (GrAccessorMethod getter : getters = field.getGetters()) {
                    GroovyAnnotator.checkMethodReturnType(getter, field.getNameIdentifierGroovy(), holder);
                }
                GrAccessorMethod setter = field.getSetter();
                if (setter != null) {
                    GroovyAnnotator.checkMethodReturnType(setter, field.getNameIdentifierGroovy(), holder);
                }
            }
        }
    }
}

