/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.highlighter;

import com.intellij.ide.PowerSaveMode;
import com.intellij.lexer.LayeredLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.StringLiteralLexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.highlighter.DefaultHighlighter;
import org.jetbrains.plugins.groovy.highlighter.GroovyDollarSlashyStringLexer;
import org.jetbrains.plugins.groovy.highlighter.GroovySlashyStringLexer;
import org.jetbrains.plugins.groovy.lang.groovydoc.parser.GroovyDocElementTypes;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyLexer;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;

public class GroovySyntaxHighlighter
extends SyntaxHighlighterBase {
    private static final Map<IElementType, TextAttributesKey> ATTRIBUTES = new HashMap<IElementType, TextAttributesKey>();
    private static final Map<IElementType, TextAttributesKey> POWER_SAVE_MODE_ATTRIBUTES = new HashMap<IElementType, TextAttributesKey>();
    static final TokenSet tBLOCK_COMMENTS = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mML_COMMENT, GroovyDocElementTypes.GROOVY_DOC_COMMENT});
    static final TokenSet tLINE_COMMENTS = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mSL_COMMENT, GroovyTokenTypes.mSH_COMMENT});
    static final TokenSet tBAD_CHARACTERS = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mWRONG});
    static final TokenSet tGSTRINGS = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mGSTRING_BEGIN, GroovyTokenTypes.mGSTRING_CONTENT, GroovyTokenTypes.mGSTRING_END, GroovyTokenTypes.mGSTRING_LITERAL});
    static final TokenSet tSTRINGS = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mSTRING_LITERAL});
    static final TokenSet tBRACES = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mLCURLY, GroovyTokenTypes.mRCURLY});
    static final TokenSet tPARENTHESES = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mLPAREN, GroovyTokenTypes.mRPAREN});
    static final TokenSet tBRACKETS = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mLBRACK, GroovyTokenTypes.mRBRACK});
    static final TokenSet tOperators = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSets.BINARY_OP_SET, TokenSets.UNARY_OP_SET, TokenSets.ASSIGN_OP_SET});

    @NotNull
    public Lexer getHighlightingLexer() {
        GroovyHighlightingLexer groovyHighlightingLexer = new GroovyHighlightingLexer();
        if (groovyHighlightingLexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/highlighter/GroovySyntaxHighlighter", "getHighlightingLexer"));
        }
        return groovyHighlightingLexer;
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey[] textAttributesKeyArray = GroovySyntaxHighlighter.pack((TextAttributesKey)(PowerSaveMode.isEnabled() ? POWER_SAVE_MODE_ATTRIBUTES.get(tokenType) : ATTRIBUTES.get(tokenType)));
        if (textAttributesKeyArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/highlighter/GroovySyntaxHighlighter", "getTokenHighlights"));
        }
        return textAttributesKeyArray;
    }

    static {
        GroovySyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)tLINE_COMMENTS, (TextAttributesKey)DefaultHighlighter.LINE_COMMENT);
        GroovySyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)tBLOCK_COMMENTS, (TextAttributesKey)DefaultHighlighter.BLOCK_COMMENT);
        GroovySyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)tBAD_CHARACTERS, (TextAttributesKey)DefaultHighlighter.BAD_CHARACTER);
        GroovySyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)TokenSets.NUMBERS, (TextAttributesKey)DefaultHighlighter.NUMBER);
        GroovySyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)tGSTRINGS, (TextAttributesKey)DefaultHighlighter.GSTRING);
        GroovySyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)tSTRINGS, (TextAttributesKey)DefaultHighlighter.STRING);
        GroovySyntaxHighlighter.fillMap(ATTRIBUTES, (TextAttributesKey)DefaultHighlighter.STRING, (IElementType[])new IElementType[]{GroovyTokenTypes.mREGEX_BEGIN, GroovyTokenTypes.mREGEX_CONTENT, GroovyTokenTypes.mREGEX_END, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_BEGIN, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_CONTENT, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_END});
        GroovySyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)tBRACES, (TextAttributesKey)DefaultHighlighter.BRACES);
        GroovySyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)tBRACKETS, (TextAttributesKey)DefaultHighlighter.BRACKETS);
        GroovySyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)tPARENTHESES, (TextAttributesKey)DefaultHighlighter.PARENTHESES);
        GroovySyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)tOperators, (TextAttributesKey)DefaultHighlighter.OPERATION_SIGN);
        GroovySyntaxHighlighter.fillMap(ATTRIBUTES, (TextAttributesKey)DefaultHighlighter.VALID_STRING_ESCAPE, (IElementType[])new IElementType[]{StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN});
        GroovySyntaxHighlighter.fillMap(ATTRIBUTES, (TextAttributesKey)DefaultHighlighter.INVALID_STRING_ESCAPE, (IElementType[])new IElementType[]{StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN});
        GroovySyntaxHighlighter.fillMap(ATTRIBUTES, (TextAttributesKey)DefaultHighlighter.INVALID_STRING_ESCAPE, (IElementType[])new IElementType[]{StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN});
        GroovySyntaxHighlighter.fillMap(POWER_SAVE_MODE_ATTRIBUTES, (TokenSet)tLINE_COMMENTS, (TextAttributesKey)DefaultHighlighter.LINE_COMMENT);
        GroovySyntaxHighlighter.fillMap(POWER_SAVE_MODE_ATTRIBUTES, (TokenSet)tBLOCK_COMMENTS, (TextAttributesKey)DefaultHighlighter.BLOCK_COMMENT);
        GroovySyntaxHighlighter.fillMap(POWER_SAVE_MODE_ATTRIBUTES, (TokenSet)tBAD_CHARACTERS, (TextAttributesKey)DefaultHighlighter.BAD_CHARACTER);
        GroovySyntaxHighlighter.fillMap(POWER_SAVE_MODE_ATTRIBUTES, (TokenSet)TokenSets.NUMBERS, (TextAttributesKey)DefaultHighlighter.NUMBER);
        GroovySyntaxHighlighter.fillMap(POWER_SAVE_MODE_ATTRIBUTES, (TokenSet)tGSTRINGS, (TextAttributesKey)DefaultHighlighter.GSTRING);
        GroovySyntaxHighlighter.fillMap(POWER_SAVE_MODE_ATTRIBUTES, (TokenSet)tSTRINGS, (TextAttributesKey)DefaultHighlighter.STRING);
        GroovySyntaxHighlighter.fillMap(POWER_SAVE_MODE_ATTRIBUTES, (TextAttributesKey)DefaultHighlighter.STRING, (IElementType[])new IElementType[]{GroovyTokenTypes.mREGEX_BEGIN, GroovyTokenTypes.mREGEX_CONTENT, GroovyTokenTypes.mREGEX_END, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_BEGIN, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_CONTENT, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_END});
        GroovySyntaxHighlighter.fillMap(POWER_SAVE_MODE_ATTRIBUTES, (TokenSet)tBRACES, (TextAttributesKey)DefaultHighlighter.BRACES);
        GroovySyntaxHighlighter.fillMap(POWER_SAVE_MODE_ATTRIBUTES, (TokenSet)tBRACKETS, (TextAttributesKey)DefaultHighlighter.BRACKETS);
        GroovySyntaxHighlighter.fillMap(POWER_SAVE_MODE_ATTRIBUTES, (TokenSet)tPARENTHESES, (TextAttributesKey)DefaultHighlighter.PARENTHESES);
        GroovySyntaxHighlighter.fillMap(POWER_SAVE_MODE_ATTRIBUTES, (TextAttributesKey)DefaultHighlighter.VALID_STRING_ESCAPE, (IElementType[])new IElementType[]{StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN});
        GroovySyntaxHighlighter.fillMap(POWER_SAVE_MODE_ATTRIBUTES, (TextAttributesKey)DefaultHighlighter.INVALID_STRING_ESCAPE, (IElementType[])new IElementType[]{StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN});
        GroovySyntaxHighlighter.fillMap(POWER_SAVE_MODE_ATTRIBUTES, (TextAttributesKey)DefaultHighlighter.INVALID_STRING_ESCAPE, (IElementType[])new IElementType[]{StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN});
        GroovySyntaxHighlighter.fillMap(POWER_SAVE_MODE_ATTRIBUTES, (TokenSet)TokenSets.KEYWORDS, (TextAttributesKey)DefaultHighlighter.KEYWORD);
    }

    private static class GroovyHighlightingLexer
    extends LayeredLexer {
        private GroovyHighlightingLexer() {
            super((Lexer)new GroovyLexer());
            this.registerSelfStoppingLayer((Lexer)new StringLiteralLexer('\uffff', GroovyTokenTypes.mSTRING_LITERAL, true, "$"), new IElementType[]{GroovyTokenTypes.mSTRING_LITERAL}, IElementType.EMPTY_ARRAY);
            this.registerSelfStoppingLayer((Lexer)new StringLiteralLexer('\uffff', GroovyTokenTypes.mGSTRING_LITERAL, true, "$"), new IElementType[]{GroovyTokenTypes.mGSTRING_LITERAL}, IElementType.EMPTY_ARRAY);
            this.registerSelfStoppingLayer((Lexer)new StringLiteralLexer('\uffff', GroovyTokenTypes.mGSTRING_CONTENT, true, "$"), new IElementType[]{GroovyTokenTypes.mGSTRING_CONTENT}, IElementType.EMPTY_ARRAY);
            this.registerSelfStoppingLayer((Lexer)new GroovySlashyStringLexer(), new IElementType[]{GroovyTokenTypes.mREGEX_CONTENT}, IElementType.EMPTY_ARRAY);
            this.registerSelfStoppingLayer((Lexer)new GroovyDollarSlashyStringLexer(), new IElementType[]{GroovyTokenTypes.mDOLLAR_SLASH_REGEX_CONTENT}, IElementType.EMPTY_ARRAY);
        }
    }
}

