/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.execution.JUnitPatcher;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.MavenPropertyResolver;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectSettings;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenTestRunningSettings;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;

public class MavenJUnitPatcher
extends JUnitPatcher {
    public void patchJavaParameters(@Nullable Module module, JavaParameters javaParameters) {
        String value;
        Element argLine;
        Element environmentVariables;
        String value2;
        Element systemPropertyVariables;
        if (module == null) {
            return;
        }
        MavenProject mavenProject = MavenProjectsManager.getInstance(module.getProject()).findProject(module);
        if (mavenProject == null) {
            return;
        }
        Element config = mavenProject.getPluginConfiguration("org.apache.maven.plugins", "maven-surefire-plugin");
        if (config == null) {
            return;
        }
        MavenTestRunningSettings testRunningSettings = MavenProjectSettings.getInstance(module.getProject()).getTestRunningSettings();
        List<String> paths = MavenJDOMUtil.findChildrenValuesByPath(config, "additionalClasspathElements", "additionalClasspathElement");
        if (paths.size() > 0) {
            MavenDomProjectModel domModel = MavenDomUtil.getMavenDomProjectModel(module.getProject(), mavenProject.getFile());
            for (String path : paths) {
                if (domModel != null) {
                    path = MavenPropertyResolver.resolve(path, domModel);
                }
                javaParameters.getClassPath().add(MavenJUnitPatcher.resolveSurefireProperties(path));
            }
        }
        if (testRunningSettings.isPassSystemProperties() && MavenJUnitPatcher.isEnabled("systemPropertyVariables") && (systemPropertyVariables = config.getChild("systemPropertyVariables")) != null) {
            for (Element element : systemPropertyVariables.getChildren()) {
                String propertyName = element.getName();
                if (javaParameters.getVMParametersList().hasProperty(propertyName) || !MavenJUnitPatcher.isResolved(value2 = MavenJUnitPatcher.resolveSurefireProperties(element.getValue()))) continue;
                javaParameters.getVMParametersList().addProperty(propertyName, value2);
            }
        }
        if (testRunningSettings.isPassEnvironmentVariables() && MavenJUnitPatcher.isEnabled("environmentVariables") && (environmentVariables = config.getChild("environmentVariables")) != null) {
            for (Element element : environmentVariables.getChildren()) {
                String variableName = element.getName();
                if (javaParameters.getEnv().containsKey(variableName) || !MavenJUnitPatcher.isResolved(value2 = MavenJUnitPatcher.resolveSurefireProperties(element.getValue()))) continue;
                javaParameters.addEnv(variableName, value2);
            }
        }
        if (testRunningSettings.isPassArgLine() && MavenJUnitPatcher.isEnabled("argLine") && (argLine = config.getChild("argLine")) != null && StringUtil.isNotEmpty((String)(value = MavenJUnitPatcher.resolveSurefireProperties(argLine.getTextTrim()))) && MavenJUnitPatcher.isResolved(value)) {
            javaParameters.getVMParametersList().addParametersString(value);
        }
    }

    private static String resolveSurefireProperties(String value) {
        return value.replaceAll("\\$\\{surefire\\.(forkNumber|threadNumber)\\}", "1");
    }

    private static boolean isEnabled(String s) {
        return Boolean.valueOf(System.getProperty("idea.maven.surefire.disable." + s)) == false;
    }

    private static boolean isResolved(String s) {
        return !s.contains("${") || Boolean.valueOf(System.getProperty("idea.maven.surefire.allPropertiesAreResolved")) != false;
    }
}

