/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing.configurers;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.compiler.options.ExcludeEntryDescription;
import com.intellij.openapi.compiler.options.ExcludesConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.configurers.MavenModuleConfigurer;
import org.jetbrains.idea.maven.project.MavenProject;

public class MavenCompilerConfigurer
extends MavenModuleConfigurer {
    @Override
    public void configure(@NotNull MavenProject mavenProject, @NotNull Project project, @Nullable Module module) {
        CompilerConfigurationImpl compilerConfiguration;
        VirtualFile directoryFile;
        VirtualFile archetypeResourcesDir;
        if (mavenProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenProject", "org/jetbrains/idea/maven/importing/configurers/MavenCompilerConfigurer", "configure"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/importing/configurers/MavenCompilerConfigurer", "configure"));
        }
        if (module == null) {
            return;
        }
        String targetLevel = mavenProject.getTargetLevel();
        if (targetLevel != null) {
            CompilerConfigurationImpl configuration = (CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)project);
            configuration.setBytecodeTargetLevel(module, targetLevel);
        }
        if ((archetypeResourcesDir = VfsUtil.findRelativeFile((VirtualFile)(directoryFile = mavenProject.getDirectoryFile()), (String[])new String[]{"src", "main", "resources", "archetype-resources"})) != null && !(compilerConfiguration = (CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)project)).isExcludedFromCompilation(archetypeResourcesDir)) {
            ExcludesConfiguration cfg = compilerConfiguration.getExcludedEntriesConfiguration();
            cfg.addExcludeEntryDescription(new ExcludeEntryDescription(archetypeResourcesDir, true, false, (Disposable)project));
        }
    }
}

