/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.refs;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiType;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.XmlAttributeDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxFieldIdReferenceProvider;

class JavaFxComponentIdReferenceProvider
extends PsiReferenceProvider {
    JavaFxComponentIdReferenceProvider() {
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider", "getReferencesByElement"));
        }
        XmlAttributeValue xmlAttributeValue = (XmlAttributeValue)element;
        final XmlTag currentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)xmlAttributeValue, XmlTag.class);
        String value = xmlAttributeValue.getValue();
        boolean startsWithDollar = value.startsWith("$");
        String referencesId = startsWithDollar ? value.substring(1) : value;
        final HashMap<String, XmlAttributeValue> fileIds = new HashMap<String, XmlAttributeValue>();
        xmlAttributeValue.getContainingFile().accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                XmlAttribute attribute;
                super.visitXmlTag(tag);
                if (currentTag != tag && (attribute = tag.getAttribute("fx:id")) != null) {
                    fileIds.put(attribute.getValue(), attribute.getValueElement());
                }
            }
        });
        if (JavaFxPsiUtil.isExpressionBinding(value)) {
            XmlAttributeValue attributeValue;
            PsiClass tagClass;
            String expressionText = referencesId.substring(1, referencesId.length() - 1);
            String newId = StringUtil.getPackageName((String)expressionText);
            String fieldRef = StringUtil.getShortName((String)expressionText);
            PsiClass controllerClass = JavaFxPsiUtil.getControllerClass(element.getContainingFile());
            PsiField controllerField = controllerClass != null ? controllerClass.findFieldByName(newId, false) : null;
            PsiReferenceBase idReferenceBase = controllerField == null ? new JavaFxIdReferenceBase(xmlAttributeValue, fileIds, newId) : new JavaFxFieldIdReferenceProvider.JavaFxControllerFieldRef(xmlAttributeValue, controllerField, controllerClass);
            TextRange range = idReferenceBase.getRangeInElement();
            int startOffset = range.getStartOffset() + 2;
            int endOffset = startOffset + newId.length();
            idReferenceBase.setRangeInElement(new TextRange(startOffset, endOffset));
            if (fileIds.containsKey(newId) && (tagClass = JavaFxPsiUtil.getTagClass(attributeValue = (XmlAttributeValue)fileIds.get(newId))) != null) {
                JavaFxExpressionReferenceBase referenceBase = new JavaFxExpressionReferenceBase(xmlAttributeValue, tagClass, fieldRef);
                TextRange textRange = referenceBase.getRangeInElement();
                referenceBase.setRangeInElement(new TextRange(endOffset + 1, textRange.getEndOffset() - 1));
                PsiReference[] psiReferenceArray = new PsiReference[]{idReferenceBase, referenceBase};
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
            PsiReference[] psiReferenceArray = new PsiReference[]{idReferenceBase};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        if (startsWithDollar) {
            JavaFxIdReferenceBase idReferenceBase = new JavaFxIdReferenceBase(xmlAttributeValue, fileIds, referencesId);
            TextRange rangeInElement = idReferenceBase.getRangeInElement();
            idReferenceBase.setRangeInElement(new TextRange(rangeInElement.getStartOffset() + 1, rangeInElement.getEndOffset()));
            PsiReference[] psiReferenceArray = new PsiReference[]{idReferenceBase};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        HashSet<String> acceptableIds = new HashSet<String>();
        if (currentTag != null) {
            XmlTag parentTag = currentTag.getParentTag();
            for (String id : fileIds.keySet()) {
                XmlAttributeValue resolvedAttrValue = (XmlAttributeValue)fileIds.get(id);
                if (JavaFxPsiUtil.isClassAcceptable(parentTag, JavaFxPsiUtil.getTagClass(resolvedAttrValue)) != null) continue;
                acceptableIds.add(id);
            }
        }
        JavaFxIdReferenceBase idReferenceBase = new JavaFxIdReferenceBase(xmlAttributeValue, fileIds, acceptableIds, referencesId);
        PsiReference[] psiReferenceArray = new PsiReference[]{idReferenceBase};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    private static class JavaFxExpressionReferenceBase
    extends PsiReferenceBase<XmlAttributeValue> {
        private final PsiClass myTagClass;
        private final String myFieldName;

        public JavaFxExpressionReferenceBase(XmlAttributeValue xmlAttributeValue, PsiClass tagClass, String fieldName) {
            super((PsiElement)xmlAttributeValue);
            this.myTagClass = tagClass;
            this.myFieldName = fieldName;
        }

        @Nullable
        public PsiElement resolve() {
            return this.myTagClass.findFieldByName(this.myFieldName, true);
        }

        @NotNull
        public Object[] getVariants() {
            PsiElement declaration;
            XmlAttributeDescriptor descriptor;
            PsiElement parent = ((XmlAttributeValue)this.getElement()).getParent();
            if (parent instanceof XmlAttribute && (descriptor = ((XmlAttribute)parent).getDescriptor()) != null && (declaration = descriptor.getDeclaration()) instanceof PsiField) {
                Object[] objectArray = this.collectProperties((PsiField)declaration);
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider$JavaFxExpressionReferenceBase", "getVariants"));
                }
                return objectArray;
            }
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider$JavaFxExpressionReferenceBase", "getVariants"));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }

        private Object[] collectProperties(@NotNull PsiField psiField) {
            if (psiField == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiField", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider$JavaFxExpressionReferenceBase", "collectProperties"));
            }
            PsiType type = psiField.getType();
            PsiType propertyType = JavaFxPsiUtil.getPropertyType(type, psiField.getProject());
            ArrayList<PsiField> objs = new ArrayList<PsiField>();
            for (PsiField field : this.myTagClass.getAllFields()) {
                PsiType fieldType;
                if (field.hasModifierProperty("static") || !TypeConversionUtil.isAssignable((PsiType)type, (PsiType)(fieldType = field.getType())) && (propertyType == null || !TypeConversionUtil.isAssignable((PsiType)propertyType, (PsiType)fieldType))) continue;
                objs.add(field);
            }
            return ArrayUtil.toObjectArray(objs);
        }
    }

    private static class JavaFxIdReferenceBase
    extends PsiReferenceBase<XmlAttributeValue> {
        private final Map<String, XmlAttributeValue> myFileIds;
        private final Set<String> myAcceptableIds;
        private final String myReferencesId;

        private JavaFxIdReferenceBase(XmlAttributeValue element, Map<String, XmlAttributeValue> fileIds, Set<String> acceptableIds, String referencesId) {
            super((PsiElement)element);
            this.myFileIds = fileIds;
            this.myAcceptableIds = acceptableIds;
            this.myReferencesId = referencesId;
        }

        public JavaFxIdReferenceBase(XmlAttributeValue xmlAttributeValue, Map<String, XmlAttributeValue> fileIds, String referencesId) {
            super((PsiElement)xmlAttributeValue);
            this.myFileIds = fileIds;
            this.myReferencesId = referencesId;
            this.myAcceptableIds = this.myFileIds.keySet();
        }

        @Nullable
        public PsiElement resolve() {
            return (PsiElement)this.myFileIds.get(this.myReferencesId);
        }

        @NotNull
        public Object[] getVariants() {
            Object[] objectArray = ArrayUtil.toStringArray(this.myAcceptableIds);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxComponentIdReferenceProvider$JavaFxIdReferenceBase", "getVariants"));
            }
            return objectArray;
        }
    }
}

