/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.reference.SoftReference;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ConcurrentWeakHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class SoftFactoryMap<T, V> {
    private final ConcurrentMap<T, java.lang.ref.SoftReference<V>> myMap = new ConcurrentWeakHashMap<T, java.lang.ref.SoftReference<V>>();

    protected abstract V create(T var1);

    public final V get(T key) {
        java.lang.ref.SoftReference reference = (java.lang.ref.SoftReference)this.myMap.get(key);
        Object v = SoftReference.dereference(reference);
        if (v != null) {
            return v == ObjectUtils.NULL ? null : (V)v;
        }
        V value = this.create(key);
        java.lang.ref.SoftReference<Object> valueRef = new java.lang.ref.SoftReference<Object>(value == null ? ObjectUtils.NULL : value);
        java.lang.ref.SoftReference<Object> prevRef = this.myMap.putIfAbsent(key, valueRef);
        Object prev = SoftReference.dereference(prevRef);
        return (V)(prev == null || prev == ObjectUtils.NULL ? value : prev);
    }

    public final boolean containsKey(T key) {
        return this.myMap.containsKey(key);
    }

    public void clear() {
        this.myMap.clear();
    }
}

