/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.util.text.CharArrayExternalizable;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceSubSequence;
import com.intellij.util.text.ImmutableCharSequence;
import org.jetbrains.annotations.NotNull;

public final class ImmutableText
extends ImmutableCharSequence
implements CharArrayExternalizable {
    private static final int BLOCK_SIZE = 64;
    private static final int BLOCK_MASK = -64;
    private final Node myNode;
    private static final ImmutableText TRUE = ImmutableText.valueOf("true");
    private static final ImmutableText FALSE = ImmutableText.valueOf("false");
    private static final ImmutableText EMPTY = ImmutableText.valueOf("");
    private volatile InnerLeaf myLastLeaf;

    private ImmutableText(Node node) {
        this.myNode = node;
    }

    public static ImmutableText valueOf(@NotNull Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/util/text/ImmutableText", "valueOf"));
        }
        if (obj instanceof ImmutableText) {
            return (ImmutableText)obj;
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length() == 0 ? EMPTY : ImmutableText.valueOf((CharSequence)obj);
        }
        return ImmutableText.valueOf(String.valueOf(obj));
    }

    private static ImmutableText valueOf(@NotNull CharSequence str) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/util/text/ImmutableText", "valueOf"));
        }
        return new ImmutableText(new LeafNode(CharArrayUtil.fromSequence(str, 0, str.length())));
    }

    public static ImmutableText valueOf(@NotNull char[] chars) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/util/text/ImmutableText", "valueOf"));
        }
        return new ImmutableText(new LeafNode(chars));
    }

    public ImmutableText ensureChunked() {
        if (this.length() > 64 && this.myNode instanceof LeafNode) {
            return new ImmutableText(ImmutableText.nodeOf(((LeafNode)this.myNode)._data, 0, this.length()));
        }
        return this;
    }

    private static Node nodeOf(@NotNull char[] chars, int offset, int length) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/util/text/ImmutableText", "nodeOf"));
        }
        if (length <= 64) {
            if (offset == 0 && length == chars.length) {
                return new LeafNode(chars);
            }
            char[] subArray = new char[length];
            System.arraycopy(chars, offset, subArray, 0, length);
            return new LeafNode(subArray);
        }
        int half = length + 64 >> 1 & 0xFFFFFFC0;
        return new CompositeNode(ImmutableText.nodeOf(chars, offset, half), ImmutableText.nodeOf(chars, offset + half, length - half));
    }

    public static ImmutableText valueOf(boolean b) {
        return b ? TRUE : FALSE;
    }

    @Override
    public int length() {
        return this.myNode.nodeLength();
    }

    public ImmutableText concat(ImmutableText that) {
        return that.length() == 0 ? this : new ImmutableText(this.ensureChunked().myNode.concatNodes(that.ensureChunked().myNode));
    }

    private ImmutableText subtext(int start) {
        return this.subtext(start, this.length());
    }

    public ImmutableText insert(int index, ImmutableText txt) {
        return this.subtext(0, index).concat(txt).concat(this.subtext(index));
    }

    public ImmutableText insert(int index, CharSequence seq) {
        return this.insert(index, ImmutableText.valueOf(seq));
    }

    public ImmutableText delete(int start, int end) {
        if (start == end) {
            return this;
        }
        if (start > end) {
            throw new IndexOutOfBoundsException();
        }
        return this.ensureChunked().subtext(0, start).concat(this.subtext(end));
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start == 0 && end == this.length()) {
            return this;
        }
        return new CharSequenceSubSequence(this, start, end);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ImmutableText)) {
            return false;
        }
        ImmutableText that = (ImmutableText)obj;
        int len = this.length();
        if (len != that.length()) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (this.charAt(i) == that.charAt(i++)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        int length = this.length();
        int i = 0;
        while (i < length) {
            h = 31 * h + this.charAt(i++);
        }
        return h;
    }

    @Override
    public char charAt(int index) {
        if (this.myNode instanceof LeafNode) {
            return ((LeafNode)this.myNode)._data[index];
        }
        InnerLeaf leaf = this.myLastLeaf;
        if (leaf == null || index < leaf.offset || index >= leaf.offset + leaf.leafNode.nodeLength()) {
            this.myLastLeaf = leaf = this.findLeaf(index, 0);
        }
        return leaf.leafNode._data[index - leaf.offset];
    }

    private InnerLeaf findLeaf(int index, int offset) {
        Node node = this.myNode;
        while (true) {
            if (index >= node.nodeLength()) {
                throw new IndexOutOfBoundsException();
            }
            if (node instanceof LeafNode) {
                return new InnerLeaf((LeafNode)node, offset);
            }
            CompositeNode composite = (CompositeNode)node;
            if (index < composite._head.nodeLength()) {
                node = composite._head;
                continue;
            }
            offset += composite._head.nodeLength();
            index -= composite._head.nodeLength();
            node = composite._tail;
        }
    }

    public ImmutableText subtext(int start, int end) {
        if (start < 0 || start > end || end > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (start == 0 && end == this.length()) {
            return this;
        }
        if (start == end) {
            return EMPTY;
        }
        return new ImmutableText(this.myNode.subNode(start, end));
    }

    @Override
    public void getChars(int start, int end, @NotNull char[] dest, int destPos) {
        if (dest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dest", "com/intellij/util/text/ImmutableText", "getChars"));
        }
        this.myNode.getChars(start, end, dest, destPos);
    }

    @Override
    @NotNull
    public String toString() {
        if (this.myNode instanceof LeafNode) {
            String string = new String(((LeafNode)this.myNode)._data, 0, this.length());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/ImmutableText", "toString"));
            }
            return string;
        }
        int len = this.length();
        char[] data = new char[len];
        this.getChars(0, len, data, 0);
        String string = new String(data, 0, len);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/ImmutableText", "toString"));
        }
        return string;
    }

    private static class CompositeNode
    extends Node {
        final int _count;
        final Node _head;
        final Node _tail;

        CompositeNode(Node _head, Node _tail) {
            this._count = _head.nodeLength() + _tail.nodeLength();
            this._head = _head;
            this._tail = _tail;
        }

        @Override
        int nodeLength() {
            return this._count;
        }

        Node rightRotation() {
            Node P = this._head;
            if (!(P instanceof CompositeNode)) {
                return this;
            }
            Node A = ((CompositeNode)P)._head;
            Node B = ((CompositeNode)P)._tail;
            Node C = this._tail;
            return new CompositeNode(A, new CompositeNode(B, C));
        }

        Node leftRotation() {
            Node Q = this._tail;
            if (!(Q instanceof CompositeNode)) {
                return this;
            }
            Node B = ((CompositeNode)Q)._head;
            Node C = ((CompositeNode)Q)._tail;
            Node A = this._head;
            return new CompositeNode(new CompositeNode(A, B), C);
        }

        @Override
        void getChars(int start, int end, @NotNull char[] dest, int destPos) {
            if (dest == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dest", "com/intellij/util/text/ImmutableText$CompositeNode", "getChars"));
            }
            int cesure = this._head.nodeLength();
            if (end <= cesure) {
                this._head.getChars(start, end, dest, destPos);
            } else if (start >= cesure) {
                this._tail.getChars(start - cesure, end - cesure, dest, destPos);
            } else {
                this._head.getChars(start, cesure, dest, destPos);
                this._tail.getChars(0, end - cesure, dest, destPos + cesure - start);
            }
        }

        @Override
        Node subNode(int start, int end) {
            int cesure = this._head.nodeLength();
            if (end <= cesure) {
                return this._head.subNode(start, end);
            }
            if (start >= cesure) {
                return this._tail.subNode(start - cesure, end - cesure);
            }
            if (start == 0 && end == this._count) {
                return this;
            }
            return this._head.subNode(start, cesure).concatNodes(this._tail.subNode(0, end - cesure));
        }
    }

    private static class LeafNode
    extends Node {
        final char[] _data;

        LeafNode(char[] _data) {
            this._data = _data;
        }

        @Override
        int nodeLength() {
            return this._data.length;
        }

        @Override
        void getChars(int start, int end, @NotNull char[] dest, int destPos) {
            if (dest == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dest", "com/intellij/util/text/ImmutableText$LeafNode", "getChars"));
            }
            if (start < 0 || end > this.nodeLength() || start > end) {
                throw new IndexOutOfBoundsException();
            }
            System.arraycopy(this._data, start, dest, destPos, end - start);
        }

        @Override
        Node subNode(int start, int end) {
            if (start == 0 && end == this.nodeLength()) {
                return this;
            }
            int length = end - start;
            char[] chars = new char[length];
            System.arraycopy(this._data, start, chars, 0, length);
            return new LeafNode(chars);
        }
    }

    private static abstract class Node {
        private Node() {
        }

        abstract int nodeLength();

        Node concatNodes(Node that) {
            int length = this.nodeLength() + that.nodeLength();
            if (length <= 64) {
                char[] chars = new char[length];
                this.getChars(0, this.nodeLength(), chars, 0);
                that.getChars(0, that.nodeLength(), chars, this.nodeLength());
                return new LeafNode(chars);
            }
            Node head = this;
            Node tail = that;
            if (head.nodeLength() << 1 < tail.nodeLength() && tail instanceof CompositeNode) {
                if (((CompositeNode)tail)._head.nodeLength() > ((CompositeNode)tail)._tail.nodeLength()) {
                    tail = ((CompositeNode)tail).rightRotation();
                }
                head = head.concatNodes(((CompositeNode)tail)._head);
                tail = ((CompositeNode)tail)._tail;
            } else if (tail.nodeLength() << 1 < head.nodeLength() && head instanceof CompositeNode) {
                if (((CompositeNode)head)._tail.nodeLength() > ((CompositeNode)head)._head.nodeLength()) {
                    head = ((CompositeNode)head).leftRotation();
                }
                tail = ((CompositeNode)head)._tail.concatNodes(tail);
                head = ((CompositeNode)head)._head;
            }
            return new CompositeNode(head, tail);
        }

        abstract void getChars(int var1, int var2, @NotNull char[] var3, int var4);

        abstract Node subNode(int var1, int var2);
    }

    private static class InnerLeaf {
        final LeafNode leafNode;
        final int offset;

        private InnerLeaf(LeafNode leafNode, int offset) {
            this.leafNode = leafNode;
            this.offset = offset;
        }
    }
}

