/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ConcurrentSoftValueHashMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.AccessorBindingWrapper;
import com.intellij.util.xmlb.AttributeBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.FieldAccessor;
import com.intellij.util.xmlb.JDOMElementBinding;
import com.intellij.util.xmlb.OptionTagBinding;
import com.intellij.util.xmlb.PropertyAccessor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.TagBinding;
import com.intellij.util.xmlb.TextBinding;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Text;
import com.intellij.util.xmlb.annotations.Transient;
import java.awt.Rectangle;
import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BeanBinding
implements Binding {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.xmlb.BeanBinding");
    private static final Map<Class, List<Accessor>> ourAccessorCache = new ConcurrentSoftValueHashMap<Class, List<Accessor>>();
    private final String myTagName;
    private final Map<Binding, Accessor> myPropertyBindings = new HashMap<Binding, Accessor>();
    private final List<Binding> myPropertyBindingsList = new ArrayList<Binding>();
    private final Class<?> myBeanClass;
    @NonNls
    private static final String CLASS_PROPERTY = "class";
    private final Accessor myAccessor;

    public BeanBinding(Class<?> beanClass, @Nullable Accessor accessor) {
        this.myAccessor = accessor;
        assert (!beanClass.isArray()) : "Bean is an array: " + beanClass;
        assert (!beanClass.isPrimitive()) : "Bean is primitive type: " + beanClass;
        this.myBeanClass = beanClass;
        this.myTagName = BeanBinding.getTagName(beanClass);
        assert (!StringUtil.isEmptyOrSpaces(this.myTagName)) : "Bean name is empty: " + beanClass;
    }

    @Override
    public void init() {
        this.initPropertyBindings(this.myBeanClass);
    }

    private synchronized void initPropertyBindings(Class<?> beanClass) {
        for (Accessor accessor : BeanBinding.getAccessors(beanClass)) {
            Binding binding = BeanBinding.createBindingByAccessor(accessor);
            this.myPropertyBindingsList.add(binding);
            this.myPropertyBindings.put(binding, accessor);
        }
    }

    @Override
    @Nullable
    public Object serialize(@NotNull Object o, @Nullable Object context, SerializationFilter filter) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/util/xmlb/BeanBinding", "serialize"));
        }
        Element element = new Element(this.myTagName);
        this.serializeInto(o, element, filter);
        return element;
    }

    public void serializeInto(@NotNull Object o, @NotNull Element element, @NotNull SerializationFilter filter) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/util/xmlb/BeanBinding", "serializeInto"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xmlb/BeanBinding", "serializeInto"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/xmlb/BeanBinding", "serializeInto"));
        }
        for (Binding binding : this.myPropertyBindingsList) {
            Object node;
            Accessor accessor = this.myPropertyBindings.get(binding);
            if (!filter.accepts(accessor, o)) continue;
            Property property = XmlSerializerImpl.findAnnotation(accessor.getAnnotations(), Property.class);
            if (property != null) {
                try {
                    if (!property.filter().newInstance().accepts(accessor, o)) {
                        continue;
                    }
                }
                catch (InstantiationException e) {
                    throw new XmlSerializationException(e);
                }
                catch (IllegalAccessException e) {
                    throw new XmlSerializationException(e);
                }
            }
            if ((node = binding.serialize(o, element, filter)) == null) continue;
            if (node instanceof org.jdom.Attribute) {
                element.setAttribute((org.jdom.Attribute)node);
                continue;
            }
            JDOMUtil.addContent(element, node);
        }
    }

    public void deserializeInto(Object bean, @NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xmlb/BeanBinding", "deserializeInto"));
        }
        this._deserializeInto(bean, element);
    }

    @Override
    public Object deserialize(Object o, Object ... nodes) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/util/xmlb/BeanBinding", "deserialize"));
        }
        return this._deserializeInto(this.instantiateBean(), nodes);
    }

    private Object _deserializeInto(Object result, Object ... aNodes) {
        Object[] children;
        if (aNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aNodes", "com/intellij/util/xmlb/BeanBinding", "_deserializeInto"));
        }
        ArrayList<Object> nodes = new ArrayList<Object>();
        for (Object aNode : aNodes) {
            if (XmlSerializerImpl.isIgnoredNode(aNode)) continue;
            nodes.add(aNode);
        }
        if (nodes.size() != 1) {
            if (nodes.isEmpty()) {
                return result;
            }
            throw new XmlSerializationException("Wrong set of nodes: " + nodes + " for bean" + this.myBeanClass + " in " + this.myAccessor);
        }
        assert (nodes.get(0) instanceof Element) : "Wrong node: " + nodes;
        Element e = (Element)nodes.get(0);
        ArrayList<Binding> bindings = new ArrayList<Binding>(this.myPropertyBindings.keySet());
        MultiMap<Binding, Object> data = new MultiMap<Binding, Object>();
        block1: for (Object child : children = JDOMUtil.getChildNodesWithAttrs(e)) {
            if (XmlSerializerImpl.isIgnoredNode(child)) continue;
            for (Binding binding : bindings) {
                if (!binding.isBoundTo(child)) continue;
                data.putValue(binding, child);
                continue block1;
            }
            String message = "Format error: no binding for " + child + " inside " + this;
            LOG.debug(message);
            Logger.getInstance(this.myBeanClass.getName()).debug(message);
            Logger.getInstance("#" + this.myBeanClass.getName()).debug(message);
        }
        Iterator i$ = data.keySet().iterator();
        while (i$.hasNext()) {
            Binding o1;
            Binding binding = o1 = (Binding)i$.next();
            Collection nn = data.get(binding);
            binding.deserialize(result, ArrayUtil.toObjectArray(nn));
        }
        return result;
    }

    private Object instantiateBean() {
        return XmlSerializerImpl.newInstance(this.myBeanClass);
    }

    @Override
    public boolean isBoundTo(Object node) {
        return node instanceof Element && ((Element)node).getName().equals(this.myTagName);
    }

    @Override
    public Class getBoundNodeType() {
        return Element.class;
    }

    private static String getTagName(Class<?> aClass) {
        for (Class<?> c = aClass; c != null; c = c.getSuperclass()) {
            String name = BeanBinding.getTagNameFromAnnotation(c);
            if (name == null) continue;
            return name;
        }
        return aClass.getSimpleName();
    }

    private static String getTagNameFromAnnotation(Class<?> aClass) {
        Tag tag = aClass.getAnnotation(Tag.class);
        if (tag != null && !tag.value().isEmpty()) {
            return tag.value();
        }
        return null;
    }

    @NotNull
    static List<Accessor> getAccessors(Class<?> aClass) {
        List<Accessor> accessors = ourAccessorCache.get(aClass);
        if (accessors != null) {
            List<Accessor> list = accessors;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/BeanBinding", "getAccessors"));
            }
            return list;
        }
        accessors = ContainerUtil.newArrayList();
        if (aClass != Rectangle.class) {
            BeanBinding.collectPropertyAccessors(aClass, accessors);
        }
        BeanBinding.collectFieldAccessors(aClass, accessors);
        ourAccessorCache.put(aClass, accessors);
        List<Accessor> list = accessors;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/BeanBinding", "getAccessors"));
        }
        return list;
    }

    private static void collectPropertyAccessors(Class<?> aClass, List<Accessor> accessors) {
        TreeMap candidates = ContainerUtil.newTreeMap();
        for (Method method : aClass.getMethods()) {
            Pair<String, Boolean> propertyData;
            if (!Modifier.isPublic(method.getModifiers()) || (propertyData = BeanBinding.getPropertyData(method.getName())) == null || ((String)propertyData.first).equals(CLASS_PROPERTY) || method.getParameterTypes().length != ((Boolean)propertyData.second != false ? 1 : 0)) continue;
            Couple<Object> candidate = (Couple)candidates.get(propertyData.first);
            if (candidate == null) {
                candidate = Couple.getEmpty();
            }
            if (((Boolean)propertyData.second != false ? (Method)candidate.second : (Method)candidate.first) != null) continue;
            candidate = Couple.of((Boolean)propertyData.second != false ? (Method)candidate.first : method, (Boolean)propertyData.second != false ? method : (Method)candidate.second);
            candidates.put(propertyData.first, candidate);
        }
        for (Map.Entry candidate : candidates.entrySet()) {
            Couple methods = (Couple)candidate.getValue();
            if (methods.first == null || methods.second == null || !((Method)methods.first).getReturnType().equals(((Method)methods.second).getParameterTypes()[0]) || XmlSerializerImpl.findAnnotation(((Method)methods.first).getAnnotations(), Transient.class) != null || XmlSerializerImpl.findAnnotation(((Method)methods.second).getAnnotations(), Transient.class) != null) continue;
            accessors.add(new PropertyAccessor((String)candidate.getKey(), ((Method)methods.first).getReturnType(), (Method)methods.first, (Method)methods.second));
        }
    }

    private static void collectFieldAccessors(Class<?> aClass, List<Accessor> accessors) {
        for (Field field : aClass.getFields()) {
            int modifiers = field.getModifiers();
            if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers) || Modifier.isTransient(modifiers) || XmlSerializerImpl.findAnnotation(field.getAnnotations(), Transient.class) != null) continue;
            accessors.add(new FieldAccessor(field));
        }
    }

    @Nullable
    private static Pair<String, Boolean> getPropertyData(String methodName) {
        String part = "";
        boolean isSetter = false;
        if (methodName.startsWith("get")) {
            part = methodName.substring(3, methodName.length());
        } else if (methodName.startsWith("is")) {
            part = methodName.substring(2, methodName.length());
        } else if (methodName.startsWith("set")) {
            part = methodName.substring(3, methodName.length());
            isSetter = true;
        }
        return !part.isEmpty() ? Pair.create(Introspector.decapitalize(part), isSetter) : null;
    }

    public String toString() {
        return "BeanBinding[" + this.myBeanClass.getName() + ", tagName=" + this.myTagName + "]";
    }

    private static Binding createBindingByAccessor(Accessor accessor) {
        Binding binding = BeanBinding._createBinding(accessor);
        binding.init();
        return binding;
    }

    private static Binding _createBinding(@NotNull Accessor accessor) {
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "com/intellij/util/xmlb/BeanBinding", "_createBinding"));
        }
        Binding binding = XmlSerializerImpl.getTypeBinding(accessor.getGenericType(), accessor);
        if (binding instanceof JDOMElementBinding) {
            return binding;
        }
        Attribute attribute = XmlSerializerImpl.findAnnotation(accessor.getAnnotations(), Attribute.class);
        if (attribute != null) {
            return new AttributeBinding(accessor, attribute);
        }
        Tag tag = XmlSerializerImpl.findAnnotation(accessor.getAnnotations(), Tag.class);
        if (tag != null && !tag.value().isEmpty()) {
            return new TagBinding(accessor, tag);
        }
        Text text = XmlSerializerImpl.findAnnotation(accessor.getAnnotations(), Text.class);
        if (text != null) {
            return new TextBinding(accessor);
        }
        boolean surroundWithTag = true;
        Property property = XmlSerializerImpl.findAnnotation(accessor.getAnnotations(), Property.class);
        if (property != null) {
            surroundWithTag = property.surroundWithTag();
        }
        if (!surroundWithTag) {
            if (!Element.class.isAssignableFrom(binding.getBoundNodeType())) {
                throw new XmlSerializationException("Text-serializable properties can't be serialized without surrounding tags: " + accessor);
            }
            return new AccessorBindingWrapper(accessor, binding);
        }
        OptionTag optionTag = XmlSerializerImpl.findAnnotation(accessor.getAnnotations(), OptionTag.class);
        return new OptionTagBinding(accessor, optionTag);
    }
}

