/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.coverage.report.impl.html;

import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.ResourceBundleModel;
import freemarker.template.Template;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import jetbrains.coverage.report.ReportGenerationFailedException;
import jetbrains.coverage.report.impl.IOUtil;
import jetbrains.coverage.report.impl.html.GeneratorPaths;
import jetbrains.coverage.report.impl.html.SortOption;
import jetbrains.coverage.report.impl.html.TemplateProcessor;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TemplateProcessorBase
implements TemplateProcessor {
    private final String myResourceBundleName;
    private final boolean myIncludeModule;

    protected TemplateProcessorBase(String resourceBundleName, boolean includeModule) {
        this.myResourceBundleName = resourceBundleName;
        this.myIncludeModule = includeModule;
    }

    protected abstract String getFooterText();

    @Override
    public void renderTemplate(Map<String, Object> params, @NotNull GeneratorPaths paths) throws IOException {
        if (paths == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/coverage/report/impl/html/TemplateProcessorBase.renderTemplate must not be null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("resources", new ResourceBundleModel(this.getResourceBundle(), new BeansWrapper()));
        map.put("generateDate", new Date());
        map.putAll(params);
        map.put("paths", paths);
        map.put("sort_option_sort_by_name", (Object)SortOption.SORT_BY_NAME);
        map.put("sort_option_none", (Object)SortOption.NONE);
        map.put("include_modules", this.myIncludeModule);
        map.put("footerTextHTML", this.getFooterText());
        this.createFileFromTemplate(this.createTemplate(), map, paths.getReportFileName());
    }

    @NotNull
    protected abstract Template createTemplate() throws IOException;

    private void createFileFromTemplate(@NotNull Template tpl, @NotNull Map model, @NotNull File file) {
        if (tpl == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/impl/html/TemplateProcessorBase.createFileFromTemplate must not be null");
        }
        if (model == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/coverage/report/impl/html/TemplateProcessorBase.createFileFromTemplate must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/coverage/report/impl/html/TemplateProcessorBase.createFileFromTemplate must not be null");
        }
        OutputStream fos = null;
        try {
            IOUtil.createDir(file.getParentFile());
            fos = new FileOutputStream(file);
            fos = new BufferedOutputStream(fos);
            OutputStreamWriter writer = new OutputStreamWriter(fos);
            tpl.process((Object)model, (Writer)writer);
        }
        catch (Throwable e) {
            try {
                throw new ReportGenerationFailedException("Failed to generate file: " + file.getAbsolutePath() + ". " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtil.close(fos);
                throw throwable;
            }
        }
        IOUtil.close(fos);
    }

    private ResourceBundle getResourceBundle() {
        return ResourceBundle.getBundle(this.myResourceBundleName);
    }
}

