/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service.scopes;

import java.util.Arrays;
import java.util.LinkedList;
import org.gradle.StartParameter;
import org.gradle.api.internal.DependencyInjectingInstantiator;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.artifacts.dsl.dependencies.ProjectFinder;
import org.gradle.api.internal.plugins.DefaultPluginContainer;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.options.OptionReader;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.execution.BuildConfigurationAction;
import org.gradle.execution.BuildExecuter;
import org.gradle.execution.DefaultBuildExecuter;
import org.gradle.execution.DefaultTasksBuildExecutionAction;
import org.gradle.execution.DryRunBuildExecutionAction;
import org.gradle.execution.ExcludedTaskFilteringBuildConfigurationAction;
import org.gradle.execution.ProjectEvaluatingAction;
import org.gradle.execution.SelectedTaskExecutionAction;
import org.gradle.execution.TaskGraphExecuter;
import org.gradle.execution.TaskNameResolvingBuildConfigurationAction;
import org.gradle.execution.TaskSelector;
import org.gradle.execution.commandline.CommandLineTaskConfigurer;
import org.gradle.execution.commandline.CommandLineTaskParser;
import org.gradle.execution.taskgraph.DefaultTaskGraphExecuter;
import org.gradle.execution.taskgraph.TaskPlanExecutor;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.ProjectScopeServices;
import org.gradle.internal.service.scopes.ServiceRegistryFactory;
import org.gradle.internal.service.scopes.TaskExecutionServices;
import org.gradle.listener.ListenerManager;

public class GradleScopeServices
extends DefaultServiceRegistry {
    private final CompositeStoppable registries = new CompositeStoppable();

    public GradleScopeServices(ServiceRegistry parent, GradleInternal gradle) {
        super(new ServiceRegistry[]{parent});
        this.add(GradleInternal.class, gradle);
        this.addProvider(new TaskExecutionServices());
    }

    TaskSelector createTaskSelector(GradleInternal gradle) {
        return new TaskSelector(gradle);
    }

    OptionReader createOptionReader() {
        return new OptionReader();
    }

    CommandLineTaskParser createCommandLineTaskParser(OptionReader optionReader, TaskSelector taskSelector) {
        return new CommandLineTaskParser(new CommandLineTaskConfigurer(optionReader), taskSelector);
    }

    BuildExecuter createBuildExecuter(CommandLineTaskParser commandLineTaskParser) {
        LinkedList<BuildConfigurationAction> configs = new LinkedList<BuildConfigurationAction>();
        if (((StartParameter)this.get(StartParameter.class)).isConfigureOnDemand()) {
            configs.add(new ProjectEvaluatingAction());
        }
        configs.add(new DefaultTasksBuildExecutionAction());
        configs.add(new ExcludedTaskFilteringBuildConfigurationAction());
        configs.add(new TaskNameResolvingBuildConfigurationAction(commandLineTaskParser));
        return new DefaultBuildExecuter(configs, Arrays.asList(new DryRunBuildExecutionAction(), new SelectedTaskExecutionAction()));
    }

    ProjectFinder createProjectFinder(final GradleInternal gradle) {
        return new ProjectFinder(){

            public ProjectInternal getProject(String path) {
                return gradle.getRootProject().project(path);
            }
        };
    }

    TaskGraphExecuter createTaskGraphExecuter(ListenerManager listenerManager, TaskPlanExecutor taskPlanExecutor, BuildCancellationToken cancellationToken) {
        return new DefaultTaskGraphExecuter(listenerManager, taskPlanExecutor, cancellationToken);
    }

    ServiceRegistryFactory createServiceRegistryFactory(final ServiceRegistry services) {
        return new ServiceRegistryFactory(){

            public ServiceRegistry createFor(Object domainObject) {
                if (domainObject instanceof ProjectInternal) {
                    ProjectScopeServices projectScopeServices = new ProjectScopeServices(services, (ProjectInternal)domainObject);
                    GradleScopeServices.this.registries.add(new Object[]{projectScopeServices});
                    return projectScopeServices;
                }
                throw new UnsupportedOperationException();
            }
        };
    }

    PluginRegistry createPluginRegistry(PluginRegistry parentRegistry) {
        return parentRegistry.createChild(((GradleInternal)this.get(GradleInternal.class)).getClassLoaderScope(), new DependencyInjectingInstantiator((ServiceRegistry)this));
    }

    PluginContainer createPluginContainer(GradleInternal gradle, PluginRegistry pluginRegistry) {
        return new DefaultPluginContainer<GradleInternal>(pluginRegistry, gradle);
    }

    public void close() {
        this.registries.stop();
        super.close();
    }
}

