/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.settings;

import com.intellij.openapi.externalSystem.model.settings.LocationSettingType;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemSettingsControl;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.util.PaintAwarePanel;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import java.awt.Component;
import java.io.File;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleBundle;

public class GradleSystemSettingsControl
implements ExternalSystemSettingsControl<GradleSettings> {
    @NotNull
    private final GradleSettings myInitialSettings;
    private JBLabel myServiceDirectoryLabel;
    private TextFieldWithBrowseButton myServiceDirectoryPathField;
    private JBLabel myGradleVmOptionsLabel;
    private JBTextField myGradleVmOptionsField;
    private boolean myServiceDirectoryPathModifiedByUser;
    private JBCheckBox myOfflineModeBox;

    public GradleSystemSettingsControl(@NotNull GradleSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/jetbrains/plugins/gradle/service/settings/GradleSystemSettingsControl", "<init>"));
        }
        this.myInitialSettings = settings;
    }

    public void fillUi(@NotNull PaintAwarePanel canvas, int indentLevel) {
        if (canvas == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "canvas", "org/jetbrains/plugins/gradle/service/settings/GradleSystemSettingsControl", "fillUi"));
        }
        this.myOfflineModeBox = new JBCheckBox(GradleBundle.message("gradle.settings.text.offline_work", new Object[0]));
        canvas.add((Component)this.myOfflineModeBox, (Object)ExternalSystemUiUtil.getFillLineConstraints((int)indentLevel));
        this.myServiceDirectoryLabel = new JBLabel(GradleBundle.message("gradle.settings.text.service.dir.path", new Object[0]));
        this.preparePathControl();
        canvas.add((Component)this.myServiceDirectoryLabel, (Object)ExternalSystemUiUtil.getLabelConstraints((int)indentLevel));
        canvas.add((Component)this.myServiceDirectoryPathField, (Object)ExternalSystemUiUtil.getFillLineConstraints((int)indentLevel));
        this.myGradleVmOptionsLabel = new JBLabel(GradleBundle.message("gradle.settings.text.vm.options", new Object[0]));
        canvas.add((Component)this.myGradleVmOptionsLabel, (Object)ExternalSystemUiUtil.getLabelConstraints((int)indentLevel));
        this.myGradleVmOptionsField = new JBTextField();
        canvas.add((Component)this.myGradleVmOptionsField, (Object)ExternalSystemUiUtil.getFillLineConstraints((int)indentLevel));
    }

    public void showUi(boolean show) {
        ExternalSystemUiUtil.showUi((Object)this, (boolean)show);
    }

    private void preparePathControl() {
        this.myServiceDirectoryPathField = new TextFieldWithBrowseButton();
        this.myServiceDirectoryPathField.addBrowseFolderListener("", GradleBundle.message("gradle.settings.title.service.dir.path", new Object[0]), null, new FileChooserDescriptor(false, true, false, false, false, false), TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT, false);
        this.myServiceDirectoryPathField.getTextField().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                GradleSystemSettingsControl.this.myServiceDirectoryPathModifiedByUser = true;
                GradleSystemSettingsControl.this.myServiceDirectoryPathField.getTextField().setForeground(LocationSettingType.EXPLICIT_CORRECT.getColor());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                GradleSystemSettingsControl.this.myServiceDirectoryPathModifiedByUser = true;
                GradleSystemSettingsControl.this.myServiceDirectoryPathField.getTextField().setForeground(LocationSettingType.EXPLICIT_CORRECT.getColor());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
    }

    public void reset() {
        this.myServiceDirectoryPathField.getTextField().setForeground(LocationSettingType.EXPLICIT_CORRECT.getColor());
        this.myServiceDirectoryPathField.setText("");
        String path = this.myInitialSettings.getServiceDirectoryPath();
        if (StringUtil.isEmpty((String)path)) {
            this.deduceServiceDirectoryIfPossible();
        } else {
            this.myServiceDirectoryPathField.setText(path);
        }
        this.myGradleVmOptionsField.setText(GradleSystemSettingsControl.trimIfPossible(this.myInitialSettings.getGradleVmOptions()));
        this.myOfflineModeBox.setSelected(this.myInitialSettings.isOfflineWork());
    }

    private void deduceServiceDirectoryIfPossible() {
        String path = System.getenv().get("GRADLE_USER_HOME");
        if (StringUtil.isEmpty((String)path)) {
            path = new File(System.getProperty("user.home"), ".gradle").getAbsolutePath();
        }
        this.myServiceDirectoryPathField.setText(path);
        this.myServiceDirectoryPathField.getTextField().setForeground(LocationSettingType.DEDUCED.getColor());
        this.myServiceDirectoryPathModifiedByUser = false;
    }

    public boolean isModified() {
        return this.myServiceDirectoryPathModifiedByUser && !Comparing.equal((String)ExternalSystemApiUtil.normalizePath((String)this.myServiceDirectoryPathField.getText()), (String)ExternalSystemApiUtil.normalizePath((String)this.myInitialSettings.getServiceDirectoryPath())) || !Comparing.equal((String)GradleSystemSettingsControl.trimIfPossible(this.myGradleVmOptionsField.getText()), (String)GradleSystemSettingsControl.trimIfPossible(this.myInitialSettings.getGradleVmOptions())) || this.myOfflineModeBox.isSelected() != this.myInitialSettings.isOfflineWork();
    }

    @Nullable
    private static String trimIfPossible(@Nullable String s) {
        if (s == null) {
            return null;
        }
        String result = s.trim();
        return result.isEmpty() ? null : result;
    }

    public void apply(@NotNull GradleSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/jetbrains/plugins/gradle/service/settings/GradleSystemSettingsControl", "apply"));
        }
        if (this.myServiceDirectoryPathModifiedByUser) {
            settings.setServiceDirectoryPath(ExternalSystemApiUtil.normalizePath((String)this.myServiceDirectoryPathField.getText()));
        }
        settings.setGradleVmOptions(GradleSystemSettingsControl.trimIfPossible(this.myGradleVmOptionsField.getText()));
        settings.setOfflineWork(this.myOfflineModeBox.isSelected());
    }

    public boolean validate(@NotNull GradleSettings settings) throws ConfigurationException {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/jetbrains/plugins/gradle/service/settings/GradleSystemSettingsControl", "validate"));
        }
        return true;
    }

    public void disposeUIResources() {
        ExternalSystemUiUtil.disposeUi((Object)this);
    }

    @NotNull
    public GradleSettings getInitialSettings() {
        GradleSettings gradleSettings = this.myInitialSettings;
        if (gradleSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/settings/GradleSystemSettingsControl", "getInitialSettings"));
        }
        return gradleSettings;
    }
}

