/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.config;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.roots.impl.storage.ClassPathStorageUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.idea.eclipse.EclipseModuleManager;
import org.jetbrains.idea.eclipse.config.CachedXmlDocumentSet;

@State(name="EclipseModuleManager", storages={@Storage(file="$MODULE_FILE$")})
public class EclipseModuleManagerImpl
implements EclipseModuleManager,
PersistentStateComponent<Element> {
    @NonNls
    private static final String VALUE_ATTR = "value";
    @NonNls
    private static final String VARELEMENT = "varelement";
    @NonNls
    private static final String VAR_ATTRIBUTE = "var";
    @NonNls
    private static final String CONELEMENT = "conelement";
    @NonNls
    private static final String FORCED_JDK = "forced_jdk";
    @NonNls
    private static final String SRC_DESCRIPTION = "src_description";
    @NonNls
    private static final String EXPECTED_POSITION = "expected_position";
    @NonNls
    private static final String SRC_FOLDER = "src_folder";
    private CachedXmlDocumentSet myDocumentSet;
    private final Map<String, String> myEclipseVariablePaths = new LinkedHashMap<String, String>();
    private final Set<String> myEclipseUrls = new LinkedHashSet<String>();
    private final Set<String> myUnknownCons = new LinkedHashSet<String>();
    private boolean myForceConfigureJDK = false;
    @NonNls
    private static final String SRC_PREFIX = "src:";
    @NonNls
    private static final String SRC_LINK_PREFIX = "linksrc:";
    @NonNls
    private static final String LINK_PREFIX = "link:";
    @NonNls
    private static final String PREFIX_ATTR = "kind";
    private final Module myModule;
    @NonNls
    private static final String LIBELEMENT = "libelement";
    private int myExpectedModuleSourcePlace;
    private Map<String, Integer> mySrcPlace = new LinkedHashMap<String, Integer>();
    private String myInvalidJdk;
    private Set<String> myKnownCons = new LinkedHashSet<String>();

    public EclipseModuleManagerImpl(Module module) {
        this.myModule = module;
    }

    public void setInvalidJdk(String invalidJdk) {
        this.myInvalidJdk = invalidJdk;
    }

    public String getInvalidJdk() {
        return this.myInvalidJdk;
    }

    public void registerCon(String name) {
        this.myKnownCons.add(name);
    }

    public String[] getUsedCons() {
        return ArrayUtil.toStringArray(this.myKnownCons);
    }

    public static EclipseModuleManagerImpl getInstance(Module module) {
        return (EclipseModuleManagerImpl)ModuleServiceManager.getService((Module)module, EclipseModuleManagerImpl.class);
    }

    public CachedXmlDocumentSet getDocumentSet() {
        return this.myDocumentSet;
    }

    public void setDocumentSet(CachedXmlDocumentSet documentSet) {
        this.myDocumentSet = documentSet;
    }

    public void registerEclipseVariablePath(String path, String var) {
        this.myEclipseVariablePaths.put(path, var);
    }

    public void registerEclipseSrcVariablePath(String path, String var) {
        this.myEclipseVariablePaths.put(SRC_PREFIX + path, var);
    }

    public void registerEclipseLinkedSrcVarPath(String path, String var) {
        this.myEclipseVariablePaths.put(SRC_LINK_PREFIX + path, var);
    }

    public String getEclipseLinkedSrcVariablePath(String path) {
        return this.myEclipseVariablePaths.get(SRC_LINK_PREFIX + path);
    }

    public void registerEclipseLinkedVarPath(String path, String var) {
        this.myEclipseVariablePaths.put(LINK_PREFIX + path, var);
    }

    public String getEclipseLinkedVarPath(String path) {
        return this.myEclipseVariablePaths.get(LINK_PREFIX + path);
    }

    public String getEclipseVariablePath(String path) {
        return this.myEclipseVariablePaths.get(path);
    }

    public String getEclipseSrcVariablePath(String path) {
        return this.myEclipseVariablePaths.get(SRC_PREFIX + path);
    }

    public void registerUnknownCons(String con) {
        this.myUnknownCons.add(con);
    }

    public Set<String> getUnknownCons() {
        return this.myUnknownCons;
    }

    public boolean isForceConfigureJDK() {
        return this.myForceConfigureJDK;
    }

    public void setForceConfigureJDK() {
        this.myForceConfigureJDK = true;
        ++this.myExpectedModuleSourcePlace;
    }

    public void registerEclipseLibUrl(String url) {
        this.myEclipseUrls.add(url);
    }

    public boolean isEclipseLibUrl(String url) {
        return this.myEclipseUrls.contains(url);
    }

    public Element getState() {
        if (!(ClassPathStorageUtil.getStorageType((Module)this.myModule).equals("eclipse") || this.myEclipseUrls.isEmpty() && this.myEclipseVariablePaths.isEmpty() && !this.myForceConfigureJDK && this.myUnknownCons.isEmpty())) {
            Element root = new Element("EclipseModuleSettings");
            for (String eclipseUrl : this.myEclipseUrls) {
                Element libElement = new Element(LIBELEMENT);
                libElement.setAttribute(VALUE_ATTR, eclipseUrl);
                root.addContent(libElement);
            }
            for (String var : this.myEclipseVariablePaths.keySet()) {
                Element varElement = new Element(VARELEMENT);
                if (var.startsWith(SRC_PREFIX)) {
                    varElement.setAttribute(VAR_ATTRIBUTE, StringUtil.trimStart((String)var, (String)SRC_PREFIX));
                    varElement.setAttribute(PREFIX_ATTR, SRC_PREFIX);
                } else if (var.startsWith(SRC_LINK_PREFIX)) {
                    varElement.setAttribute(VAR_ATTRIBUTE, StringUtil.trimStart((String)var, (String)SRC_LINK_PREFIX));
                    varElement.setAttribute(PREFIX_ATTR, SRC_LINK_PREFIX);
                } else if (var.startsWith(LINK_PREFIX)) {
                    varElement.setAttribute(VAR_ATTRIBUTE, StringUtil.trimStart((String)var, (String)LINK_PREFIX));
                    varElement.setAttribute(PREFIX_ATTR, LINK_PREFIX);
                } else {
                    varElement.setAttribute(VAR_ATTRIBUTE, var);
                }
                varElement.setAttribute(VALUE_ATTR, this.myEclipseVariablePaths.get(var));
                root.addContent(varElement);
            }
            for (String unknownCon : this.myUnknownCons) {
                Element conElement = new Element(CONELEMENT);
                conElement.setAttribute(VALUE_ATTR, unknownCon);
                root.addContent(conElement);
            }
            if (this.myForceConfigureJDK) {
                root.setAttribute(FORCED_JDK, String.valueOf(true));
            }
            Element srcDescriptionElement = new Element(SRC_DESCRIPTION);
            srcDescriptionElement.setAttribute(EXPECTED_POSITION, String.valueOf(this.myExpectedModuleSourcePlace));
            for (String srcUrl : this.mySrcPlace.keySet()) {
                Element srcFolder = new Element(SRC_FOLDER);
                srcFolder.setAttribute(VALUE_ATTR, srcUrl);
                srcFolder.setAttribute(EXPECTED_POSITION, this.mySrcPlace.get(srcUrl).toString());
                srcDescriptionElement.addContent(srcFolder);
            }
            root.addContent(srcDescriptionElement);
            return root;
        }
        return null;
    }

    public void loadState(Element state) {
        this.clear();
        for (Element o : state.getChildren(LIBELEMENT)) {
            this.myEclipseUrls.add(o.getAttributeValue(VALUE_ATTR));
        }
        for (Element o : state.getChildren(VARELEMENT)) {
            String prefix = o.getAttributeValue(PREFIX_ATTR);
            this.myEclipseVariablePaths.put(o.getAttributeValue(VAR_ATTRIBUTE), (prefix != null ? prefix : "") + o.getAttributeValue(VALUE_ATTR));
        }
        for (Element o : state.getChildren(CONELEMENT)) {
            this.myUnknownCons.add(o.getAttributeValue(VALUE_ATTR));
        }
        String forcedJdk = state.getAttributeValue(FORCED_JDK);
        this.myForceConfigureJDK = forcedJdk != null && Boolean.parseBoolean(forcedJdk);
        Element srcDescriptionElement = state.getChild(SRC_DESCRIPTION);
        if (srcDescriptionElement != null) {
            this.myExpectedModuleSourcePlace = Integer.parseInt(srcDescriptionElement.getAttributeValue(EXPECTED_POSITION));
            for (Element o : srcDescriptionElement.getChildren(SRC_FOLDER)) {
                this.mySrcPlace.put(o.getAttributeValue(VALUE_ATTR), Integer.parseInt(o.getAttributeValue(EXPECTED_POSITION)));
            }
        }
    }

    private void clear() {
        this.myEclipseUrls.clear();
        this.myEclipseVariablePaths.clear();
        this.myUnknownCons.clear();
        this.mySrcPlace.clear();
        this.myKnownCons.clear();
    }

    public void setExpectedModuleSourcePlace(int expectedModuleSourcePlace) {
        this.myExpectedModuleSourcePlace = expectedModuleSourcePlace;
    }

    public boolean isExpectedModuleSourcePlace(int expectedPlace) {
        return this.myExpectedModuleSourcePlace == expectedPlace;
    }

    public void registerSrcPlace(String srcUrl, int placeIdx) {
        this.mySrcPlace.put(srcUrl, placeIdx);
    }

    public Integer getSrcPlace(String srcUtl) {
        return this.mySrcPlace.get(srcUtl);
    }
}

