/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.maven.compiler;

import java.io.File;
import java.io.FileFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactRootCopyingHandlerProvider;
import org.jetbrains.jps.incremental.artifacts.instructions.FileCopyingHandler;
import org.jetbrains.jps.incremental.artifacts.instructions.FilterCopyHandler;
import org.jetbrains.jps.maven.model.JpsMavenExtensionService;
import org.jetbrains.jps.maven.model.impl.MavenEjbClientConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenProjectConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenResourceFileFilter;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElement;

public class MavenEjbArtifactRootCopyingHandlerProvider
extends ArtifactRootCopyingHandlerProvider {
    @Nullable
    public FileCopyingHandler createCustomHandler(@NotNull JpsArtifact artifact, @NotNull File root, @NotNull JpsPackagingElement contextElement, @NotNull JpsModel model, @NotNull BuildDataPaths buildDataPaths) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "org/jetbrains/jps/maven/compiler/MavenEjbArtifactRootCopyingHandlerProvider", "createCustomHandler"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/jps/maven/compiler/MavenEjbArtifactRootCopyingHandlerProvider", "createCustomHandler"));
        }
        if (contextElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextElement", "org/jetbrains/jps/maven/compiler/MavenEjbArtifactRootCopyingHandlerProvider", "createCustomHandler"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/jps/maven/compiler/MavenEjbArtifactRootCopyingHandlerProvider", "createCustomHandler"));
        }
        if (buildDataPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildDataPaths", "org/jetbrains/jps/maven/compiler/MavenEjbArtifactRootCopyingHandlerProvider", "createCustomHandler"));
        }
        JpsMavenExtensionService mavenExtensionService = JpsMavenExtensionService.getInstance();
        if (!mavenExtensionService.hasMavenProjectConfiguration(buildDataPaths)) {
            return null;
        }
        MavenProjectConfiguration projectConfiguration = mavenExtensionService.getMavenProjectConfiguration(buildDataPaths);
        MavenEjbClientConfiguration ejbCfg = projectConfiguration.ejbClientArtifactConfigs.get(artifact.getName());
        if (ejbCfg == null) {
            return null;
        }
        return new FilterCopyHandler((FileFilter)new MavenResourceFileFilter(root, ejbCfg));
    }
}

