/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.run;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.InvalidExpressionException;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.io.URLUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CustomRegexpFilter
implements Filter {
    public static final String FILE_PATH_MACROS = "$FILE_PATH$";
    public static final String LINE_MACROS = "$LINE$";
    public static final String COLUMN_MACROS = "$COLUMN$";
    private static final String DEFAULT_REGEXP = "((?:\\p{Alpha}\\:)?[0-9 a-z_A-Z\\-\\\\./]+)";
    private static final String NUMBER_REGEXP = "([0-9]+)";
    private int myFileRegister;
    private int myLineRegister;
    private int myColumnRegister;
    private Pattern myPattern;
    private Project myProject;
    private final VirtualFile myBase;
    private final String myFilePathRegexp;

    public CustomRegexpFilter(Project project, String expression, VirtualFile base) {
        this(project, expression, base, DEFAULT_REGEXP);
    }

    public CustomRegexpFilter(Project project, String expression, VirtualFile base, String filePathExpr) {
        this.myFilePathRegexp = filePathExpr;
        this.myProject = project;
        this.myBase = base;
        this.validate(expression);
        if (expression == null || "".equals(expression.trim())) {
            throw new InvalidExpressionException("expression == null or empty");
        }
        int filePathIndex = expression.indexOf(FILE_PATH_MACROS);
        int lineIndex = expression.indexOf(LINE_MACROS);
        int columnIndex = expression.indexOf(COLUMN_MACROS);
        if (filePathIndex == -1) {
            throw new InvalidExpressionException("Expression must contain $FILE_PATH$ macros.");
        }
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        map.put(new Integer(filePathIndex), "file");
        expression = StringUtil.replace((String)expression, (String)FILE_PATH_MACROS, (String)this.myFilePathRegexp);
        if (lineIndex != -1) {
            expression = StringUtil.replace((String)expression, (String)LINE_MACROS, (String)NUMBER_REGEXP);
            map.put(new Integer(lineIndex), "line");
        }
        if (columnIndex != -1) {
            expression = StringUtil.replace((String)expression, (String)COLUMN_MACROS, (String)NUMBER_REGEXP);
            map.put(new Integer(columnIndex), "column");
        }
        int count = 0;
        Iterator itr = map.keySet().iterator();
        while (itr.hasNext()) {
            ++count;
            String s = (String)map.get(itr.next());
            if ("file".equals(s)) {
                filePathIndex = count;
                continue;
            }
            if ("line".equals(s)) {
                lineIndex = count;
                continue;
            }
            if (!"column".equals(s)) continue;
            columnIndex = count;
        }
        this.myFileRegister = filePathIndex;
        this.myLineRegister = lineIndex;
        this.myColumnRegister = columnIndex;
        this.myPattern = Pattern.compile(expression, 8);
    }

    public void validate(String expression) {
        if (expression == null || "".equals(expression.trim())) {
            throw new InvalidExpressionException("expression == null or empty");
        }
        expression = this.substituteMacrosesWithRegexps(expression);
        Pattern.compile(expression, 8);
    }

    private String substituteMacrosesWithRegexps(String expression) {
        int filePathIndex = expression.indexOf(FILE_PATH_MACROS);
        int lineIndex = expression.indexOf(LINE_MACROS);
        int columnIndex = expression.indexOf(COLUMN_MACROS);
        if (filePathIndex == -1) {
            throw new InvalidExpressionException("Expression must contain $FILE_PATH$ macros.");
        }
        expression = StringUtil.replace((String)expression, (String)FILE_PATH_MACROS, (String)this.myFilePathRegexp);
        if (lineIndex != -1) {
            expression = StringUtil.replace((String)expression, (String)LINE_MACROS, (String)NUMBER_REGEXP);
        }
        if (columnIndex != -1) {
            expression = StringUtil.replace((String)expression, (String)COLUMN_MACROS, (String)NUMBER_REGEXP);
        }
        return expression;
    }

    public Filter.Result applyFilter(String line, int entireLength) {
        Matcher matcher = this.myPattern.matcher(line);
        if (matcher.find()) {
            return this.createResult(matcher, entireLength - line.length());
        }
        return null;
    }

    private Filter.Result createResult(Matcher matcher, int entireLen) {
        int highlightEndOffset;
        int highlightStartOffset;
        String filePath = matcher.group(this.myFileRegister);
        String lineNumber = "0";
        String columnNumber = "0";
        if (this.myLineRegister != -1) {
            lineNumber = matcher.group(this.myLineRegister);
        }
        if (this.myColumnRegister != -1) {
            columnNumber = matcher.group(this.myColumnRegister);
        }
        int line = 0;
        int column = 0;
        try {
            line = Integer.parseInt(lineNumber);
            column = Integer.parseInt(columnNumber);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (line > 0) {
            --line;
        }
        if (column > 0) {
            --column;
        }
        if ((filePath == null || filePath.length() == 0) && this.myLineRegister != -1) {
            highlightStartOffset = entireLen + matcher.start(this.myLineRegister);
            highlightEndOffset = highlightStartOffset + lineNumber.length();
        } else {
            highlightStartOffset = entireLen + matcher.start(this.myFileRegister);
            highlightEndOffset = highlightStartOffset + filePath.length();
        }
        HyperlinkInfo info = this.createOpenFileHyperlink(filePath, line, column);
        return info != null ? new Filter.Result(highlightStartOffset, highlightEndOffset, info) : null;
    }

    protected HyperlinkInfo createOpenFileHyperlink(String fileName, int line, int column) {
        VirtualFile file;
        if (fileName == null || fileName.length() == 0) {
            if (this.myBase != null) {
                fileName = this.myBase.getPresentableUrl();
            } else {
                return null;
            }
        }
        if (URLUtil.containsScheme((String)(fileName = fileName.replace(File.separatorChar, '/')))) {
            try {
                file = VfsUtil.findFileByURL((URL)new URL(fileName));
            }
            catch (MalformedURLException e) {
                file = VirtualFileManager.getInstance().findFileByUrl(VfsUtil.pathToUrl((String)fileName));
            }
        } else {
            file = VfsUtil.findRelativeFile((String)fileName, (VirtualFile)this.myBase);
        }
        if (file == null) {
            return null;
        }
        FileType fileType = file.getFileType();
        if (fileType != null && column > 0) {
            Document document = FileDocumentManager.getInstance().getDocument(file);
            int start = document.getLineStartOffset(line);
            int max = document.getLineEndOffset(line);
            int tabSize = CodeStyleSettingsManager.getInstance((Project)this.myProject).getCurrentSettings().getTabSize(fileType);
            column = EditorUtil.calcColumnNumber(null, (CharSequence)document.getCharsSequence(), (int)start, (int)Math.min(start + column, max), (int)tabSize);
        }
        return new OpenFileHyperlinkInfo(this.myProject, file, line, column);
    }

    public static String[] getMacrosName() {
        return new String[]{FILE_PATH_MACROS, LINE_MACROS, COLUMN_MACROS};
    }
}

