/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.IfHelper;
import org.jetbrains.java.decompiler.modules.decompiler.SequenceHelper;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ArrayExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ExitExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.MonitorExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.NewExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.SSAConstructorSparseEx;
import org.jetbrains.java.decompiler.modules.decompiler.stats.IfStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPaar;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.FastSparseSetFactory;

public class SimplifyExprentsHelper {
    private boolean firstInvocation;

    public SimplifyExprentsHelper(boolean firstInvocation) {
        this.firstInvocation = firstInvocation;
    }

    public boolean simplifyStackVarsStatement(Statement stat, HashSet<Integer> setReorderedIfs, SSAConstructorSparseEx ssa, StructClass cl) {
        boolean res = false;
        if (stat.getExprents() == null) {
            boolean changed;
            do {
                changed = false;
                for (Statement st : stat.getStats()) {
                    res |= this.simplifyStackVarsStatement(st, setReorderedIfs, ssa, cl);
                    changed = IfHelper.mergeIfs(st, setReorderedIfs);
                    if (!changed && !(changed = SimplifyExprentsHelper.buildIff(st, ssa))) continue;
                    break;
                }
                res |= changed;
            } while (changed);
        } else {
            res |= this.simplifyStackVarsExprents(stat.getExprents(), cl);
        }
        return res;
    }

    private boolean simplifyStackVarsExprents(List<Exprent> list, StructClass cl) {
        boolean res = false;
        int index = 0;
        while (index < list.size()) {
            Exprent current = list.get(index);
            Exprent ret = SimplifyExprentsHelper.isSimpleConstructorInvocation(current);
            if (ret != null) {
                list.set(index, ret);
                res = true;
                continue;
            }
            ret = SimplifyExprentsHelper.isLambda(current, cl);
            if (ret != null) {
                list.set(index, ret);
                res = true;
                continue;
            }
            if (SimplifyExprentsHelper.isMonitorExit(current)) {
                list.remove(index);
                res = true;
                continue;
            }
            if (SimplifyExprentsHelper.isTrivialStackAssignment(current)) {
                list.remove(index);
                res = true;
                continue;
            }
            if (index == list.size() - 1) break;
            Exprent next = list.get(index + 1);
            if (SimplifyExprentsHelper.isConstructorInvocationRemote(list, index)) {
                list.remove(index);
                res = true;
                continue;
            }
            if (DecompilerContext.getOption("rgn") && SimplifyExprentsHelper.isQualifiedNewGetClass(current, next)) {
                list.remove(index);
                res = true;
                continue;
            }
            int arrcount = SimplifyExprentsHelper.isArrayInitializer(list, index);
            if (arrcount > 0) {
                for (int i = 0; i < arrcount; ++i) {
                    list.remove(index + 1);
                }
                res = true;
                continue;
            }
            if (SimplifyExprentsHelper.addArrayInitializer(current, next)) {
                list.remove(index + 1);
                res = true;
                continue;
            }
            Exprent func = SimplifyExprentsHelper.isPPIorMMI(current);
            if (func != null) {
                list.set(index, func);
                res = true;
                continue;
            }
            if (SimplifyExprentsHelper.isIPPorIMM(current, next)) {
                list.remove(index + 1);
                res = true;
                continue;
            }
            if (SimplifyExprentsHelper.isStackAssignement(current, next)) {
                list.remove(index + 1);
                res = true;
                continue;
            }
            if (!this.firstInvocation && SimplifyExprentsHelper.isStackAssignement2(current, next)) {
                list.remove(index + 1);
                res = true;
                continue;
            }
            ++index;
        }
        return res;
    }

    private static boolean addArrayInitializer(Exprent first, Exprent second) {
        if (first.type == 2) {
            NewExprent newex;
            AssignmentExprent as = (AssignmentExprent)first;
            if (as.getRight().type == 10 && as.getLeft().type == 12 && !(newex = (NewExprent)as.getRight()).getLstArrayElements().isEmpty()) {
                VarExprent arrvar = (VarExprent)as.getLeft();
                if (second.type == 2) {
                    AssignmentExprent aas = (AssignmentExprent)second;
                    if (aas.getLeft().type == 1) {
                        int constvalue;
                        ArrayExprent arrex = (ArrayExprent)aas.getLeft();
                        if (arrex.getArray().type == 12 && arrvar.equals(arrex.getArray()) && arrex.getIndex().type == 3 && (constvalue = ((ConstExprent)arrex.getIndex()).getIntValue()) < newex.getLstArrayElements().size()) {
                            Exprent init = newex.getLstArrayElements().get(constvalue);
                            if (init.type == 3) {
                                Exprent tempexpr;
                                ConstExprent cinit = (ConstExprent)init;
                                VarType arrtype = newex.getNewtype().copy();
                                arrtype.decArrayDim();
                                ConstExprent defaultval = ExprProcessor.getDefaultArrayValue(arrtype);
                                if (cinit.equals(defaultval) && !(tempexpr = aas.getRight()).containsExprent(arrvar)) {
                                    newex.getLstArrayElements().set(constvalue, tempexpr);
                                    if (tempexpr.type == 10) {
                                        NewExprent tempnewex = (NewExprent)tempexpr;
                                        int dims = newex.getNewtype().arraydim;
                                        if (dims > 1 && !tempnewex.getLstArrayElements().isEmpty()) {
                                            tempnewex.setDirectArrayInit(true);
                                        }
                                    }
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private static int isArrayInitializer(List<Exprent> list, int index) {
        Exprent current = list.get(index);
        if (current.type == 2) {
            AssignmentExprent as = (AssignmentExprent)current;
            if (as.getRight().type == 10 && as.getLeft().type == 12) {
                NewExprent newex = (NewExprent)as.getRight();
                if (newex.getExprType().arraydim > 0 && newex.getLstDims().size() == 1 && newex.getLstArrayElements().isEmpty() && newex.getLstDims().get((int)0).type == 3) {
                    int size = (Integer)((ConstExprent)newex.getLstDims().get(0)).getValue();
                    if (size == 0) {
                        return 0;
                    }
                    VarExprent arrvar = (VarExprent)as.getLeft();
                    HashMap<Integer, Exprent> mapInit = new HashMap<Integer, Exprent>();
                    for (int i = 1; index + i < list.size() && i <= size; ++i) {
                        boolean found = false;
                        Exprent expr = list.get(index + i);
                        if (expr.type == 2) {
                            AssignmentExprent aas = (AssignmentExprent)expr;
                            if (aas.getLeft().type == 1) {
                                int constvalue;
                                ArrayExprent arrex = (ArrayExprent)aas.getLeft();
                                if (arrex.getArray().type == 12 && arrvar.equals(arrex.getArray()) && arrex.getIndex().type == 3 && (constvalue = ((ConstExprent)arrex.getIndex()).getIntValue()) < size && !mapInit.containsKey(constvalue) && !aas.getRight().containsExprent(arrvar)) {
                                    mapInit.put(constvalue, aas.getRight());
                                    found = true;
                                }
                            }
                        }
                        if (!found) break;
                    }
                    double fraction = (double)mapInit.size() / (double)size;
                    if (arrvar.isStack() && fraction > 0.0 || size <= 7 && fraction >= 0.3 || size > 7 && fraction >= 0.7) {
                        ArrayList<Exprent> lstRet = new ArrayList<Exprent>();
                        VarType arrtype = newex.getNewtype().copy();
                        arrtype.decArrayDim();
                        ConstExprent defaultval = ExprProcessor.getDefaultArrayValue(arrtype);
                        for (int j = 0; j < size; ++j) {
                            lstRet.add(defaultval.copy());
                        }
                        int dims = newex.getNewtype().arraydim;
                        for (Map.Entry ent : mapInit.entrySet()) {
                            Exprent tempexpr = (Exprent)ent.getValue();
                            lstRet.set((Integer)ent.getKey(), tempexpr);
                            if (tempexpr.type != 10) continue;
                            NewExprent tempnewex = (NewExprent)tempexpr;
                            if (dims <= 1 || tempnewex.getLstArrayElements().isEmpty()) continue;
                            tempnewex.setDirectArrayInit(true);
                        }
                        newex.setLstArrayElements(lstRet);
                        return mapInit.size();
                    }
                }
            }
        }
        return 0;
    }

    private static boolean isTrivialStackAssignment(Exprent first) {
        if (first.type == 2) {
            AssignmentExprent asf = (AssignmentExprent)first;
            if (asf.getLeft().type == 12 && asf.getRight().type == 12) {
                VarExprent varleft = (VarExprent)asf.getLeft();
                VarExprent varright = (VarExprent)asf.getRight();
                if (varleft.getIndex() == varright.getIndex() && varleft.isStack() && varright.isStack()) {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isStackAssignement2(Exprent first, Exprent second) {
        if (first.type == 2 && second.type == 2) {
            AssignmentExprent asf = (AssignmentExprent)first;
            AssignmentExprent ass = (AssignmentExprent)second;
            if (asf.getLeft().type == 12 && ass.getRight().type == 12 && asf.getLeft().equals(ass.getRight()) && ((VarExprent)asf.getLeft()).isStack() && (ass.getLeft().type != 12 || !((VarExprent)ass.getLeft()).isStack())) {
                asf.setRight(new AssignmentExprent(ass.getLeft(), asf.getRight()));
                return true;
            }
        }
        return false;
    }

    private static boolean isStackAssignement(Exprent first, Exprent second) {
        if (first.type == 2 && second.type == 2) {
            AssignmentExprent asf = (AssignmentExprent)first;
            AssignmentExprent ass = (AssignmentExprent)second;
            while (true) {
                if (asf.getRight().equals(ass.getRight()) && asf.getLeft().type == 12 && ((VarExprent)asf.getLeft()).isStack() && (ass.getLeft().type != 12 || !((VarExprent)ass.getLeft()).isStack()) && !ass.getLeft().containsExprent(asf.getLeft())) {
                    asf.setRight(ass);
                    return true;
                }
                if (asf.getRight().type != 2) break;
                asf = (AssignmentExprent)asf.getRight();
            }
        }
        return false;
    }

    private static Exprent isPPIorMMI(Exprent first) {
        if (first.type == 2) {
            FunctionExprent func;
            AssignmentExprent as = (AssignmentExprent)first;
            if (as.getRight().type == 6 && ((func = (FunctionExprent)as.getRight()).getFunctype() == 0 || func.getFunctype() == 1)) {
                Exprent econd = func.getLstOperands().get(0);
                Exprent econst = func.getLstOperands().get(1);
                if (econst.type != 3 && econd.type == 3 && func.getFunctype() == 0) {
                    econd = econst;
                    econst = func.getLstOperands().get(0);
                }
                if (econst.type == 3 && ((ConstExprent)econst).hasValueOne()) {
                    Exprent left = as.getLeft();
                    if (left.type != 12 && left.equals(econd)) {
                        FunctionExprent ret = new FunctionExprent(func.getFunctype() == 0 ? 35 : 33, Arrays.asList(econd));
                        ret.setImplicitType(VarType.VARTYPE_INT);
                        return ret;
                    }
                }
            }
        }
        return null;
    }

    private static boolean isIPPorIMM(Exprent first, Exprent second) {
        if (first.type == 2 && second.type == 6) {
            AssignmentExprent as = (AssignmentExprent)first;
            FunctionExprent in = (FunctionExprent)second;
            if ((in.getFunctype() == 33 || in.getFunctype() == 35) && in.getLstOperands().get(0).equals(as.getRight())) {
                if (in.getFunctype() == 33) {
                    in.setFunctype(32);
                } else {
                    in.setFunctype(34);
                }
                as.setRight(in);
                return true;
            }
        }
        return false;
    }

    private static boolean isMonitorExit(Exprent first) {
        MonitorExprent monexpr;
        return first.type == 9 && (monexpr = (MonitorExprent)first).getMontype() == 1 && monexpr.getValue().type == 12 && !((VarExprent)monexpr.getValue()).isStack();
    }

    private static boolean isQualifiedNewGetClass(Exprent first, Exprent second) {
        InvocationExprent invexpr;
        if (first.type == 8 && !(invexpr = (InvocationExprent)first).isStatic() && invexpr.getInstance().type == 12 && invexpr.getName().equals("getClass") && invexpr.getStringDescriptor().equals("()Ljava/lang/Class;")) {
            List<Exprent> lstExprents = second.getAllExprents();
            lstExprents.add(second);
            for (Exprent expr : lstExprents) {
                NewExprent nexpr;
                if (expr.type != 10 || (nexpr = (NewExprent)expr).getConstructor() == null || nexpr.getConstructor().getLstParameters().isEmpty() || !nexpr.getConstructor().getLstParameters().get(0).equals(invexpr.getInstance())) continue;
                String classname = nexpr.getNewtype().value;
                ClassesProcessor.ClassNode node = DecompilerContext.getClassProcessor().getMapRootClasses().get(classname);
                if (node == null || node.type == 0) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isConstructorInvocationRemote(List<Exprent> list, int index) {
        Exprent current = list.get(index);
        if (current.type == 2) {
            AssignmentExprent as = (AssignmentExprent)current;
            if (as.getLeft().type == 12 && as.getRight().type == 10) {
                NewExprent newexpr = (NewExprent)as.getRight();
                VarType newtype = newexpr.getNewtype();
                VarVersionPaar leftPaar = new VarVersionPaar((VarExprent)as.getLeft());
                if (newtype.type == 8 && newtype.arraydim == 0 && newexpr.getConstructor() == null) {
                    for (int i = index + 1; i < list.size(); ++i) {
                        InvocationExprent in;
                        Exprent remote = list.get(i);
                        if (remote.type == 8 && (in = (InvocationExprent)remote).getFunctype() == 2 && in.getInstance().type == 12 && as.getLeft().equals(in.getInstance())) {
                            newexpr.setConstructor(in);
                            in.setInstance(null);
                            list.set(i, as.copy());
                            return true;
                        }
                        Set<VarVersionPaar> setVars = remote.getAllVariables();
                        if (!setVars.contains(leftPaar)) continue;
                        return false;
                    }
                }
            }
        }
        return false;
    }

    private static Exprent isLambda(Exprent exprent, StructClass cl) {
        InvocationExprent in;
        List<Exprent> lst = exprent.getAllExprents();
        for (Exprent expr : lst) {
            Exprent ret = SimplifyExprentsHelper.isLambda(expr, cl);
            if (ret == null) continue;
            exprent.replaceExprent(expr, ret);
        }
        if (exprent.type == 8 && (in = (InvocationExprent)exprent).getInvocationTyp() == 5) {
            String lambda_class_name = cl.qualifiedName + in.getInvokeDynamicClassSuffix();
            ClassesProcessor.ClassNode lambda_class = DecompilerContext.getClassProcessor().getMapRootClasses().get(lambda_class_name);
            if (lambda_class != null) {
                NewExprent newexp = new NewExprent(new VarType(lambda_class_name, true), null, 0);
                newexp.setConstructor(in);
                return newexp;
            }
        }
        return null;
    }

    private static Exprent isSimpleConstructorInvocation(Exprent exprent) {
        InvocationExprent in;
        List<Exprent> lst = exprent.getAllExprents();
        for (Exprent expr : lst) {
            Exprent ret = SimplifyExprentsHelper.isSimpleConstructorInvocation(expr);
            if (ret == null) continue;
            exprent.replaceExprent(expr, ret);
        }
        if (exprent.type == 8 && (in = (InvocationExprent)exprent).getFunctype() == 2 && in.getInstance().type == 10) {
            NewExprent newexp = (NewExprent)in.getInstance();
            newexp.setConstructor(in);
            in.setInstance(null);
            return newexp;
        }
        return null;
    }

    private static boolean buildIff(Statement stat, SSAConstructorSparseEx ssa) {
        if (stat.type == 2 && stat.getExprents() == null) {
            IfStatement stif = (IfStatement)stat;
            if (stif.iftype == IfStatement.IFTYPE_IFELSE) {
                Statement ifstat = stif.getIfstat();
                Statement elsestat = stif.getElsestat();
                if (ifstat.getExprents() != null && ifstat.getExprents().size() == 1 && elsestat.getExprents() != null && elsestat.getExprents().size() == 1 && ifstat.getAllSuccessorEdges().size() == 1 && elsestat.getAllSuccessorEdges().size() == 1 && ifstat.getAllSuccessorEdges().get(0).getDestination() == elsestat.getAllSuccessorEdges().get(0).getDestination()) {
                    Exprent ifexpr = ifstat.getExprents().get(0);
                    Exprent elseexpr = elsestat.getExprents().get(0);
                    if (ifexpr.type == 2 && elseexpr.type == 2) {
                        AssignmentExprent ifas = (AssignmentExprent)ifexpr;
                        AssignmentExprent elseas = (AssignmentExprent)elseexpr;
                        if (ifas.getLeft().type == 12 && elseas.getLeft().type == 12) {
                            VarExprent ifvar = (VarExprent)ifas.getLeft();
                            VarExprent elsevar = (VarExprent)elseas.getLeft();
                            if (ifvar.getIndex() == elsevar.getIndex() && ifvar.isStack()) {
                                boolean found = false;
                                for (Map.Entry<VarVersionPaar, FastSparseSetFactory.FastSparseSet<Integer>> ent : ssa.getPhi().entrySet()) {
                                    if (ent.getKey().var != ifvar.getIndex() || !ent.getValue().contains(ifvar.getVersion()) || !ent.getValue().contains(elsevar.getVersion())) continue;
                                    found = true;
                                    break;
                                }
                                if (found) {
                                    ArrayList<Exprent> data = new ArrayList<Exprent>();
                                    data.addAll(stif.getFirst().getExprents());
                                    data.add(new AssignmentExprent(ifvar, new FunctionExprent(36, Arrays.asList(stif.getHeadexprent().getCondition(), ifas.getRight(), elseas.getRight()))));
                                    stif.setExprents(data);
                                    if (stif.getAllSuccessorEdges().isEmpty()) {
                                        StatEdge ifedge = ifstat.getAllSuccessorEdges().get(0);
                                        StatEdge edge = new StatEdge(ifedge.getType(), (Statement)stif, ifedge.getDestination());
                                        stif.addSuccessor(edge);
                                        if (ifedge.closure != null) {
                                            ifedge.closure.addLabeledEdge(edge);
                                        }
                                    }
                                    SequenceHelper.destroyAndFlattenStatement(stif);
                                    return true;
                                }
                            }
                        }
                    } else if (ifexpr.type == 4 && elseexpr.type == 4) {
                        ExitExprent ifex = (ExitExprent)ifexpr;
                        ExitExprent elseex = (ExitExprent)elseexpr;
                        if (ifex.getExittype() == elseex.getExittype() && ifex.getValue() != null && elseex.getValue() != null && ifex.getExittype() == 0) {
                            if (ifex.getExittype() == 1 && !ifex.getValue().getExprType().equals(elseex.getValue().getExprType())) {
                                return false;
                            }
                            ArrayList<Exprent> data = new ArrayList<Exprent>();
                            data.addAll(stif.getFirst().getExprents());
                            data.add(new ExitExprent(ifex.getExittype(), new FunctionExprent(36, Arrays.asList(stif.getHeadexprent().getCondition(), ifex.getValue(), elseex.getValue())), ifex.getRettype()));
                            stif.setExprents(data);
                            StatEdge retedge = ifstat.getAllSuccessorEdges().get(0);
                            stif.addSuccessor(new StatEdge(4, stif, retedge.getDestination(), retedge.closure == stif ? stif.getParent() : retedge.closure));
                            SequenceHelper.destroyAndFlattenStatement(stif);
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }
}

