/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.gen;

import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.java.decompiler.struct.gen.VarType;

public class MethodDescriptor {
    public VarType[] params;
    public VarType ret;

    public static MethodDescriptor parseDescriptor(String mdescr) {
        int i;
        MethodDescriptor md = new MethodDescriptor();
        ArrayList<String> lst = new ArrayList<String>();
        String[] pars = mdescr.split("[()]");
        String par = pars[1];
        int indexFrom = -1;
        int len = par.length();
        block4: for (int index = 0; index < len; ++index) {
            switch (par.charAt(index)) {
                case '[': {
                    if (indexFrom >= 0) continue block4;
                    indexFrom = index;
                    continue block4;
                }
                case 'L': {
                    int ind = par.indexOf(";", index);
                    lst.add(par.substring(indexFrom < 0 ? index : indexFrom, ind + 1));
                    index = ind;
                    indexFrom = -1;
                    continue block4;
                }
                default: {
                    lst.add(par.substring(indexFrom < 0 ? index : indexFrom, index + 1));
                    indexFrom = -1;
                }
            }
        }
        lst.add(pars[2]);
        md.params = new VarType[lst.size() - 1];
        for (i = 0; i < lst.size() - 1; ++i) {
            md.params[i] = new VarType((String)lst.get(i));
        }
        md.ret = new VarType((String)lst.get(i));
        return md;
    }

    public String getDescriptor() {
        String res = "(";
        for (int j = 0; j < this.params.length; ++j) {
            res = res + this.params[j].toString();
        }
        res = res + ")" + this.ret.toString();
        return res;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof MethodDescriptor)) {
            return false;
        }
        MethodDescriptor md = (MethodDescriptor)o;
        return this.ret.equals(md.ret) && Arrays.equals(this.params, md.params);
    }

    public int hashCode() {
        int result = this.ret.hashCode();
        result = 31 * result + this.params.length;
        return result;
    }
}

