/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.psi.codeStyle.FileTypeIndentOptionsProvider;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.ui.OptionGroup;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OtherTabsAndIndentsPanel
extends CodeStyleAbstractPanel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.application.options.GeneralCodeStylePanel");
    private JCheckBox myCbUseSameIndents;
    private final Map<FileType, IndentOptionsEditor> myAdditionalIndentOptions;
    private final List<FileTypeIndentOptionsProvider> myIndentOptionsProviders;
    private TabbedPaneWrapper myIndentOptionsTabs;
    private JPanel myIndentPanel;
    private JPanel myPreviewPanel;
    private JPanel myPanel;
    private final int myRightMargin;
    private int myLastSelectedTab;

    public OtherTabsAndIndentsPanel(CodeStyleSettings settings) {
        super(settings);
        this.$$$setupUI$$$();
        this.myAdditionalIndentOptions = new LinkedHashMap<FileType, IndentOptionsEditor>();
        this.myIndentOptionsProviders = new ArrayList<FileTypeIndentOptionsProvider>();
        this.myLastSelectedTab = 0;
        List<Object> indentOptionsProviders = Arrays.asList(Extensions.getExtensions((ExtensionPointName)FileTypeIndentOptionsProvider.EP_NAME));
        Collections.sort(indentOptionsProviders, new Comparator<FileTypeIndentOptionsProvider>(){

            @Override
            public int compare(FileTypeIndentOptionsProvider p1, FileTypeIndentOptionsProvider p2) {
                DisplayPriority priority2;
                Language lang1 = OtherTabsAndIndentsPanel.getLanguage(p1.getFileType());
                if (lang1 == null) {
                    return -1;
                }
                Language lang2 = OtherTabsAndIndentsPanel.getLanguage(p2.getFileType());
                if (lang2 == null) {
                    return 1;
                }
                DisplayPriority priority1 = LanguageCodeStyleSettingsProvider.getDisplayPriority((Language)lang1);
                if (priority1.equals((Object)(priority2 = LanguageCodeStyleSettingsProvider.getDisplayPriority((Language)lang2)))) {
                    return lang1.getDisplayName().compareTo(lang2.getDisplayName());
                }
                return priority1.compareTo((Enum)priority2);
            }
        });
        for (FileTypeIndentOptionsProvider fileTypeIndentOptionsProvider : indentOptionsProviders) {
            this.myIndentOptionsProviders.add(fileTypeIndentOptionsProvider);
            if (this.myAdditionalIndentOptions.containsKey(fileTypeIndentOptionsProvider.getFileType())) {
                LOG.error("Duplicate extension: " + fileTypeIndentOptionsProvider);
                continue;
            }
            this.myAdditionalIndentOptions.put(fileTypeIndentOptionsProvider.getFileType(), fileTypeIndentOptionsProvider.createOptionsEditor());
        }
        this.myIndentPanel.setLayout(new BorderLayout());
        this.myIndentPanel.add((Component)this.createTabOptionsPanel(), "Center");
        this.installPreviewPanel(this.myPreviewPanel);
        this.addPanelToWatch(this.myPanel);
        this.myRightMargin = settings.getDefaultRightMargin();
    }

    @Nullable
    private static Language getLanguage(FileType fileType) {
        return fileType instanceof LanguageFileType ? ((LanguageFileType)fileType).getLanguage() : null;
    }

    @Override
    protected void somethingChanged() {
        super.somethingChanged();
        this.update();
    }

    private void update() {
        boolean enabled;
        boolean bl = enabled = !this.myCbUseSameIndents.isSelected();
        if (this.myIndentOptionsTabs.getTabCount() <= 0) {
            return;
        }
        if (!enabled && this.myIndentOptionsTabs.getSelectedIndex() != 0) {
            this.myIndentOptionsTabs.setSelectedIndex(0);
        }
        int index = 0;
        for (IndentOptionsEditor options : this.myAdditionalIndentOptions.values()) {
            options.setEnabled(enabled);
            this.myIndentOptionsTabs.setEnabledAt(index, enabled);
            ++index;
        }
        if (this.myIndentOptionsTabs.getTabCount() > 0) {
            this.myIndentOptionsTabs.setEnabledAt(this.myIndentOptionsTabs.getTabCount() - 1, enabled);
        }
    }

    private JPanel createTabOptionsPanel() {
        OptionGroup optionGroup = new OptionGroup(null);
        this.myIndentOptionsTabs = new TabbedPaneWrapper(this);
        for (Map.Entry<FileType, IndentOptionsEditor> entry : this.myAdditionalIndentOptions.entrySet()) {
            FileType ft = entry.getKey();
            String tabName = ft instanceof LanguageFileType ? ((LanguageFileType)ft).getLanguage().getDisplayName() : ft.getName();
            this.myIndentOptionsTabs.addTab(tabName, entry.getValue().createPanel());
        }
        this.myIndentOptionsTabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int selIndex = OtherTabsAndIndentsPanel.this.myIndentOptionsTabs.getSelectedIndex();
                if (selIndex != OtherTabsAndIndentsPanel.this.myLastSelectedTab) {
                    OtherTabsAndIndentsPanel.this.myLastSelectedTab = selIndex;
                    OtherTabsAndIndentsPanel.this.updatePreview(true);
                    OtherTabsAndIndentsPanel.this.somethingChanged();
                }
            }
        });
        this.myIndentOptionsTabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                OtherTabsAndIndentsPanel.this.onTabChange();
            }
        });
        optionGroup.add(this.myIndentOptionsTabs.getComponent());
        this.myCbUseSameIndents = new JCheckBox(ApplicationBundle.message((String)"checkbox.indent.use.same.settings.for.all.file.types", (Object[])new Object[0]));
        optionGroup.add((JComponent)this.myCbUseSameIndents, true);
        return optionGroup.createPanel();
    }

    @Override
    protected int getRightMargin() {
        return this.myRightMargin;
    }

    @Override
    @NotNull
    protected FileType getFileType() {
        FileTypeIndentOptionsProvider provider = this.getSelectedIndentProvider();
        if (provider == null) {
            LanguageFileType languageFileType = FileTypes.PLAIN_TEXT;
            if (languageFileType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/OtherTabsAndIndentsPanel", "getFileType"));
            }
            return languageFileType;
        }
        FileType fileType = provider.getFileType();
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/OtherTabsAndIndentsPanel", "getFileType"));
        }
        return fileType;
    }

    @Override
    protected String getPreviewText() {
        FileTypeIndentOptionsProvider provider = this.getSelectedIndentProvider();
        if (provider != null) {
            return provider.getPreviewText();
        }
        return "";
    }

    @Nullable
    private FileTypeIndentOptionsProvider getSelectedIndentProvider() {
        if (this.myIndentOptionsTabs == null) {
            return OtherTabsAndIndentsPanel.getDefaultIndentProvider();
        }
        int selIndex = this.myIndentOptionsTabs.getSelectedIndex();
        if (selIndex >= 0 && selIndex < this.myIndentOptionsProviders.size()) {
            return this.myIndentOptionsProviders.get(selIndex);
        }
        return OtherTabsAndIndentsPanel.getDefaultIndentProvider();
    }

    @Nullable
    private static FileTypeIndentOptionsProvider getDefaultIndentProvider() {
        FileTypeIndentOptionsProvider[] providers = (FileTypeIndentOptionsProvider[])Extensions.getExtensions((ExtensionPointName)FileTypeIndentOptionsProvider.EP_NAME);
        return providers.length == 0 ? null : providers[0];
    }

    @Override
    public void apply(CodeStyleSettings settings) {
        settings.USE_SAME_INDENTS = this.myCbUseSameIndents.isSelected();
        if (!settings.USE_SAME_INDENTS) {
            for (Map.Entry<FileType, IndentOptionsEditor> entry : this.myAdditionalIndentOptions.entrySet()) {
                FileType fileType = entry.getKey();
                CommonCodeStyleSettings.IndentOptions additionalIndentOptions = settings.getAdditionalIndentOptions(fileType);
                if (additionalIndentOptions == null) continue;
                IndentOptionsEditor editor = entry.getValue();
                editor.apply(settings, additionalIndentOptions);
            }
        }
    }

    @Override
    public boolean isModified(CodeStyleSettings settings) {
        if (this.myCbUseSameIndents.isSelected() != settings.USE_SAME_INDENTS) {
            return true;
        }
        if (!settings.USE_SAME_INDENTS) {
            for (Map.Entry<FileType, IndentOptionsEditor> entry : this.myAdditionalIndentOptions.entrySet()) {
                IndentOptionsEditor editor;
                FileType fileType = entry.getKey();
                CommonCodeStyleSettings.IndentOptions additionalIndentOptions = settings.getAdditionalIndentOptions(fileType);
                if (additionalIndentOptions == null || !(editor = entry.getValue()).isModified(settings, additionalIndentOptions)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public JComponent getPanel() {
        return this.myPanel;
    }

    @Override
    protected void resetImpl(CodeStyleSettings settings) {
        this.myCbUseSameIndents.setSelected(settings.USE_SAME_INDENTS);
        for (Map.Entry<FileType, IndentOptionsEditor> entry : this.myAdditionalIndentOptions.entrySet()) {
            IndentOptionsEditor editor = entry.getValue();
            FileType type = entry.getKey();
            CommonCodeStyleSettings.IndentOptions additionalIndentOptions = settings.getAdditionalIndentOptions(type);
            if (additionalIndentOptions == null) continue;
            editor.reset(settings, additionalIndentOptions);
        }
        this.update();
    }

    @Override
    protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
        return EditorHighlighterFactory.getInstance().createEditorHighlighter(this.getFileType(), scheme, null);
    }

    @Override
    protected void prepareForReformat(PsiFile psiFile) {
        FileTypeIndentOptionsProvider provider = this.getSelectedIndentProvider();
        if (provider != null) {
            provider.prepareForReformat(psiFile);
        }
    }

    private void onTabChange() {
        this.getLanguageSelector().setLanguage(this.getSelectedLanguage());
    }

    @Nullable
    private Language getSelectedLanguage() {
        int selectedIndex = this.myIndentOptionsTabs.getSelectedIndex();
        int i = 0;
        for (Map.Entry<FileType, IndentOptionsEditor> entry : this.myAdditionalIndentOptions.entrySet()) {
            if (i == selectedIndex) {
                FileType ft = entry.getKey();
                if (ft instanceof LanguageFileType) {
                    return ((LanguageFileType)ft).getLanguage();
                }
                return null;
            }
            ++i;
        }
        return null;
    }

    @Override
    public Language getDefaultLanguage() {
        return this.getSelectedLanguage();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, "West");
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myIndentPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myPreviewPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, "Center");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

