/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.util;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.GridBag;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class TitleWithToolbar
extends JPanel {
    public TitleWithToolbar(@NotNull String title, @NotNull String actionGroupId, @NotNull String place, @NotNull JComponent targetComponent) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/application/options/codeStyle/arrangement/util/TitleWithToolbar", "<init>"));
        }
        if (actionGroupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionGroupId", "com/intellij/application/options/codeStyle/arrangement/util/TitleWithToolbar", "<init>"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/application/options/codeStyle/arrangement/util/TitleWithToolbar", "<init>"));
        }
        if (targetComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetComponent", "com/intellij/application/options/codeStyle/arrangement/util/TitleWithToolbar", "<init>"));
        }
        super(new GridBagLayout());
        ActionManager actionManager = ActionManager.getInstance();
        ActionGroup group = (ActionGroup)actionManager.getAction(actionGroupId);
        ActionToolbar actionToolbar = actionManager.createActionToolbar(place, group, true);
        actionToolbar.setTargetComponent(targetComponent);
        this.add((Component)new MyTitleComponent(title), new GridBag().weightx(1.0).anchor(17).fillCellHorizontally());
        this.add((Component)actionToolbar.getComponent(), new GridBag().anchor(10));
    }

    private class MyTitleComponent
    extends JComponent {
        @NotNull
        private final Border myBorder;

        MyTitleComponent(String title) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/application/options/codeStyle/arrangement/util/TitleWithToolbar$MyTitleComponent", "<init>"));
            }
            this.myBorder = IdeBorderFactory.createTitledBorder((String)title);
        }

        @Override
        public Dimension getPreferredSize() {
            Insets insets = this.myBorder.getBorderInsets(TitleWithToolbar.this);
            return new Dimension(1, insets.top);
        }

        @Override
        protected void paintComponent(Graphics g) {
            Rectangle bounds = this.getBounds();
            this.myBorder.paintBorder(this, g, bounds.x, bounds.y, bounds.width, bounds.height);
        }
    }
}

