/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.emmet;

import com.intellij.codeInsight.template.emmet.filters.ZenCodingFilter;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ExportableComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.xml.XmlBundle;
import java.io.File;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="EmmetOptions", storages={@Storage(file="$APP_CONFIG$/emmet.xml")})
public class EmmetOptions
implements PersistentStateComponent<EmmetOptions>,
ExportableComponent {
    private boolean myBemFilterEnabledByDefault = false;
    private boolean myEmmetEnabled = true;
    private int myEmmetExpandShortcut = 9;
    private boolean myFuzzySearchEnabled = true;
    private boolean myAutoInsertCssPrefixedEnabled = true;
    private boolean myPreviewEnabled = false;
    private Set<String> myFiltersEnabledByDefault = ContainerUtil.newHashSet();
    @NotNull
    private Map<String, Integer> prefixes = ContainerUtil.newHashMap();

    public boolean isBemFilterEnabledByDefault() {
        return this.myBemFilterEnabledByDefault;
    }

    public void setBemFilterEnabledByDefault(boolean enableBemFilterByDefault) {
        this.myBemFilterEnabledByDefault = enableBemFilterByDefault;
    }

    @NotNull
    public Set<String> getFiltersEnabledByDefault() {
        Set<String> set = this.myFiltersEnabledByDefault;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/emmet/EmmetOptions", "getFiltersEnabledByDefault"));
        }
        return set;
    }

    public void setFiltersEnabledByDefault(@NotNull Set<String> filtersEnabledByDefault) {
        if (filtersEnabledByDefault == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filtersEnabledByDefault", "com/intellij/application/options/emmet/EmmetOptions", "setFiltersEnabledByDefault"));
        }
        this.myFiltersEnabledByDefault = filtersEnabledByDefault;
    }

    public boolean isFilterEnabledByDefault(@NotNull ZenCodingFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/application/options/emmet/EmmetOptions", "isFilterEnabledByDefault"));
        }
        return this.myFiltersEnabledByDefault.contains(filter.getSuffix());
    }

    public void setEmmetExpandShortcut(int emmetExpandShortcut) {
        this.myEmmetExpandShortcut = emmetExpandShortcut;
    }

    public int getEmmetExpandShortcut() {
        return this.myEmmetExpandShortcut;
    }

    public boolean isPreviewEnabled() {
        return this.myPreviewEnabled;
    }

    public void setPreviewEnabled(boolean previewEnabled) {
        this.myPreviewEnabled = previewEnabled;
    }

    public boolean isEmmetEnabled() {
        return this.myEmmetEnabled;
    }

    public void setEmmetEnabled(boolean emmetEnabled) {
        this.myEmmetEnabled = emmetEnabled;
    }

    @Deprecated
    public boolean isAutoInsertCssPrefixedEnabled() {
        return this.myAutoInsertCssPrefixedEnabled;
    }

    @Deprecated
    public void setAutoInsertCssPrefixedEnabled(boolean autoInsertCssPrefixedEnabled) {
        this.myAutoInsertCssPrefixedEnabled = autoInsertCssPrefixedEnabled;
    }

    @Deprecated
    public void setFuzzySearchEnabled(boolean fuzzySearchEnabled) {
        this.myFuzzySearchEnabled = fuzzySearchEnabled;
    }

    @Deprecated
    public boolean isFuzzySearchEnabled() {
        return this.myFuzzySearchEnabled;
    }

    @NotNull
    public File[] getExportFiles() {
        File[] fileArray = new File[]{PathManager.getOptionsFile((String)"emmet")};
        if (fileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/emmet/EmmetOptions", "getExportFiles"));
        }
        return fileArray;
    }

    @NotNull
    public String getPresentableName() {
        String string = XmlBundle.message((String)"emmet.configuration.title", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/emmet/EmmetOptions", "getPresentableName"));
        }
        return string;
    }

    @Nullable
    public EmmetOptions getState() {
        return this;
    }

    public void loadState(EmmetOptions state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
        if (this.myFiltersEnabledByDefault.isEmpty() && this.myBemFilterEnabledByDefault) {
            this.myFiltersEnabledByDefault.add("bem");
        }
    }

    public static EmmetOptions getInstance() {
        return (EmmetOptions)ServiceManager.getService(EmmetOptions.class);
    }

    @Deprecated
    @NotNull
    public Map<String, Integer> getPrefixes() {
        Map<String, Integer> map = this.prefixes;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/emmet/EmmetOptions", "getPrefixes"));
        }
        return map;
    }

    @Deprecated
    public void setPrefixes(@NotNull Map<String, Integer> prefixes) {
        if (prefixes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefixes", "com/intellij/application/options/emmet/EmmetOptions", "setPrefixes"));
        }
        this.prefixes = prefixes;
    }
}

