/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedMembersSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public class FunctionalInterfaceSuggester {
    public static Collection<? extends PsiType> suggestFunctionalInterfaces(final @NotNull PsiFunctionalExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/FunctionalInterfaceSuggester", "suggestFunctionalInterfaces"));
        }
        Project project = expression.getProject();
        PsiClass functionalInterfaceClass = JavaPsiFacade.getInstance((Project)project).findClass("java.lang.FunctionalInterface", GlobalSearchScope.allScope((Project)project));
        if (functionalInterfaceClass == null) {
            return Collections.emptyList();
        }
        final LinkedHashSet types = new LinkedHashSet();
        AnnotatedMembersSearch.search((PsiClass)functionalInterfaceClass, (SearchScope)expression.getResolveScope()).forEach((Processor)new Processor<PsiMember>(){

            public boolean process(PsiMember member) {
                if (member instanceof PsiClass) {
                    ContainerUtil.addIfNotNull((Collection)types, (Object)FunctionalInterfaceSuggester.composeAcceptableType((PsiClass)member, expression));
                }
                return true;
            }
        });
        return types;
    }

    private static PsiType composeAcceptableType(@NotNull PsiClass interface2Consider, @NotNull PsiFunctionalExpression expression) {
        if (interface2Consider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interface2Consider", "com/intellij/codeInsight/FunctionalInterfaceSuggester", "composeAcceptableType"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/FunctionalInterfaceSuggester", "composeAcceptableType"));
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)interface2Consider.getProject());
        PsiClassType type = elementFactory.createType(interface2Consider, PsiSubstitutor.EMPTY);
        if (expression.isAcceptable((PsiType)type)) {
            return type;
        }
        return FunctionalInterfaceSuggester.composeAcceptableType(interface2Consider, expression, elementFactory);
    }

    private static PsiType composeAcceptableType(PsiClass interface2Consider, PsiFunctionalExpression expression, PsiElementFactory elementFactory) {
        PsiMethod interfaceMethod;
        if (interface2Consider.hasTypeParameters() && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClass)interface2Consider)) != null) {
            PsiParameter[] functionalExprParameters;
            PsiParameter[] parameters = interfaceMethod.getParameterList().getParameters();
            if (expression instanceof PsiLambdaExpression && ((PsiLambdaExpression)expression).hasFormalParameterTypes()) {
                functionalExprParameters = ((PsiLambdaExpression)expression).getParameterList().getParameters();
            } else if (expression instanceof PsiMethodReferenceExpression && ((PsiMethodReferenceExpression)expression).isExact()) {
                PsiElement exactMethod = ((PsiMethodReferenceExpression)expression).resolve();
                if (!(exactMethod instanceof PsiMethod)) {
                    return null;
                }
                functionalExprParameters = ((PsiMethod)exactMethod).getParameterList().getParameters();
            } else {
                return null;
            }
            if (parameters.length != functionalExprParameters.length) {
                return null;
            }
            PsiType[] left = new PsiType[parameters.length];
            PsiType[] right = new PsiType[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                left[i] = parameters[i].getType();
                right[i] = functionalExprParameters[i].getType();
            }
            PsiSubstitutor substitutor = PsiResolveHelper.SERVICE.getInstance((Project)interface2Consider.getProject()).inferTypeArguments(interface2Consider.getTypeParameters(), left, right, PsiUtil.getLanguageLevel((PsiElement)expression));
            PsiClassType type = elementFactory.createType(interface2Consider, substitutor);
            if (expression.isAcceptable((PsiType)type)) {
                return type;
            }
        }
        return null;
    }
}

