/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.EncapsulatableClassMember;
import com.intellij.codeInsight.generation.GenerateGetterSetterHandlerBase;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.codeInsight.generation.PropertyClassMember;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.util.IncorrectOperationException;

public class GenerateGetterHandler
extends GenerateGetterSetterHandlerBase {
    public GenerateGetterHandler() {
        super(CodeInsightBundle.message((String)"generate.getter.fields.chooser.title", (Object[])new Object[0]));
    }

    @Override
    protected ClassMember[] chooseOriginalMembers(PsiClass aClass, Project project) {
        if (aClass.isInterface()) {
            return ClassMember.EMPTY_ARRAY;
        }
        return super.chooseOriginalMembers(aClass, project);
    }

    @Override
    protected GenerationInfo[] generateMemberPrototypes(PsiClass aClass, ClassMember original) throws IncorrectOperationException {
        EncapsulatableClassMember encapsulatableClassMember;
        GenerationInfo getter;
        if (original instanceof PropertyClassMember) {
            PropertyClassMember propertyClassMember = (PropertyClassMember)original;
            GenerationInfo[] getters = propertyClassMember.generateGetters(aClass);
            if (getters != null) {
                return getters;
            }
        } else if (original instanceof EncapsulatableClassMember && (getter = (encapsulatableClassMember = (EncapsulatableClassMember)original).generateGetter()) != null) {
            return new GenerationInfo[]{getter};
        }
        return GenerationInfo.EMPTY_ARRAY;
    }

    @Override
    protected String getNothingFoundMessage() {
        return "No fields have been found to generate getters for";
    }

    @Override
    protected String getNothingAcceptedMessage() {
        return "No fields without getter were found";
    }
}

