/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.actions.FileFilterPanel;
import com.intellij.codeInspection.actions.GotoInspectionModel;
import com.intellij.codeInspection.actions.RunInspectionIntention;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.ide.util.gotoByName.ChooseByNameFilter;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.SearchScope;
import java.util.Arrays;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunInspectionAction
extends GotoActionBase {
    private static final Logger LOGGER = Logger.getInstance((String)("#" + RunInspectionAction.class.getName()));

    public RunInspectionAction() {
        this.getTemplatePresentation().setText(IdeBundle.message((String)"goto.inspection.action.text", (Object[])new Object[0]));
    }

    @Override
    protected void gotoActionPerformed(AnActionEvent e) {
        final Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        final PsiElement psiElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(e.getDataContext());
        final PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(e.getDataContext());
        final VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext());
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.goto.inspection");
        GotoInspectionModel model = new GotoInspectionModel(project);
        this.showNavigationPopup(e, model, new GotoActionBase.GotoActionCallback<Object>(){

            @Override
            protected ChooseByNameFilter<Object> createFilter(@NotNull ChooseByNamePopup popup) {
                if (popup == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/codeInspection/actions/RunInspectionAction$1", "createFilter"));
                }
                popup.setSearchInAnyPlace(true);
                return super.createFilter(popup);
            }

            @Override
            public void elementChosen(ChooseByNamePopup popup, final Object element) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RunInspectionAction.runInspection(project, ((InspectionToolWrapper)element).getShortName(), virtualFile, psiElement, psiFile);
                    }
                });
            }
        }, false);
    }

    private static void runInspection(@NotNull Project project, @NotNull String shortName, @Nullable VirtualFile virtualFile, PsiElement psiElement, PsiFile psiFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/actions/RunInspectionAction", "runInspection"));
        }
        if (shortName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortName", "com/intellij/codeInspection/actions/RunInspectionAction", "runInspection"));
        }
        InspectionManagerEx managerEx = (InspectionManagerEx)InspectionManager.getInstance((Project)project);
        Module module = virtualFile != null ? ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project) : null;
        AnalysisScope analysisScope = null;
        if (psiFile != null) {
            analysisScope = new AnalysisScope(psiFile);
        } else {
            PsiDirectory psiDirectory;
            if (virtualFile != null && virtualFile.isDirectory() && (psiDirectory = PsiManager.getInstance((Project)project).findDirectory(virtualFile)) != null) {
                analysisScope = new AnalysisScope(psiDirectory);
            }
            if (analysisScope == null && virtualFile != null) {
                analysisScope = new AnalysisScope(project, Arrays.asList(virtualFile));
            }
            if (analysisScope == null) {
                analysisScope = new AnalysisScope(project);
            }
        }
        final FileFilterPanel fileFilterPanel = new FileFilterPanel();
        fileFilterPanel.init();
        BaseAnalysisActionDialog dialog = new BaseAnalysisActionDialog(AnalysisScopeBundle.message((String)"specify.analysis.scope", (Object[])new Object[]{InspectionsBundle.message((String)"inspection.action.title", (Object[])new Object[0])}), AnalysisScopeBundle.message((String)"analysis.scope.title", (Object[])new Object[]{InspectionsBundle.message((String)"inspection.action.noun", (Object[])new Object[0])}), project, analysisScope, module != null ? module.getName() : null, true, AnalysisUIOptions.getInstance(project), psiElement){

            @Override
            protected JComponent getAdditionalActionSettings(Project project) {
                return fileFilterPanel.getPanel();
            }

            @Override
            @NotNull
            public AnalysisScope getScope(@NotNull AnalysisUIOptions uiOptions, @NotNull AnalysisScope defaultScope, @NotNull Project project, Module module) {
                if (uiOptions == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiOptions", "com/intellij/codeInspection/actions/RunInspectionAction$2", "getScope"));
                }
                if (defaultScope == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultScope", "com/intellij/codeInspection/actions/RunInspectionAction$2", "getScope"));
                }
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/actions/RunInspectionAction$2", "getScope"));
                }
                AnalysisScope scope = super.getScope(uiOptions, defaultScope, project, module);
                SearchScope filterScope = fileFilterPanel.getSearchScope();
                if (filterScope == null) {
                    AnalysisScope analysisScope = scope;
                    if (analysisScope == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/actions/RunInspectionAction$2", "getScope"));
                    }
                    return analysisScope;
                }
                SearchScope filteredScope = filterScope.intersectWith(scope.toSearchScope());
                AnalysisScope analysisScope = new AnalysisScope(filteredScope, project);
                if (analysisScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/actions/RunInspectionAction$2", "getScope"));
                }
                return analysisScope;
            }
        };
        dialog.show();
        if (!dialog.isOK()) {
            return;
        }
        AnalysisUIOptions uiOptions = AnalysisUIOptions.getInstance(project);
        AnalysisScope scope = dialog.getScope(uiOptions, analysisScope, project, module);
        PsiElement element = psiFile == null ? psiElement : psiFile;
        InspectionProfile currentProfile = InspectionProjectProfileManager.getInstance(project).getInspectionProfile();
        InspectionToolWrapper toolWrapper = currentProfile.getInspectionTool(shortName, project);
        LOGGER.assertTrue(toolWrapper != null, (Object)("Missed inspection: " + shortName));
        RunInspectionIntention.rerunInspection(toolWrapper, managerEx, scope, element);
    }
}

