/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.BytecodeAnalysisConverter;
import com.intellij.codeInspection.bytecodeAnalysis.BytecodeAnalysisIndex;
import com.intellij.codeInspection.bytecodeAnalysis.Bytes;
import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.DirectionResultPair;
import com.intellij.codeInspection.bytecodeAnalysis.ELattice;
import com.intellij.codeInspection.bytecodeAnalysis.EquationsLimitException;
import com.intellij.codeInspection.bytecodeAnalysis.HComponent;
import com.intellij.codeInspection.bytecodeAnalysis.HEquation;
import com.intellij.codeInspection.bytecodeAnalysis.HEquations;
import com.intellij.codeInspection.bytecodeAnalysis.HKey;
import com.intellij.codeInspection.bytecodeAnalysis.HPending;
import com.intellij.codeInspection.bytecodeAnalysis.HResult;
import com.intellij.codeInspection.bytecodeAnalysis.MethodAnnotations;
import com.intellij.codeInspection.bytecodeAnalysis.ParameterAnnotations;
import com.intellij.codeInspection.bytecodeAnalysis.Solver;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.Stack;
import com.intellij.util.indexing.FileBasedIndex;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectBytecodeAnalysis {
    public static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.bytecodeAnalysis");
    public static final Key<Boolean> INFERRED_ANNOTATION = Key.create((String)"INFERRED_ANNOTATION");
    public static final String NULLABLE_METHOD = "java.annotations.inference.nullable.method";
    public static final String NULLABLE_METHOD_TRANSITIVITY = "java.annotations.inference.nullable.method.transitivity";
    public static final int EQUATIONS_LIMIT = 1000;
    private final Project myProject;
    private final boolean nullableMethod;
    private final boolean nullableMethodTransitivity;

    public static ProjectBytecodeAnalysis getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "getInstance"));
        }
        return (ProjectBytecodeAnalysis)ServiceManager.getService((Project)project, ProjectBytecodeAnalysis.class);
    }

    public ProjectBytecodeAnalysis(Project project) {
        this.myProject = project;
        this.nullableMethod = Registry.is((String)NULLABLE_METHOD);
        this.nullableMethodTransitivity = Registry.is((String)NULLABLE_METHOD_TRANSITIVITY);
    }

    @Nullable
    public PsiAnnotation findInferredAnnotation(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "findInferredAnnotation"));
        }
        if (annotationFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationFQN", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "findInferredAnnotation"));
        }
        if (!(listOwner instanceof PsiCompiledElement)) {
            return null;
        }
        if (annotationFQN.equals("org.jetbrains.annotations.NotNull") || annotationFQN.equals("org.jetbrains.annotations.Nullable") || annotationFQN.equals(ControlFlowAnalyzer.ORG_JETBRAINS_ANNOTATIONS_CONTRACT)) {
            PsiAnnotation[] annotations;
            for (PsiAnnotation annotation : annotations = this.findInferredAnnotations(listOwner)) {
                if (!annotationFQN.equals(annotation.getQualifiedName())) continue;
                return annotation;
            }
            return null;
        }
        return null;
    }

    @NotNull
    public PsiAnnotation[] findInferredAnnotations(final @NotNull PsiModifierListOwner listOwner) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "findInferredAnnotations"));
        }
        if (!(listOwner instanceof PsiCompiledElement)) {
            if (PsiAnnotation.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "findInferredAnnotations"));
            }
            return PsiAnnotation.EMPTY_ARRAY;
        }
        PsiAnnotation[] psiAnnotationArray = (PsiAnnotation[])CachedValuesManager.getCachedValue((PsiElement)listOwner, (CachedValueProvider)new CachedValueProvider<PsiAnnotation[]>(){

            @Nullable
            public CachedValueProvider.Result<PsiAnnotation[]> compute() {
                return CachedValueProvider.Result.create((Object)ProjectBytecodeAnalysis.this.collectInferredAnnotations(listOwner), (Object[])new Object[]{listOwner});
            }
        });
        if (psiAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "findInferredAnnotations"));
        }
        return psiAnnotationArray;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    private PsiAnnotation[] collectInferredAnnotations(PsiModifierListOwner listOwner) {
        block29: {
            block25: {
                block28: {
                    block26: {
                        block27: {
                            block23: {
                                block24: {
                                    block21: {
                                        block22: {
                                            block19: {
                                                block20: {
                                                    block17: {
                                                        block18: {
                                                            block15: {
                                                                block16: {
                                                                    block13: {
                                                                        block14: {
                                                                            md = BytecodeAnalysisConverter.getMessageDigest();
                                                                            primaryKey = ProjectBytecodeAnalysis.getKey(listOwner, md);
                                                                            if (primaryKey != null) break block13;
                                                                            if (PsiAnnotation.EMPTY_ARRAY != null) break block14;
                                                                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "collectInferredAnnotations"}));
                                                                        }
                                                                        return PsiAnnotation.EMPTY_ARRAY;
                                                                    }
                                                                    if (!(listOwner instanceof PsiMethod)) ** GOTO lbl58
                                                                    allKeys = ProjectBytecodeAnalysis.contractKeys((PsiMethod)listOwner, primaryKey);
                                                                    methodAnnotations = this.loadMethodAnnotations((PsiMethod)listOwner, primaryKey, allKeys);
                                                                    notNull = methodAnnotations.notNulls.contains(primaryKey);
                                                                    nullable = methodAnnotations.nullables.contains(primaryKey);
                                                                    contractValue = methodAnnotations.contracts.get(primaryKey);
                                                                    if (!notNull || contractValue == null) break block15;
                                                                    v0 = new PsiAnnotation[]{this.getNotNullAnnotation(), this.createAnnotationFromText("@" + ControlFlowAnalyzer.ORG_JETBRAINS_ANNOTATIONS_CONTRACT + "(" + contractValue + ")")};
                                                                    if (v0 != null) break block16;
                                                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "collectInferredAnnotations"}));
                                                                }
                                                                return v0;
                                                            }
                                                            if (!nullable || contractValue == null) break block17;
                                                            v1 = new PsiAnnotation[]{this.getNullableAnnotation(), this.createAnnotationFromText("@" + ControlFlowAnalyzer.ORG_JETBRAINS_ANNOTATIONS_CONTRACT + "(" + contractValue + ")")};
                                                            if (v1 != null) break block18;
                                                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "collectInferredAnnotations"}));
                                                        }
                                                        return v1;
                                                    }
                                                    if (!notNull) break block19;
                                                    v2 = new PsiAnnotation[]{this.getNotNullAnnotation()};
                                                    if (v2 != null) break block20;
                                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "collectInferredAnnotations"}));
                                                }
                                                return v2;
                                            }
                                            if (!nullable) break block21;
                                            v3 = new PsiAnnotation[]{this.getNullableAnnotation()};
                                            if (v3 != null) break block22;
                                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "collectInferredAnnotations"}));
                                        }
                                        return v3;
                                    }
                                    if (contractValue == null) break block23;
                                    v4 = new PsiAnnotation[]{this.createAnnotationFromText("@" + ControlFlowAnalyzer.ORG_JETBRAINS_ANNOTATIONS_CONTRACT + "(" + contractValue + ")")};
                                    if (v4 != null) break block24;
                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "collectInferredAnnotations"}));
                                }
                                return v4;
                            }
                            break block25;
lbl58:
                            // 1 sources

                            if (!(listOwner instanceof PsiParameter)) break block25;
                            parameterAnnotations = this.loadParameterAnnotations(primaryKey);
                            if (!parameterAnnotations.notNull) break block26;
                            v5 = new PsiAnnotation[]{this.getNotNullAnnotation()};
                            if (v5 != null) break block27;
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "collectInferredAnnotations"}));
                        }
                        return v5;
                    }
                    if (!parameterAnnotations.nullable) break block25;
                    v6 = new PsiAnnotation[]{this.getNullableAnnotation()};
                    if (v6 != null) break block28;
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "collectInferredAnnotations"}));
                }
                return v6;
            }
            try {
                if (PsiAnnotation.EMPTY_ARRAY != null) break block29;
            }
            catch (EquationsLimitException e) {
                externalName = PsiFormatUtil.getExternalName((PsiModifierListOwner)listOwner, (boolean)false, (int)0x7FFFFFFF);
                ProjectBytecodeAnalysis.LOG.info("Too many equations for " + externalName);
                if (PsiAnnotation.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "collectInferredAnnotations"}));
                }
                return PsiAnnotation.EMPTY_ARRAY;
            }
            catch (NoSuchAlgorithmException e) {
                ProjectBytecodeAnalysis.LOG.error((Throwable)e);
                if (PsiAnnotation.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "collectInferredAnnotations"}));
                }
                return PsiAnnotation.EMPTY_ARRAY;
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "collectInferredAnnotations"}));
        }
        return PsiAnnotation.EMPTY_ARRAY;
    }

    private PsiAnnotation getNotNullAnnotation() {
        return (PsiAnnotation)CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)this.myProject, (CachedValueProvider)new CachedValueProvider<PsiAnnotation>(){

            @Nullable
            public CachedValueProvider.Result<PsiAnnotation> compute() {
                return CachedValueProvider.Result.create((Object)ProjectBytecodeAnalysis.this.createAnnotationFromText("@org.jetbrains.annotations.NotNull"), (Object[])new Object[]{ModificationTracker.NEVER_CHANGED});
            }
        });
    }

    private PsiAnnotation getNullableAnnotation() {
        return (PsiAnnotation)CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)this.myProject, (CachedValueProvider)new CachedValueProvider<PsiAnnotation>(){

            @Nullable
            public CachedValueProvider.Result<PsiAnnotation> compute() {
                return CachedValueProvider.Result.create((Object)ProjectBytecodeAnalysis.this.createAnnotationFromText("@org.jetbrains.annotations.Nullable"), (Object[])new Object[]{ModificationTracker.NEVER_CHANGED});
            }
        });
    }

    public PsiAnnotation createContractAnnotation(String contractValue) {
        return this.createAnnotationFromText("@org.jetbrains.annotations.Contract(" + contractValue + ")");
    }

    @Nullable
    public static HKey getKey(@NotNull PsiModifierListOwner owner, MessageDigest md) {
        PsiElement gParent;
        PsiElement parent;
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "getKey"));
        }
        LOG.assertTrue(owner instanceof PsiCompiledElement, (Object)owner);
        if (owner instanceof PsiMethod) {
            return BytecodeAnalysisConverter.psiKey((PsiMethod)owner, Direction.Out, md);
        }
        if (owner instanceof PsiParameter && (parent = owner.getParent()) instanceof PsiParameterList && (gParent = parent.getParent()) instanceof PsiMethod) {
            int index = ((PsiParameterList)parent).getParameterIndex((PsiParameter)owner);
            return BytecodeAnalysisConverter.psiKey((PsiMethod)gParent, new Direction.In(index, 0), md);
        }
        return null;
    }

    public static ArrayList<HKey> contractKeys(@NotNull PsiMethod owner, HKey primaryKey) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "contractKeys"));
        }
        ArrayList<HKey> result = BytecodeAnalysisConverter.mkInOutKeys(owner, primaryKey);
        result.add(primaryKey);
        return result;
    }

    private ParameterAnnotations loadParameterAnnotations(@NotNull HKey notNullKey) throws EquationsLimitException {
        if (notNullKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notNullKey", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "loadParameterAnnotations"));
        }
        HashMap<Bytes, List<HEquations>> equationsCache = new HashMap<Bytes, List<HEquations>>();
        Solver notNullSolver = new Solver(new ELattice<Value>(Value.NotNull, Value.Top), Value.Top);
        this.collectEquations(Collections.singletonList(notNullKey), notNullSolver, equationsCache);
        HashMap<HKey, Value> notNullSolutions = notNullSolver.solve();
        boolean notNull = Value.NotNull == notNullSolutions.get(notNullKey) || Value.NotNull == notNullSolutions.get(notNullKey.mkUnstable());
        Solver nullableSolver = new Solver(new ELattice<Value>(Value.Null, Value.Top), Value.Top);
        HKey nullableKey = new HKey(notNullKey.key, notNullKey.dirKey + 1, true);
        this.collectEquations(Collections.singletonList(nullableKey), nullableSolver, equationsCache);
        HashMap<HKey, Value> nullableSolutions = nullableSolver.solve();
        boolean nullable = Value.Null == nullableSolutions.get(nullableKey) || Value.Null == nullableSolutions.get(nullableKey.mkUnstable());
        return new ParameterAnnotations(notNull, nullable);
    }

    private MethodAnnotations loadMethodAnnotations(@NotNull PsiMethod owner, @NotNull HKey key, ArrayList<HKey> allKeys) throws EquationsLimitException {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "loadMethodAnnotations"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "loadMethodAnnotations"));
        }
        MethodAnnotations result = new MethodAnnotations();
        HashMap<Bytes, List<HEquations>> equationsCache = new HashMap<Bytes, List<HEquations>>();
        Solver outSolver = new Solver(new ELattice<Value>(Value.Bot, Value.Top), Value.Top);
        this.collectEquations(allKeys, outSolver, equationsCache);
        HashMap<HKey, Value> solutions = outSolver.solve();
        int arity = owner.getParameterList().getParameters().length;
        BytecodeAnalysisConverter.addMethodAnnotations(solutions, result, key, arity);
        if (this.nullableMethod) {
            Solver nullableMethodSolver = new Solver(new ELattice<Value>(Value.Bot, Value.Null), Value.Bot);
            HKey nullableKey = key.updateDirection(BytecodeAnalysisConverter.mkDirectionKey(Direction.NullableOut));
            if (this.nullableMethodTransitivity) {
                this.collectEquations(Collections.singletonList(nullableKey), nullableMethodSolver, equationsCache);
            } else {
                this.collectSingleEquation(nullableKey, nullableMethodSolver, equationsCache);
            }
            HashMap<HKey, Value> nullableSolutions = nullableMethodSolver.solve();
            if (nullableSolutions.get(nullableKey) == Value.Null || nullableSolutions.get(nullableKey.negate()) == Value.Null) {
                result.nullables.add(key);
            }
        }
        return result;
    }

    private void collectEquations(List<HKey> keys, Solver solver, @NotNull Map<Bytes, List<HEquations>> cache) throws EquationsLimitException {
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "collectEquations"));
        }
        GlobalSearchScope librariesScope = ProjectScope.getLibrariesScope((Project)this.myProject);
        HashSet<HKey> queued = new HashSet<HKey>();
        Stack queue = new Stack();
        for (HKey key : keys) {
            queue.push((Object)key);
            queued.add(key);
        }
        FileBasedIndex index = FileBasedIndex.getInstance();
        while (!queue.empty()) {
            if (queued.size() > 1000) {
                throw new EquationsLimitException();
            }
            ProgressManager.checkCanceled();
            HKey hKey = (HKey)queue.pop();
            Bytes bytes = new Bytes(hKey.key);
            List hEquationss = cache.get(bytes);
            if (hEquationss == null) {
                hEquationss = index.getValues(BytecodeAnalysisIndex.NAME, (Object)bytes, librariesScope);
                cache.put(bytes, hEquationss);
            }
            for (HEquations hEquations : hEquationss) {
                boolean stable = hEquations.stable;
                for (DirectionResultPair pair : hEquations.results) {
                    int dirKey = pair.directionKey;
                    if (dirKey != hKey.dirKey) continue;
                    HResult result = pair.hResult;
                    solver.addEquation(new HEquation(new HKey(bytes.bytes, dirKey, stable), result));
                    if (!(result instanceof HPending)) continue;
                    HPending pending = (HPending)result;
                    for (HComponent component : pending.delta) {
                        for (HKey depKey : component.ids) {
                            if (queued.contains(depKey)) continue;
                            queue.push((Object)depKey);
                            queued.add(depKey);
                        }
                    }
                }
            }
        }
    }

    private void collectSingleEquation(HKey hKey, Solver solver, @NotNull Map<Bytes, List<HEquations>> cache) throws EquationsLimitException {
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "collectSingleEquation"));
        }
        GlobalSearchScope librariesScope = ProjectScope.getLibrariesScope((Project)this.myProject);
        FileBasedIndex index = FileBasedIndex.getInstance();
        ProgressManager.checkCanceled();
        Bytes bytes = new Bytes(hKey.key);
        List hEquationss = cache.get(bytes);
        if (hEquationss == null) {
            hEquationss = index.getValues(BytecodeAnalysisIndex.NAME, (Object)bytes, librariesScope);
            cache.put(bytes, hEquationss);
        }
        for (HEquations hEquations : hEquationss) {
            boolean stable = hEquations.stable;
            for (DirectionResultPair pair : hEquations.results) {
                int dirKey = pair.directionKey;
                if (dirKey != hKey.dirKey) continue;
                HResult result = pair.hResult;
                solver.addEquation(new HEquation(new HKey(bytes.bytes, dirKey, stable), result));
            }
        }
    }

    @NotNull
    private PsiAnnotation createAnnotationFromText(@NotNull String text) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "createAnnotationFromText"));
        }
        PsiAnnotation annotation = JavaPsiFacade.getElementFactory((Project)this.myProject).createAnnotationFromText(text, null);
        annotation.putUserData(INFERRED_ANNOTATION, (Object)Boolean.TRUE);
        PsiAnnotation psiAnnotation = annotation;
        if (psiAnnotation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "createAnnotationFromText"));
        }
        return psiAnnotation;
    }
}

